
function dragonImageObscure(dragonOptions, imgPath) {
    
    OpenSeadragon.setString("Tooltips.FullPage", "Full Screen");
    OpenSeadragon.setString("Tooltips.SelectionToggle", "Open Face Selection");
    OpenSeadragon.setString("Tooltips.SelectionConfirm", "Selection Confirm");
    OpenSeadragon.setString("Tooltips.ImageTools", "Image Adjustments");
    OpenSeadragon.setString("Tool.brightness", "Brightness");
    OpenSeadragon.setString("Tool.contrast", "Contrast");
    OpenSeadragon.setString("Tool.gamma", "Gamma");
    OpenSeadragon.setString("Tool.reset", "Reset");
    OpenSeadragon.setString("Tool.close", "Save");
    viewerObscure = OpenSeadragon(dragonOptions);
    var overlaysMap={};
    var rectanglesMap={};
    var filterValues={};
    
    var brightnessDefaultValue=0; 
    var contrastDefaultValue=1; 
    var gammaDefaultValue=1; 
    
   

    let selectImageButtonObscure = new OpenSeadragon.Button({
        tooltip: 'Select this image',
        srcRest: imgPath.restImagePath,
        srcGroup: imgPath.groupImagePath,
        srcHover: imgPath.hoverImagePath,
        srcDown: imgPath.downImagePath,
        onClick: () => {
            let selectedTile = viewerObscure.tileSources[viewerObscure.currentPage()];
            //debugger;
            selectedTile.isSelected = !selectedTile.isSelected;
            if (selectedTile.isSelected) {
                //\$('#selectedFrame').val(viewerObscure.currentPage());
                selectImageButtonObscure.imgGroup.src = imgPath.selectedImagePath;
                selection.toggleButton.element.style.visibility = 'visible';
                resetGroupSelection(selectedTile);
            }
            else {
                //\$('#selectedFrame').val(-1);
                selectImageButtonObscure.imgGroup.src = imgPath.groupImagePath;
                selection.disable();
                selection.toggleButton.element.style.visibility = 'hidden';
            }
            removeOverlay(getOverlayId());
            removeCroppedData(getOverlayId());

         

        }
    });


    viewerObscure.scalebar({
        type: OpenSeadragon.ScalebarType.MAP,
        pixelsPerMeter: 3.356,
        minWidth: "75px",
        location: OpenSeadragon.ScalebarLocation.BOTTOM_RIGHT,
        xOffset: 5,
        yOffset: 10,
        stayInsideImage: true,
        color: "rgb(255, 255, 355,0.2)",
        fontColor: "rgb(255, 255, 255)",
        backgroundColor: "rgba(0, 0, 0)",
        fontSize: "small",
        sizeAndTextRenderer: OpenSeadragon.ScalebarSizeAndTextRenderer.KRIA_DESCRIPTION,
        barThickness: 2
    });
    
    viewerObscure.addControl(selectImageButtonObscure.element, { anchor: OpenSeadragon.ControlAnchor.TOP_LEFT });

    viewerObscure.addHandler('open', () => {

        viewerObscure.viewport.goHome();
        let selectedTile = viewerObscure.tileSources[viewerObscure.currentPage()];
        if (selectedTile.isSelected) {
            selection.toggleButton.element.style.visibility = 'visible';
            selectImageButton.imgGroup.src = imgPath.selectedImagePath;
            addOverlay(getOverlayId(), false);
        } else {
            selection.disable();
            selectImageButtonObscure.imgGroup.src = imgPath.groupImagePath;
            selection.toggleButton.element.style.visibility = 'hidden';
            removeOverlay(getOverlayId());
        }
        if (selectedTile.isGenerated) {
            if (!(getOverlayId() in filterValues)) {
                addFiltersForElement(getOverlayId());
            }
            restoreFilterValues();
            if (typeof filters == "undefined") {
                addFilters();
            }
            filters.toggleButton.element.style.visibility = 'visible';
        } else {
            if (typeof filters != "undefined") {
                filters.hideToolsPanel();
                filters.toggleButton.element.style.visibility = 'hidden';
                filters.resetFilters();
            }
        }
        //debugger;
        if (selectedTile.isSelectable) {
            selectImageButtonObscure.element.style.visibility = 'visible';
        } else {
            selectImageButtonObscure.element.style.visibility = 'hidden';
        }
    });

    let selection = viewerObscure.selection({
        allowRotation: false,
        restrictToImage: true,
        returnPixelCoordinates: false,
        onSelection: function (rect) {
            //debugger;
            let convertedRect = selection.viewer.viewport.viewportToImageRectangle(rect);
            let currentTile = viewerObscure.tileSources[viewerObscure.currentPage()];
            currentTile.croppedX = convertedRect.x;
            currentTile.croppedY = convertedRect.y;
            currentTile.croppedWidth = convertedRect.width;
            currentTile.croppedHeight = convertedRect.height;
            currentTile.croppedAreaPresent = 1;
            selection.toggleState();
            removeOverlay(getOverlayId());
            rectanglesMap[getOverlayId()] = rect;
            addOverlay(getOverlayId(), true);
           
            resetSelection(viewerObscure.tileSources[viewerObscure.currentPage()]);
            

        }
    });

    selection.toggleButton.addHandler('release', () => {
            viewerObscure.tileSources[viewerObscure.currentPage()].croppedAreaPresent = 0;
            viewerObscure.tileSources[viewerObscure.currentPage()].hasNewCroppedData = false;
            removeCroppedData(getOverlayId());
    });
    $(window).on('load', function () {
        $('#save-Obscure').click((event) => {
            viewerObscure.tileSources.forEach(function(currentTile) {
           /* console.log(currentTile.croppedX);
            console.log(currentTile.croppedY);
            console.log(currentTile.croppedWidth);
            console.log(currentTile.croppedHeight);
            console.log(currentTile.croppedAreaPresent);*/
            if(currentTile.croppedAreaPresent == 1){
                console.log(currentTile);

                $.ajax({
                    url: "../DragonImageObscureChangeXML",
                    type: "post",
                    data: currentTile,
                    success: function (response) {                 
                        location.reload();
                     },
                     error: function(jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                     }
                });


            }

                });
           
        })
    });
  
   
    function addFiltersForElement(elementId) {
        filterValues[getOverlayId()] = {
            brightness: brightnessDefaultValue,
            contrast: contrastDefaultValue,
            gamma: gammaDefaultValue
        };
    }

    function removeCurrentGroupGenerated(referenceTile) {
        return viewerObscure.tileSources.filter(
            function (currentItem) {
                return (currentItem.isGenerated &&
                    (currentItem.sectionGroup != referenceTile.sectionGroup ||
                        currentItem.croppingType != referenceTile.croppingType)) ||
                    !currentItem.isGenerated;
            }
        );
    }
    
    function removeCroppedData(overlayId) {
        viewerObscure.tileSources = removeCurrentGroupGenerated(viewerObscure.tileSources[viewerObscure.currentPage()]);
        delete filterValues[overlayId];
        removeOverlay(overlayId);
        overlaysMap[overlayId] = null;
        rectanglesMap[overlayId] = null;
        convertedRect = null;
    }
   
    function addOverlay(overlayId, createElement = false) {
        if (createElement) {
            createOverlayElement(overlayId);
        }
        viewerObscure.addOverlay({
            element: overlaysMap[overlayId],
            location: rectanglesMap[overlayId]
        });
    }
    function createOverlayElement(overlayId) {
        if (overlayId in overlaysMap) {
            delete overlaysMap[overlayId];
        }
        overlaysMap[overlayId] = document.createElement('div');
        overlaysMap[overlayId].id = overlayId;
        overlaysMap[overlayId].className = 'highlight';
    }
    function addFilters() {

        filters =
            viewerObscure.imagefilters(
                {
                    toolsWidth: 180,
                    toolsHeight: 200,
                    toolsTop: 35
                }
            );
        viewerObscure.goToPage(viewerObscure.currentPage());
    }

    function getOverlayId(selectedPage = -1) {
        if (selectedPage < 0) {
            selectedPage = viewerObscure.currentPage();
        }
        let selectedTile = viewerObscure.tileSources[selectedPage];
        return selectedTile.sectionGroup + "-" + selectedTile.croppingType;
    }

    function removeOverlay(overlayId) {
        if (overlaysMap[overlayId] !== undefined) {
            viewerObscure.removeOverlay(overlayId);
        }
    }

    function resetSelection(TileSelected) {
        viewerObscure.tileSources.forEach(
            function (currentTile) {
                
               if(currentTile !== TileSelected){
                    
                        currentTile.isSelected = false;
                        currentTile.croppedAreaPresent = 0;
                        currentTile.hasNewCroppedData = false;
                        currentTile.croppedX = -1;
                        currentTile.croppedY = -1;
                        currentTile.croppedWidth = -1;
                        currentTile.croppedHeight = -1;
                    }
            }
        );
    }

    

    

}