!function () {
    "use strict";
    function t(t, r) {
        r = r || {};
        var o = r.filters;
        t.filters = o ? i.isArray(o) ? o : [o] : [];
        for (var a = 0; a < t.filters.length; a++) {
            var u = t.filters[a];
            if (!u.processors)
                throw new Error("Filter processors must be specified.");
            u.processors = i.isArray(u.processors) ? u.processors : [u.processors]
        }
        if (t.filterIncrement++,
                "sync" === r.loadMode)
            t.viewer.forceRedraw();
        else {
            for (var s = [], a = 0; a < t.filters.length; a++) {
                var u = t.filters[a];
                if (!u.items) {
                    s = n(t.viewer.world);
                    break
                }
                if (i.isArray(u.items))
                    for (var c = 0; c < u.items.length; c++)
                        e(u.items[c], s);
                else
                    e(u.items, s)
            }
            for (var a = 0; a < s.length; a++)
                s[a].reset()
        }
    }
    function e(t, e) {
        if (e.indexOf(t) >= 0)
            throw new Error("An item can not have filters assigned multiple times.");
        e.push(t)
    }
    function n(t) {
        for (var e = [], n = 0; n < t.getItemCount(); n++)
            e.push(t.getItemAt(n));
        return e
    }
    function r(t, e) {
        if (0 === t.filters.length)
            return [];
        for (var n = null, r = 0; r < t.filters.length; r++) {
            var o = t.filters[r];
            if (o.items) {
                if (o.items === e || i.isArray(o.items) && o.items.indexOf(e) >= 0)
                    return o.processors
            } else
                n = o.processors
        }
        return n ? n : []
    }
    var i = window.OpenSeadragon;
    if (!i && (i = require("openseadragon"),
            !i))
        throw new Error("OpenSeadragon is missing.");
    if (!i.version || i.version.major < 2 || 2 === i.version.major && i.version.minor < 1)
        throw new Error("Filtering plugin requires OpenSeadragon version >= 2.1");
    i.Viewer.prototype.setFilterOptions = function (e) {
        this.filterPluginInstance ? t(this.filterPluginInstance, e) : (e = e || {},
                e.viewer = this,
                this.filterPluginInstance = new i.FilterPlugin(e))
    }
    ,
            i.FilterPlugin = function (e) {
                function n(t) {
                    var e = r(a, t.tiledImage);
                    if (0 !== e.length) {
                        var n = t.tile
                                , o = t.image;
                        if (null !== o) {
                            var u = window.document.createElement("canvas");
                            u.width = o.width,
                                    u.height = o.height;
                            var s = u.getContext("2d");
                            s.drawImage(o, 0, 0),
                                    n._renderedContext = s;
                            var c = t.getCompletionCallback();
                            i(s, e, c),
                                    n._filterIncrement = a.filterIncrement
                        }
                    }
                }
                function i(t, e, n) {
                    if (n) {
                        for (var r = a.filterIncrement, i = [], o = 0; o < e.length - 1; o++)
                            !function (n) {
                                i[n] = function () {
                                    a.filterIncrement === r && e[n + 1](t, i[n + 1])
                                }
                            }(o);
                        i[e.length - 1] = function () {
                            a.filterIncrement === r && n()
                        }
                        ,
                                e[0](t, i[0])
                    } else
                        for (var o = 0; o < e.length; o++)
                            e[o](t, function () {})
                }
                function o(t) {
                    var e = t.tile
                            , n = t.rendered;
                    if (n._filterIncrement !== a.filterIncrement) {
                        var o = r(a, t.tiledImage);
                        if (0 === o.length)
                            return n._originalImageData && (n.putImageData(n._originalImageData, 0, 0),
                                    delete n._originalImageData),
                                    void (n._filterIncrement = a.filterIncrement);
                        if (n._originalImageData ? n.putImageData(n._originalImageData, 0, 0) : n._originalImageData = n.getImageData(0, 0, n.canvas.width, n.canvas.height),
                                e._renderedContext) {
                            if (e._filterIncrement === a.filterIncrement) {
                                var u = e._renderedContext.getImageData(0, 0, e._renderedContext.canvas.width, e._renderedContext.canvas.height);
                                return n.putImageData(u, 0, 0),
                                        delete e._renderedContext,
                                        delete e._filterIncrement,
                                        void (n._filterIncrement = a.filterIncrement)
                            }
                            delete e._renderedContext,
                                    delete e._filterIncrement
                        }
                        i(n, o),
                                n._filterIncrement = a.filterIncrement
                    }
                }
                if (e = e || {},
                        !e.viewer)
                    throw new Error("A viewer must be specified.");
                var a = this;
                this.viewer = e.viewer,
                        this.viewer.addHandler("tile-loaded", n),
                        this.viewer.addHandler("tile-drawing", o),
                        this.filterIncrement = 0,
                        t(this, e)
            }
    ,
            i.Filters = {
                THRESHOLDING: function (t) {
                    if (t < 0 || t > 255)
                        throw new Error("Threshold must be between 0 and 255.");
                    return function (e, n) {
                        for (var r = e.getImageData(0, 0, e.canvas.width, e.canvas.height), i = r.data, o = 0; o < i.length; o += 4) {
                            var a = i[o]
                                    , u = i[o + 1]
                                    , s = i[o + 2]
                                    , c = (a + u + s) / 3;
                            i[o] = i[o + 1] = i[o + 2] = c < t ? 0 : 255
                        }
                        e.putImageData(r, 0, 0),
                                n()
                    }
                },
                BRIGHTNESS: function (t) {
                    if (t < -255 || t > 255)
                        throw new Error("Brightness adjustment must be between -255 and 255.");
                    return function (e, n) {
                        for (var r = e.getImageData(0, 0, e.canvas.width, e.canvas.height), i = r.data, o = 0; o < i.length; o += 4)
                            i[o] += t,
                                    i[o + 1] += t,
                                    i[o + 2] += t;
                        e.putImageData(r, 0, 0),
                                n()
                    }
                },
                CONTRAST: function (t) {
                    if (t < 0)
                        throw new Error("Contrast adjustment must be positive.");
                    return function (e, n) {
                        for (var r = e.getImageData(0, 0, e.canvas.width, e.canvas.height), i = r.data, o = 0; o < i.length; o += 4)
                            i[o] *= t,
                                    i[o + 1] *= t,
                                    i[o + 2] *= t;
                        e.putImageData(r, 0, 0),
                                n()
                    }
                },
                GAMMA: function (t) {
                    if (t < 0)
                        throw new Error("Gamma adjustment must be positive.");
                    return function (e, n) {
                        for (var r = e.getImageData(0, 0, e.canvas.width, e.canvas.height), i = r.data, o = 0; o < i.length; o += 4)
                            i[o] = 255 * Math.pow(i[o] / 255, t),
                                    i[o + 1] = 255 * Math.pow(i[o + 1] / 255, t),
                                    i[o + 2] = 255 * Math.pow(i[o + 2] / 255, t);
                        e.putImageData(r, 0, 0),
                                n()
                    }
                },
                GREYSCALE: function () {
                    return function (t, e) {
                        for (var n = t.getImageData(0, 0, t.canvas.width, t.canvas.height), r = n.data, i = 0; i < r.length; i += 4) {
                            var o = (r[i] + r[i + 1] + r[i + 2]) / 3;
                            r[i] = o,
                                    r[i + 1] = o,
                                    r[i + 2] = o
                        }
                        t.putImageData(n, 0, 0),
                                e()
                    }
                },
                INVERT: function () {
                    return function (t, e) {
                        for (var n = t.getImageData(0, 0, t.canvas.width, t.canvas.height), r = n.data, i = 0; i < r.length; i += 4)
                            r[i] = 255 - r[i],
                                    r[i + 1] = 255 - r[i + 1],
                                    r[i + 2] = 255 - r[i + 2];
                        t.putImageData(n, 0, 0),
                                e()
                    }
                },
                MORPHOLOGICAL_OPERATION: function (t, e) {
                    if (t % 2 === 0)
                        throw new Error("The kernel size must be an odd number.");
                    var n = Math.floor(t / 2);
                    if (!e)
                        throw new Error("A comparator must be defined.");
                    return function (r, i) {
                        for (var o, a = r.canvas.width, u = r.canvas.height, s = r.getImageData(0, 0, a, u), c = r.getImageData(0, 0, a, u).data, h = 0; h < u; h++)
                            for (var l = 0; l < a; l++) {
                                o = 4 * (h * a + l);
                                for (var f = c[o], p = c[o + 1], g = c[o + 2], d = 0; d < t; d++)
                                    for (var v = 0; v < t; v++) {
                                        var y = l + v - n
                                                , m = h + d - n;
                                        y >= 0 && y < a && m >= 0 && m < u && (o = 4 * (m * a + y),
                                                f = e(c[o], f),
                                                p = e(c[o + 1], p),
                                                g = e(c[o + 2], g))
                                    }
                                s.data[o] = f,
                                        s.data[o + 1] = p,
                                        s.data[o + 2] = g
                            }
                        r.putImageData(s, 0, 0),
                                i()
                    }
                },
                CONVOLUTION: function (t) {
                    if (!i.isArray(t))
                        throw new Error("The kernel must be an array.");
                    var e = Math.sqrt(t.length);
                    if ((e + 1) % 2 !== 0)
                        throw new Error("The kernel must be a square matrix with oddwidth and height.");
                    var n = (e - 1) / 2;
                    return function (r, i) {
                        for (var o, a = r.canvas.width, u = r.canvas.height, s = r.getImageData(0, 0, a, u), c = r.getImageData(0, 0, a, u).data, h = 0; h < u; h++)
                            for (var l = 0; l < a; l++) {
                                for (var f = 0, p = 0, g = 0, d = 0; d < e; d++)
                                    for (var v = 0; v < e; v++) {
                                        var y = l + v - n
                                                , m = h + d - n;
                                        if (y >= 0 && y < a && m >= 0 && m < u) {
                                            o = 4 * (m * a + y);
                                            var b = t[d * e + v];
                                            f += c[o] * b,
                                                    p += c[o + 1] * b,
                                                    g += c[o + 2] * b
                                        }
                                    }
                                o = 4 * (h * a + l),
                                        s.data[o] = f,
                                        s.data[o + 1] = p,
                                        s.data[o + 2] = g
                            }
                        r.putImageData(s, 0, 0),
                                i()
                    }
                }
            }
}(),
        function () {
            var t, e, n, r, i, o, a, u, s, c, h, l, f, p, g, d, v, y, m, b, _, w, x, I, D, R, S = [].indexOf || function (t) {
                for (var e = 0, n = this.length; e < n; e++)
                    if (e in this && this[e] === t)
                        return e;
                return -1
            }
            , C = [].slice, k = {}.hasOwnProperty, A = function (t, e) {
                return function () {
                    return t.apply(e, arguments)
                }
            }, M = function (t, e) {
                function n() {
                    this.constructor = t
                }
                for (var r in e)
                    k.call(e, r) && (t[r] = e[r]);
                return n.prototype = e.prototype,
                        t.prototype = new n,
                        t.__super__ = e.prototype,
                        t
            };
            I = ["extended", "included"],
                    d = function () {
                        function t() {}
                        return t["extends"] = function (t) {
                            var e, n, r;
                            for (e in t)
                                n = t[e],
                                        S.call(I, e) < 0 && (this[e] = n);
                            return null != (r = t.extended) && r.apply(this),
                                    this
                        }
                        ,
                                t.includes = function (t) {
                                    var e, n, r;
                                    for (e in t)
                                        n = t[e],
                                                S.call(I, e) < 0 && (this.prototype[e] = n);
                                    return null != (r = t.included) && r.apply(this),
                                            this
                                }
                        ,
                                t.delegate = function () {
                                    var t, e, n, r, i, o;
                                    for (t = 1 <= arguments.length ? C.call(arguments, 0) : [],
                                            n = t.pop(),
                                            o = [],
                                            r = 0,
                                            i = t.length; r < i; r++)
                                        e = t[r],
                                                o.push(this.prototype[e] = n.prototype[e]);
                                    return o
                                }
                        ,
                                t.aliasFunction = function (t, e) {
                                    var n = this;
                                    return this.prototype[t] = function () {
                                        var t;
                                        return t = 1 <= arguments.length ? C.call(arguments, 0) : [],
                                                n.prototype[e].apply(n, t)
                                    }
                                }
                        ,
                                t.aliasProperty = function (t, e) {
                                    return Object.defineProperty(this.prototype, t, {
                                        get: function () {
                                            return this[e]
                                        },
                                        set: function (t) {
                                            return this[e] = t
                                        }
                                    })
                                }
                        ,
                                t.included = function (t) {
                                    return t.call(this, this.prototype)
                                }
                        ,
                                t
                    }(),
                    D = Array.prototype.slice,
                    t = function (t, e) {
                        return null == e && (e = document),
                                "object" == typeof t || "undefined" != typeof exports && null !== exports ? t : e.querySelector(t)
                    }
            ,
                    w = function () {
                        function t() {}
                        return t.uniqid = function () {
                            var t;
                            return t = 0,
                                    {
                                        get: function () {
                                            return t++
                                        }
                                    }
                        }(),
                                t.extend = function () {
                                    var t, e, n, r, i, o, a;
                                    for (n = arguments[0],
                                            i = 2 <= arguments.length ? C.call(arguments, 1) : [],
                                            e = n,
                                            o = 0,
                                            a = i.length; o < a; o++) {
                                        t = i[o];
                                        for (r in t)
                                            k.call(t, r) && (e[r] = t[r])
                                    }
                                    return e
                                }
                        ,
                                t.clampRGB = function (t) {
                                    return t < 0 ? 0 : t > 255 ? 255 : t
                                }
                        ,
                                t.copyAttributes = function (t, e, n) {
                                    var r, i, o, a, u, s;
                                    for (null == n && (n = {}),
                                            a = t.attributes,
                                            s = [],
                                            i = 0,
                                            o = a.length; i < o; i++)
                                        r = a[i],
                                                null != n.except && (u = r.nodeName,
                                                        S.call(n.except, u) >= 0) || s.push(e.setAttribute(r.nodeName, r.nodeValue));
                                    return s
                                }
                        ,
                                t.dataArray = function (t) {
                                    return null == t && (t = 0),
                                            i.NodeJS || null != window.Uint8Array ? new Uint8Array(t) : new Array(t)
                                }
                        ,
                                t
                    }(),
                    "undefined" != typeof exports && null !== exports ? (b = exports,
                            a = require("canvas"),
                            f = a.Image,
                            c = require("fibers"),
                            x = require("fs")) : b = window,
                    i = function (n) {
                        function r() {
                            this.nodeFileReady = A(this.nodeFileReady, this);
                            var t, n, i, o = this;
                            if (0 === arguments.length)
                                throw "Invalid arguments";
                            return this instanceof r ? (this.finishInit = this.finishInit.bind(this),
                                    this.imageLoaded = this.imageLoaded.bind(this),
                                    t = arguments[0],
                                    r.NodeJS || (i = parseInt(r.getAttrId(t[0]), 10),
                                            n = "function" == typeof t[1] ? t[1] : "function" == typeof t[2] ? t[2] : function () {}
                                    ,
                                            isNaN(i) || !_.has(i)) ? (this.id = w.uniqid.get(),
                                    this.initializedPixelData = this.originalPixelData = null,
                                    this.cropCoordinates = {
                                        x: 0,
                                        y: 0
                                    },
                                    this.cropped = !1,
                                    this.resized = !1,
                                    this.pixelStack = [],
                                    this.layerStack = [],
                                    this.canvasQueue = [],
                                    this.currentLayer = null,
                                    this.scaled = !1,
                                    this.analyze = new e(this),
                                    this.renderer = new m(this),
                                    this.domIsLoaded(function () {
                                        return o.parseArguments(t),
                                                o.setup()
                                    }),
                                    this) : _.execute(i, n)) : new r(arguments)
                        }
                        return M(r, n),
                                r.version = {
                                    release: "4.1.2",
                                    date: "7/27/2013"
                                },
                                r.DEBUG = !1,
                                r.allowRevert = !0,
                                r.crossOrigin = "anonymous",
                                r.remoteProxy = "",
                                r.proxyParam = "camanProxyUrl",
                                r.NodeJS = "undefined" != typeof exports && null !== exports,
                                r.autoload = !r.NodeJS,
                                r.toString = function () {
                                    return "Version " + r.version.release + ", Released " + r.version.date
                                }
                        ,
                                r.getAttrId = function (e) {
                                    return !!r.NodeJS || ("string" == typeof e && (e = t(e)),
                                            null == e || null == e.getAttribute ? null : e.getAttribute("data-caman-id"))
                                }
                        ,
                                r.prototype.domIsLoaded = function (t) {
                                    var e, n = this;
                                    return r.NodeJS ? setTimeout(function () {
                                        return t.call(n)
                                    }, 0) : "complete" === document.readyState ? (g.debug("DOM initialized"),
                                            setTimeout(function () {
                                                return t.call(n)
                                            }, 0)) : (e = function () {
                                        if ("complete" === document.readyState)
                                            return g.debug("DOM initialized"),
                                                    t.call(n)
                                    }
                                    ,
                                            document.addEventListener("readystatechange", e, !1))
                                }
                        ,
                                r.prototype.parseArguments = function (t) {
                                    var e, n, r, i;
                                    if (0 === t.length)
                                        throw "Invalid arguments given";
                                    if (this.initObj = null,
                                            this.initType = null,
                                            this.imageUrl = null,
                                            this.callback = function () {}
                                    ,
                                            this.setInitObject(t[0]),
                                            1 !== t.length) {
                                        switch (typeof t[1]) {
                                            case "string":
                                                this.imageUrl = t[1];
                                                break;
                                            case "function":
                                                this.callback = t[1]
                                        }
                                        if (2 !== t.length && (this.callback = t[2],
                                                4 === t.length)) {
                                            r = t[4],
                                                    i = [];
                                            for (e in r)
                                                k.call(r, e) && (n = r[e],
                                                        i.push(this.options[e] = n));
                                            return i
                                        }
                                    }
                                }
                        ,
                                r.prototype.setInitObject = function (e) {
                                    if (r.NodeJS)
                                        return this.initObj = e,
                                                void (this.initType = "node");
                                    if ("object" == typeof e ? this.initObj = e : this.initObj = t(e),
                                            null == this.initObj)
                                        throw "Could not find image or canvas for initialization.";
                                    return this.initType = this.initObj.nodeName.toLowerCase()
                                }
                        ,
                                r.prototype.setup = function () {
                                    switch (this.initType) {
                                        case "node":
                                            return this.initNode();
                                        case "img":
                                            return this.initImage();
                                        case "canvas":
                                            return this.initCanvas()
                                    }
                                }
                        ,
                                r.prototype.initNode = function () {
                                    return g.debug("Initializing for NodeJS"),
                                            "string" == typeof this.initObj ? x.readFile(this.initObj, this.nodeFileReady) : this.nodeFileReady(null, this.initObj)
                                }
                        ,
                                r.prototype.nodeFileReady = function (t, e) {
                                    if (t)
                                        throw t;
                                    return this.image = new f,
                                            this.image.src = e,
                                            g.debug("Image loaded. Width = " + this.imageWidth() + ", Height = " + this.imageHeight()),
                                            this.canvas = new a(this.imageWidth(), this.imageHeight()),
                                            this.finishInit()
                                }
                        ,
                                r.prototype.initImage = function () {
                                    return this.image = this.initObj,
                                            this.canvas = document.createElement("canvas"),
                                            this.context = this.canvas.getContext("2d"),
                                            w.copyAttributes(this.image, this.canvas, {
                                                except: ["src"]
                                            }),
                                            this.image.parentNode.replaceChild(this.canvas, this.image),
                                            this.imageAdjustments(),
                                            this.waitForImageLoaded()
                                }
                        ,
                                r.prototype.initCanvas = function () {
                                    return this.canvas = this.initObj,
                                            this.context = this.canvas.getContext("2d"),
                                            null != this.imageUrl ? (this.image = document.createElement("img"),
                                                    this.image.src = this.imageUrl,
                                                    this.imageAdjustments(),
                                                    this.waitForImageLoaded()) : this.finishInit()
                                }
                        ,
                                r.prototype.imageAdjustments = function () {
                                    if (this.needsHiDPISwap() && (g.debug(this.image.src, "->", this.hiDPIReplacement()),
                                            this.swapped = !0,
                                            this.image.src = this.hiDPIReplacement()),
                                            l.isRemote(this.image))
                                        return this.image.src = l.proxyUrl(this.image.src),
                                                g.debug("Remote image detected, using URL = " + this.image.src)
                                }
                        ,
                                r.prototype.waitForImageLoaded = function () {
                                    return this.isImageLoaded() ? this.imageLoaded() : this.image.onload = this.imageLoaded
                                }
                        ,
                                r.prototype.isImageLoaded = function () {
                                    return !!this.image.complete && (null == this.image.naturalWidth || 0 !== this.image.naturalWidth)
                                }
                        ,
                                r.prototype.imageWidth = function () {
                                    return this.image.width || this.image.naturalWidth
                                }
                        ,
                                r.prototype.imageHeight = function () {
                                    return this.image.height || this.image.naturalHeight
                                }
                        ,
                                r.prototype.imageLoaded = function () {
                                    return g.debug("Image loaded. Width = " + this.imageWidth() + ", Height = " + this.imageHeight()),
                                            this.swapped ? (this.canvas.width = this.imageWidth() / this.hiDPIRatio(),
                                                    this.canvas.height = this.imageHeight() / this.hiDPIRatio()) : (this.canvas.width = this.imageWidth(),
                                            this.canvas.height = this.imageHeight()),
                                            this.finishInit()
                                }
                        ,
                                r.prototype.finishInit = function () {
                                    var t, e, n, i, o;
                                    if (null == this.context && (this.context = this.canvas.getContext("2d")),
                                            this.originalWidth = this.preScaledWidth = this.width = this.canvas.width,
                                            this.originalHeight = this.preScaledHeight = this.height = this.canvas.height,
                                            this.hiDPIAdjustments(),
                                            this.hasId() || this.assignId(),
                                            null != this.image && this.context.drawImage(this.image, 0, 0, this.imageWidth(), this.imageHeight(), 0, 0, this.preScaledWidth, this.preScaledHeight),
                                            this.imageData = this.context.getImageData(0, 0, this.canvas.width, this.canvas.height),
                                            this.pixelData = this.imageData.data,
                                            r.allowRevert)
                                        for (this.initializedPixelData = w.dataArray(this.pixelData.length),
                                                this.originalPixelData = w.dataArray(this.pixelData.length),
                                                o = this.pixelData,
                                                t = n = 0,
                                                i = o.length; n < i; t = ++n)
                                            e = o[t],
                                                    this.initializedPixelData[t] = e,
                                                    this.originalPixelData[t] = e;
                                    return this.dimensions = {
                                        width: this.canvas.width,
                                        height: this.canvas.height
                                    },
                                            r.NodeJS || _.put(this.id, this),
                                            this.callback.call(this, this),
                                            this.callback = function () {}
                                }
                        ,
                                r.prototype.reloadCanvasData = function () {
                                    return this.imageData = this.context.getImageData(0, 0, this.canvas.width, this.canvas.height),
                                            this.pixelData = this.imageData.data
                                }
                        ,
                                r.prototype.resetOriginalPixelData = function () {
                                    var t, e, n, i, o, a;
                                    if (!r.allowRevert)
                                        throw "Revert disabled";
                                    for (this.originalPixelData = w.dataArray(this.pixelData.length),
                                            o = this.pixelData,
                                            a = [],
                                            t = n = 0,
                                            i = o.length; n < i; t = ++n)
                                        e = o[t],
                                                a.push(this.originalPixelData[t] = e);
                                    return a
                                }
                        ,
                                r.prototype.hasId = function () {
                                    return null != r.getAttrId(this.canvas)
                                }
                        ,
                                r.prototype.assignId = function () {
                                    if (!r.NodeJS && !this.canvas.getAttribute("data-caman-id"))
                                        return this.canvas.setAttribute("data-caman-id", this.id)
                                }
                        ,
                                r.prototype.hiDPIDisabled = function () {
                                    return null !== this.canvas.getAttribute("data-caman-hidpi-disabled")
                                }
                        ,
                                r.prototype.hiDPIAdjustments = function () {
                                    var t;
                                    if (!r.NodeJS && this.needsHiDPISwap())
                                        return t = this.hiDPIRatio(),
                                                1 !== t ? (g.debug("HiDPI ratio = " + t),
                                                        this.scaled = !0,
                                                        this.preScaledWidth = this.canvas.width,
                                                        this.preScaledHeight = this.canvas.height,
                                                        this.canvas.width = this.preScaledWidth * t,
                                                        this.canvas.height = this.preScaledHeight * t,
                                                        this.canvas.style.width = "" + this.preScaledWidth + "px",
                                                        this.canvas.style.height = "" + this.preScaledHeight + "px",
                                                        this.context.scale(t, t),
                                                        this.width = this.originalWidth = this.canvas.width,
                                                        this.height = this.originalHeight = this.canvas.height) : void 0
                                }
                        ,
                                r.prototype.hiDPIRatio = function () {
                                    var t, e;
                                    return e = window.devicePixelRatio || 1,
                                            t = this.context.webkitBackingStorePixelRatio || this.context.mozBackingStorePixelRatio || this.context.msBackingStorePixelRatio || this.context.oBackingStorePixelRatio || this.context.backingStorePixelRatio || 1,
                                            e / t
                                }
                        ,
                                r.prototype.hiDPICapable = function () {
                                    return null != window.devicePixelRatio && 1 !== window.devicePixelRatio
                                }
                        ,
                                r.prototype.needsHiDPISwap = function () {
                                    return !(this.hiDPIDisabled() || !this.hiDPICapable()) && null !== this.hiDPIReplacement()
                                }
                        ,
                                r.prototype.hiDPIReplacement = function () {
                                    return null == this.image ? null : this.image.getAttribute("data-caman-hidpi")
                                }
                        ,
                                r.prototype.replaceCanvas = function (t) {
                                    var e;
                                    return e = this.canvas,
                                            this.canvas = t,
                                            this.context = this.canvas.getContext("2d"),
                                            r.NodeJS || e.parentNode.replaceChild(this.canvas, e),
                                            this.width = this.canvas.width,
                                            this.height = this.canvas.height,
                                            this.reloadCanvasData(),
                                            this.dimensions = {
                                                width: this.canvas.width,
                                                height: this.canvas.height
                                            }
                                }
                        ,
                                r.prototype.render = function (t) {
                                    var e = this;
                                    return null == t && (t = function () {}
                                    ),
                                            s.trigger(this, "renderStart"),
                                            this.renderer.execute(function () {
                                                return e.context.putImageData(e.imageData, 0, 0),
                                                        t.call(e)
                                            })
                                }
                        ,
                                r.prototype.revert = function (t) {
                                    var e, n, i, o, a;
                                    if (null == t && (t = !0),
                                            !r.allowRevert)
                                        throw "Revert disabled";
                                    for (a = this.originalVisiblePixels(),
                                            e = i = 0,
                                            o = a.length; i < o; e = ++i)
                                        n = a[e],
                                                this.pixelData[e] = n;
                                    if (t)
                                        return this.context.putImageData(this.imageData, 0, 0)
                                }
                        ,
                                r.prototype.reset = function () {
                                    var t, e, n, r, i, o, a, u, s;
                                    for (t = document.createElement("canvas"),
                                            w.copyAttributes(this.canvas, t),
                                            t.width = this.originalWidth,
                                            t.height = this.originalHeight,
                                            e = t.getContext("2d"),
                                            r = e.getImageData(0, 0, t.width, t.height),
                                            o = r.data,
                                            s = this.initializedPixelData,
                                            n = a = 0,
                                            u = s.length; a < u; n = ++a)
                                        i = s[n],
                                                o[n] = i;
                                    return e.putImageData(r, 0, 0),
                                            this.cropCoordinates = {
                                                x: 0,
                                                y: 0
                                            },
                                            this.resized = !1,
                                            this.replaceCanvas(t)
                                }
                        ,
                                r.prototype.originalVisiblePixels = function () {
                                    var t, e, n, i, o, a, u, s, c, h, l, f, p, g, d, y, m, b, _, w, x;
                                    if (!r.allowRevert)
                                        throw "Revert disabled";
                                    if (h = [],
                                            f = this.cropCoordinates.x,
                                            i = f + this.width,
                                            p = this.cropCoordinates.y,
                                            o = p + this.height,
                                            this.resized) {
                                        for (t = document.createElement("canvas"),
                                                t.width = this.originalWidth,
                                                t.height = this.originalHeight,
                                                n = t.getContext("2d"),
                                                u = n.getImageData(0, 0, t.width, t.height),
                                                c = u.data,
                                                b = this.originalPixelData,
                                                a = d = 0,
                                                m = b.length; d < m; a = ++d)
                                            s = b[a],
                                                    c[a] = s;
                                        n.putImageData(u, 0, 0),
                                                l = document.createElement("canvas"),
                                                l.width = this.width,
                                                l.height = this.height,
                                                n = l.getContext("2d"),
                                                n.drawImage(t, 0, 0, this.originalWidth, this.originalHeight, 0, 0, this.width, this.height),
                                                c = n.getImageData(0, 0, this.width, this.height).data,
                                                g = this.width
                                    } else
                                        c = this.originalPixelData,
                                                g = this.originalWidth;
                                    for (a = y = 0,
                                            _ = c.length; y < _; a = y += 4)
                                        e = v.locationToCoordinates(a, g),
                                                f <= (w = e.x) && w < i && p <= (x = e.y) && x < o && h.push(c[a], c[a + 1], c[a + 2], c[a + 3]);
                                    return h
                                }
                        ,
                                r.prototype.process = function (t, e) {
                                    return this.renderer.add({
                                        type: h.Type.Single,
                                        name: t,
                                        processFn: e
                                    }),
                                            this
                                }
                        ,
                                r.prototype.processKernel = function (t, e, n, r) {
                                    var i, o, a;
                                    if (null == n && (n = null),
                                            null == r && (r = 0),
                                            null == n)
                                        for (n = 0,
                                                i = o = 0,
                                                a = e.length; 0 <= a ? o < a : o > a; i = 0 <= a ? ++o : --o)
                                            n += e[i];
                                    return this.renderer.add({
                                        type: h.Type.Kernel,
                                        name: t,
                                        adjust: e,
                                        divisor: n,
                                        bias: r
                                    }),
                                            this
                                }
                        ,
                                r.prototype.processPlugin = function (t, e) {
                                    return this.renderer.add({
                                        type: h.Type.Plugin,
                                        plugin: t,
                                        args: e
                                    }),
                                            this
                                }
                        ,
                                r.prototype.newLayer = function (t) {
                                    var e;
                                    return e = new p(this),
                                            this.canvasQueue.push(e),
                                            this.renderer.add({
                                                type: h.Type.LayerDequeue
                                            }),
                                            t.call(e),
                                            this.renderer.add({
                                                type: h.Type.LayerFinished
                                            }),
                                            this
                                }
                        ,
                                r.prototype.executeLayer = function (t) {
                                    return this.pushContext(t)
                                }
                        ,
                                r.prototype.pushContext = function (t) {
                                    return this.layerStack.push(this.currentLayer),
                                            this.pixelStack.push(this.pixelData),
                                            this.currentLayer = t,
                                            this.pixelData = t.pixelData
                                }
                        ,
                                r.prototype.popContext = function () {
                                    return this.pixelData = this.pixelStack.pop(),
                                            this.currentLayer = this.layerStack.pop()
                                }
                        ,
                                r.prototype.applyCurrentLayer = function () {
                                    return this.currentLayer.applyToParent()
                                }
                        ,
                                r
                    }(d),
                    b.Caman = i,
                    i.Analyze = function () {
                        function t(t) {
                            this.c = t
                        }
                        return t.prototype.calculateLevels = function () {
                            var t, e, n, r, i, o, a;
                            for (e = {
                            r: {},
                                    g: {},
                                    b: {}
                            },
                                    t = r = 0; r <= 255; t = ++r)
                                e.r[t] = 0,
                                        e.g[t] = 0,
                                        e.b[t] = 0;
                            for (t = i = 0,
                                    a = this.c.pixelData.length; i < a; t = i += 4)
                                e.r[this.c.pixelData[t]]++,
                                        e.g[this.c.pixelData[t + 1]]++,
                                        e.b[this.c.pixelData[t + 2]]++;
                            for (n = this.c.pixelData.length / 4,
                                    t = o = 0; o <= 255; t = ++o)
                                e.r[t] /= n,
                                        e.g[t] /= n,
                                        e.b[t] /= n;
                            return e
                        }
                        ,
                                t
                    }(),
                    e = i.Analyze,
                    i.DOMUpdated = function () {
                        var t, e, n, r, i, a;
                        if (e = document.querySelectorAll("img[data-caman]"),
                                e.length > 0) {
                            for (a = [],
                                    r = 0,
                                    i = e.length; r < i; r++)
                                t = e[r],
                                        a.push(n = new o(t, function () {
                                            return this.parse(),
                                                    this.execute()
                                        }
                                        ));
                            return a
                        }
                    }
            ,
                    i.autoload && !function () {
                        return "complete" === document.readyState ? i.DOMUpdated() : document.addEventListener("DOMContentLoaded", i.DOMUpdated, !1)
                    }(),
                    o = function () {
                        function t(t, e) {
                            this.dataStr = t.getAttribute("data-caman"),
                                    this.caman = i(t, e.bind(this))
                        }
                        var e;
                        return e = "(\\w+)\\((.*?)\\)",
                                t.prototype.parse = function () {
                                    var t, n, r, i, o, a, u, s, c, h, l, f, p;
                                    if (this.ele = this.caman.canvas,
                                            s = new RegExp(e, "g"),
                                            c = this.dataStr.match(s),
                                            c.length > 0) {
                                        for (s = new RegExp(e),
                                                p = [],
                                                h = 0,
                                                l = c.length; h < l; h++) {
                                            o = c[h],
                                                    f = o.match(s),
                                                    u = f[0],
                                                    r = f[1],
                                                    t = f[2],
                                                    a = new Function("return function() {        this." + r + "(" + t + ");      };");
                                            try {
                                                i = a(),
                                                        p.push(i.call(this.caman))
                                            } catch (d) {
                                                n = d,
                                                        p.push(g.debug(n))
                                            }
                                        }
                                        return p
                                    }
                                }
                        ,
                                t.prototype.execute = function () {
                                    var t;
                                    return t = this.ele,
                                            this.caman.render(function () {
                                                return t.parentNode.replaceChild(this.toImage(), t)
                                            })
                                }
                        ,
                                t
                    }(),
                    i.Blender = function () {
                        function t() {}
                        return t.blenders = {},
                                t.register = function (t, e) {
                                    return this.blenders[t] = e
                                }
                        ,
                                t.execute = function (t, e, n) {
                                    return this.blenders[t](e, n)
                                }
                        ,
                                t
                    }(),
                    n = i.Blender,
                    i.Calculate = function () {
                        function t() {}
                        return t.distance = function (t, e, n, r) {
                            return Math.sqrt(Math.pow(n - t, 2) + Math.pow(r - e, 2))
                        }
                        ,
                                t.randomRange = function (t, e, n) {
                                    var r;
                                    return null == n && (n = !1),
                                            r = t + Math.random() * (e - t),
                                            n ? r.toFixed(n) : Math.round(r)
                                }
                        ,
                                t.luminance = function (t) {
                                    return .299 * t.r + .587 * t.g + .114 * t.b
                                }
                        ,
                                t.bezier = function (t, e, n, r, i, o) {
                                    var a, u, s, c, h, l, f, p, g, d, v, y, m, b, _, w, x, I, D, R, S, C, k, A, M, P, L;
                                    for (_ = t[0],
                                            D = t[1],
                                            w = e[0],
                                            R = e[1],
                                            x = n[0],
                                            S = n[1],
                                            I = r[0],
                                            C = r[1],
                                            f = {},
                                            h = parseInt(3 * (w - _), 10),
                                            s = 3 * (x - w) - h,
                                            a = I - _ - h - s,
                                            l = 3 * (R - D),
                                            c = 3 * (S - R) - l,
                                            u = C - D - l - c,
                                            d = k = 0; k < 1e3; d = ++k)
                                        b = d / 1e3,
                                                p = Math.round(a * Math.pow(b, 3) + s * Math.pow(b, 2) + h * b + _),
                                                g = Math.round(u * Math.pow(b, 3) + c * Math.pow(b, 2) + l * b + D),
                                                i && g < i ? g = i : o && g > o && (g = o),
                                                f[p] = g;
                                    if (f.length < r[0] + 1)
                                        for (d = A = 0,
                                                P = r[0]; 0 <= P ? A <= P : A >= P; d = 0 <= P ? ++A : --A)
                                            if (null == f[d]) {
                                                for (y = [d - 1, f[d - 1]],
                                                        v = M = d,
                                                        L = r[0]; d <= L ? M <= L : M >= L; v = d <= L ? ++M : --M)
                                                    if (null != f[v]) {
                                                        m = [v, f[v]];
                                                        break
                                                    }
                                                f[d] = y[1] + (m[1] - y[1]) / (m[0] - y[0]) * (d - y[0])
                                            }
                                    return null == f[r[0]] && (f[r[0]] = f[r[0] - 1]),
                                            f
                                }
                        ,
                                t
                    }(),
                    r = i.Calculate,
                    i.Convert = function () {
                        function t() {}
                        return t.hexToRGB = function (t) {
                            var e, n, r;
                            return "#" === t.charAt(0) && (t = t.substr(1)),
                                    r = parseInt(t.substr(0, 2), 16),
                                    n = parseInt(t.substr(2, 2), 16),
                                    e = parseInt(t.substr(4, 2), 16),
                                    {
                                        r: r,
                                        g: n,
                                        b: e
                                    }
                        }
                        ,
                                t.rgbToHSL = function (t, e, n) {
                                    var r, i, o, a, u, s;
                                    return "object" == typeof t && (e = t.g,
                                            n = t.b,
                                            t = t.r),
                                            t /= 255,
                                            e /= 255,
                                            n /= 255,
                                            a = Math.max(t, e, n),
                                            u = Math.min(t, e, n),
                                            o = (a + u) / 2,
                                            a === u ? i = s = 0 : (r = a - u,
                                                    s = o > .5 ? r / (2 - a - u) : r / (a + u),
                                                    i = function () {
                                                        switch (a) {
                                                            case t:
                                                                return (e - n) / r + (e < n ? 6 : 0);
                                                            case e:
                                                                return (n - t) / r + 2;
                                                            case n:
                                                                return (t - e) / r + 4
                                                        }
                                                    }(),
                                                    i /= 6),
                                            {
                                                h: i,
                                                s: s,
                                                l: o
                                            }
                                }
                        ,
                                t.hslToRGB = function (t, e, n) {
                                    var r, i, o, a, u;
                                    return "object" == typeof t && (e = t.s,
                                            n = t.l,
                                            t = t.h),
                                            0 === e ? u = i = r = n : (a = n < .5 ? n * (1 + e) : n + e - n * e,
                                                    o = 2 * n - a,
                                                    u = this.hueToRGB(o, a, t + 1 / 3),
                                                    i = this.hueToRGB(o, a, t),
                                                    r = this.hueToRGB(o, a, t - 1 / 3)),
                                            {
                                                r: 255 * u,
                                                g: 255 * i,
                                                b: 255 * r
                                            }
                                }
                        ,
                                t.hueToRGB = function (t, e, n) {
                                    return n < 0 && (n += 1),
                                            n > 1 && (n -= 1),
                                            n < 1 / 6 ? t + 6 * (e - t) * n : n < .5 ? e : n < 2 / 3 ? t + (e - t) * (2 / 3 - n) * 6 : t
                                }
                        ,
                                t.rgbToHSV = function (t, e, n) {
                                    var r, i, o, a, u, s;
                                    return t /= 255,
                                            e /= 255,
                                            n /= 255,
                                            o = Math.max(t, e, n),
                                            a = Math.min(t, e, n),
                                            s = o,
                                            r = o - a,
                                            u = 0 === o ? 0 : r / o,
                                            o === a ? i = 0 : (i = function () {
                                                switch (o) {
                                                    case t:
                                                        return (e - n) / r + (e < n ? 6 : 0);
                                                    case e:
                                                        return (n - t) / r + 2;
                                                    case n:
                                                        return (t - e) / r + 4
                                                }
                                            }(),
                                                    i /= 6),
                                            {
                                                h: i,
                                                s: u,
                                                v: s
                                            }
                                }
                        ,
                                t.hsvToRGB = function (t, e, n) {
                                    var r, i, o, a, u, s, c, h;
                                    switch (a = Math.floor(6 * t),
                                            i = 6 * t - a,
                                            u = n * (1 - e),
                                            s = n * (1 - i * e),
                                            h = n * (1 - (1 - i) * e),
                                            a % 6) {
                                        case 0:
                                            c = n,
                                                    o = h,
                                                    r = u;
                                            break;
                                        case 1:
                                            c = s,
                                                    o = n,
                                                    r = u;
                                            break;
                                        case 2:
                                            c = u,
                                                    o = n,
                                                    r = h;
                                            break;
                                        case 3:
                                            c = u,
                                                    o = s,
                                                    r = n;
                                            break;
                                        case 4:
                                            c = h,
                                                    o = u,
                                                    r = n;
                                            break;
                                        case 5:
                                            c = n,
                                                    o = u,
                                                    r = s
                                    }
                                    return {
                                        r: Math.floor(255 * c),
                                        g: Math.floor(255 * o),
                                        b: Math.floor(255 * r)
                                    }
                                }
                        ,
                                t.rgbToXYZ = function (t, e, n) {
                                    var r, i, o;
                                    return t /= 255,
                                            e /= 255,
                                            n /= 255,
                                            t > .04045 ? t = Math.pow((t + .055) / 1.055, 2.4) : t /= 12.92,
                                            e > .04045 ? e = Math.pow((e + .055) / 1.055, 2.4) : e /= 12.92,
                                            n > .04045 ? n = Math.pow((n + .055) / 1.055, 2.4) : n /= 12.92,
                                            r = .4124 * t + .3576 * e + .1805 * n,
                                            i = .2126 * t + .7152 * e + .0722 * n,
                                            o = .0193 * t + .1192 * e + .9505 * n,
                                            {
                                                x: 100 * r,
                                                y: 100 * i,
                                                z: 100 * o
                                            }
                                }
                        ,
                                t.xyzToRGB = function (t, e, n) {
                                    var r, i, o;
                                    return t /= 100,
                                            e /= 100,
                                            n /= 100,
                                            o = 3.2406 * t + -1.5372 * e + -.4986 * n,
                                            i = -.9689 * t + 1.8758 * e + .0415 * n,
                                            r = .0557 * t + -.204 * e + 1.057 * n,
                                            o > .0031308 ? o = 1.055 * Math.pow(o, .4166666667) - .055 : o *= 12.92,
                                            i > .0031308 ? i = 1.055 * Math.pow(i, .4166666667) - .055 : i *= 12.92,
                                            r > .0031308 ? r = 1.055 * Math.pow(r, .4166666667) - .055 : r *= 12.92,
                                            {
                                                r: 255 * o,
                                                g: 255 * i,
                                                b: 255 * r
                                            }
                                }
                        ,
                                t.xyzToLab = function (t, e, n) {
                                    var r, i, o, a, u, s;
                                    return "object" == typeof t && (e = t.y,
                                            n = t.z,
                                            t = t.x),
                                            a = 95.047,
                                            u = 100,
                                            s = 108.883,
                                            t /= a,
                                            e /= u,
                                            n /= s,
                                            t = t > .008856451679 ? Math.pow(t, .3333333333) : 7.787037037 * t + .1379310345,
                                            e = e > .008856451679 ? Math.pow(e, .3333333333) : 7.787037037 * e + .1379310345,
                                            n = n > .008856451679 ? Math.pow(n, .3333333333) : 7.787037037 * n + .1379310345,
                                            o = 116 * e - 16,
                                            r = 500 * (t - e),
                                            i = 200 * (e - n),
                                            {
                                                l: o,
                                                a: r,
                                                b: i
                                            }
                                }
                        ,
                                t.labToXYZ = function (t, e, n) {
                                    var r, i, o;
                                    return "object" == typeof t && (e = t.a,
                                            n = t.b,
                                            t = t.l),
                                            i = (t + 16) / 116,
                                            r = i + e / 500,
                                            o = i - n / 200,
                                            r = r > .2068965517 ? r * r * r : .1284185493 * (r - .1379310345),
                                            i = i > .2068965517 ? i * i * i : .1284185493 * (i - .1379310345),
                                            o = o > .2068965517 ? o * o * o : .1284185493 * (o - .1379310345),
                                            {
                                                x: 95.047 * r,
                                                y: 100 * i,
                                                z: 108.883 * o
                                            }
                                }
                        ,
                                t.rgbToLab = function (t, e, n) {
                                    var r;
                                    return "object" == typeof t && (e = t.g,
                                            n = t.b,
                                            t = t.r),
                                            r = this.rgbToXYZ(t, e, n),
                                            this.xyzToLab(r)
                                }
                        ,
                                t.labToRGB = function (t, e, n) {}
                        ,
                                t
                    }(),
                    u = i.Convert,
                    i.Event = function () {
                        function t() {}
                        return t.events = {},
                                t.types = ["processStart", "processComplete", "renderStart", "renderFinished", "blockStarted", "blockFinished"],
                                t.trigger = function (t, e, n) {
                                    var r, i, o, a, u;
                                    if (null == n && (n = null),
                                            this.events[e] && this.events[e].length) {
                                        for (a = this.events[e],
                                                u = [],
                                                i = 0,
                                                o = a.length; i < o; i++)
                                            r = a[i],
                                                    null === r.target || t.id === r.target.id ? u.push(r.fn.call(t, n)) : u.push(void 0);
                                        return u
                                    }
                                }
                        ,
                                t.listen = function (t, e, n) {
                                    var r, i;
                                    return "string" == typeof t && (i = t,
                                            r = e,
                                            t = null,
                                            e = i,
                                            n = r),
                                            !(S.call(this.types, e) < 0) && (this.events[e] || (this.events[e] = []),
                                            this.events[e].push({
                                        target: t,
                                        fn: n
                                    }),
                                            !0)
                                }
                        ,
                                t
                    }(),
                    s = i.Event,
                    i.Filter = function () {
                        function t() {}
                        return t.Type = {
                            Single: 1,
                            Kernel: 2,
                            LayerDequeue: 3,
                            LayerFinished: 4,
                            LoadOverlay: 5,
                            Plugin: 6
                        },
                                t.register = function (t, e) {
                                    return i.prototype[t] = e
                                }
                        ,
                                t
                    }(),
                    h = i.Filter,
                    i.IO = function () {
                        function t() {}
                        return t.domainRegex = /(?:(?:http|https):\/\/)((?:\w+)\.(?:(?:\w|\.)+))/,
                                t.isRemote = function (t) {
                                    return null != t && (!this.corsEnabled(t) && this.isURLRemote(t.src))
                                }
                        ,
                                t.corsEnabled = function (t) {
                                    var e;
                                    return null != t.crossOrigin && ("anonymous" === (e = t.crossOrigin.toLowerCase()) || "use-credentials" === e)
                                }
                        ,
                                t.isURLRemote = function (t) {
                                    var e;
                                    return e = t.match(this.domainRegex),
                                            !!e && e[1] !== document.domain
                                }
                        ,
                                t.remoteCheck = function (t) {
                                    if (this.isURLRemote(t)) {
                                        if (i.remoteProxy.length)
                                            return i.isURLRemote(i.remoteProxy) ? void g.info("Cannot use a remote proxy for loading images.") : this.proxyUrl(t);
                                        g.info("Attempting to load a remote image without a configured proxy. URL: " + t)
                                    }
                                }
                        ,
                                t.proxyUrl = function (t) {
                                    return "" + i.remoteProxy + "?" + i.proxyParam + "=" + encodeURIComponent(t)
                                }
                        ,
                                t.useProxy = function (t) {
                                    var e;
                                    return e = {
                                        ruby: "rb",
                                        python: "py",
                                        perl: "pl",
                                        javascript: "js"
                                    },
                                            t = t.toLowerCase(),
                                            null != e[t] && (t = e[t]),
                                            "proxies/caman_proxy." + t
                                }
                        ,
                                t
                    }(),
                    i.prototype.save = function () {
                        return "undefined" != typeof exports && null !== exports ? this.nodeSave.apply(this, arguments) : this.browserSave.apply(this, arguments)
                    }
            ,
                    i.prototype.browserSave = function (t) {
                        var e;
                        return null == t && (t = "png"),
                                t = t.toLowerCase(),
                                e = this.toBase64(t).replace("image/" + t, "image/octet-stream"),
                                document.location.href = e
                    }
            ,
                    i.prototype.nodeSave = function (t, e) {
                        var n, r;
                        null == e && (e = !0);
                        try {
                            if (r = x.statSync(t),
                                    r.isFile() && !e)
                                return !1
                        } catch (i) {
                            n = i,
                                    g.debug("Creating output file " + t)
                        }
                        return x.writeFile(t, this.canvas.toBuffer(), function () {
                            return g.debug("Finished writing to " + t)
                        })
                    }
            ,
                    i.prototype.toImage = function (t) {
                        var e;
                        return e = document.createElement("img"),
                                e.src = this.toBase64(t),
                                e.width = this.dimensions.width,
                                e.height = this.dimensions.height,
                                window.devicePixelRatio && (e.width /= window.devicePixelRatio,
                                        e.height /= window.devicePixelRatio),
                                e
                    }
            ,
                    i.prototype.toBase64 = function (t) {
                        return null == t && (t = "png"),
                                t = t.toLowerCase(),
                                this.canvas.toDataURL("image/" + t)
                    }
            ,
                    l = i.IO,
                    i.Layer = function () {
                        function e(t) {
                            this.c = t,
                                    this.filter = this.c,
                                    this.options = {
                                        blendingMode: "normal",
                                        opacity: 1
                                    },
                                    this.layerID = w.uniqid.get(),
                                    this.canvas = "undefined" != typeof exports && null !== exports ? new a : document.createElement("canvas"),
                                    this.canvas.width = this.c.dimensions.width,
                                    this.canvas.height = this.c.dimensions.height,
                                    this.context = this.canvas.getContext("2d"),
                                    this.context.createImageData(this.canvas.width, this.canvas.height),
                                    this.imageData = this.context.getImageData(0, 0, this.canvas.width, this.canvas.height),
                                    this.pixelData = this.imageData.data
                        }
                        return e.prototype.newLayer = function (t) {
                            return this.c.newLayer.call(this.c, t)
                        }
                        ,
                                e.prototype.setBlendingMode = function (t) {
                                    return this.options.blendingMode = t,
                                            this
                                }
                        ,
                                e.prototype.opacity = function (t) {
                                    return this.options.opacity = t / 100,
                                            this
                                }
                        ,
                                e.prototype.copyParent = function () {
                                    var t, e, n, r;
                                    for (e = this.c.pixelData,
                                            t = n = 0,
                                            r = this.c.pixelData.length; n < r; t = n += 4)
                                        this.pixelData[t] = e[t],
                                                this.pixelData[t + 1] = e[t + 1],
                                                this.pixelData[t + 2] = e[t + 2],
                                                this.pixelData[t + 3] = e[t + 3];
                                    return this
                                }
                        ,
                                e.prototype.fillColor = function () {
                                    return this.c.fillColor.apply(this.c, arguments)
                                }
                        ,
                                e.prototype.overlayImage = function (e) {
                                    return "object" == typeof e ? e = e.src : "string" == typeof e && "#" === e[0] && (e = t(e).src),
                                            e ? (this.c.renderer.renderQueue.push({
                                                type: h.Type.LoadOverlay,
                                                src: e,
                                                layer: this
                                            }),
                                                    this) : this
                                }
                        ,
                                e.prototype.applyToParent = function () {
                                    var t, e, r, i, o, a, u, s, c;
                                    for (r = this.c.pixelStack[this.c.pixelStack.length - 1],
                                            e = this.c.pixelData,
                                            c = [],
                                            t = u = 0,
                                            s = e.length; u < s; t = u += 4)
                                        a = {
                                            r: r[t],
                                            g: r[t + 1],
                                            b: r[t + 2],
                                            a: r[t + 3]
                                        },
                                                o = {
                                                    r: e[t],
                                                    g: e[t + 1],
                                                    b: e[t + 2],
                                                    a: e[t + 3]
                                                },
                                                i = n.execute(this.options.blendingMode, o, a),
                                                i.r = w.clampRGB(i.r),
                                                i.g = w.clampRGB(i.g),
                                                i.b = w.clampRGB(i.b),
                                                null == i.a && (i.a = o.a),
                                                r[t] = a.r - (a.r - i.r) * (this.options.opacity * (i.a / 255)),
                                                r[t + 1] = a.g - (a.g - i.g) * (this.options.opacity * (i.a / 255)),
                                                c.push(r[t + 2] = a.b - (a.b - i.b) * (this.options.opacity * (i.a / 255)));
                                    return c
                                }
                        ,
                                e
                    }(),
                    p = i.Layer,
                    i.Logger = function () {
                        function t() {
                            var t, e, n, r;
                            for (r = ["log", "info", "warn", "error"],
                                    e = 0,
                                    n = r.length; e < n; e++)
                                t = r[e],
                                        this[t] = function (t) {
                                    return function () {
                                        var e, n;
                                        if (e = 1 <= arguments.length ? C.call(arguments, 0) : [],
                                                i.DEBUG)
                                            try {
                                                return console[t].apply(console, e)
                                            } catch (r) {
                                                return n = r,
                                                        console[t](e)
                                            }
                                    }
                                }(t);
                            this.debug = this.log
                        }
                        return t
                    }(),
                    g = new i.Logger,
                    i.Pixel = function () {
                        function t(t, e, n, r, i) {
                            this.r = null != t ? t : 0,
                                    this.g = null != e ? e : 0,
                                    this.b = null != n ? n : 0,
                                    this.a = null != r ? r : 255,
                                    this.c = null != i ? i : null,
                                    this.loc = 0
                        }
                        return t.coordinatesToLocation = function (t, e, n) {
                            return 4 * (e * n + t)
                        }
                        ,
                                t.locationToCoordinates = function (t, e) {
                                    var n, r;
                                    return r = Math.floor(t / (4 * e)),
                                            n = t % (4 * e) / 4,
                                            {
                                                x: n,
                                                y: r
                                            }
                                }
                        ,
                                t.prototype.setContext = function (t) {
                                    return this.c = t
                                }
                        ,
                                t.prototype.locationXY = function () {
                                    var t, e;
                                    if (null == this.c)
                                        throw "Requires a CamanJS context";
                                    return e = this.c.dimensions.height - Math.floor(this.loc / (4 * this.c.dimensions.width)),
                                            t = this.loc % (4 * this.c.dimensions.width) / 4,
                                            {
                                                x: t,
                                                y: e
                                            }
                                }
                        ,
                                t.prototype.pixelAtLocation = function (e) {
                                    if (null == this.c)
                                        throw "Requires a CamanJS context";
                                    return new t(this.c.pixelData[e], this.c.pixelData[e + 1], this.c.pixelData[e + 2], this.c.pixelData[e + 3], this.c)
                                }
                        ,
                                t.prototype.getPixelRelative = function (e, n) {
                                    var r;
                                    if (null == this.c)
                                        throw "Requires a CamanJS context";
                                    return r = this.loc + 4 * this.c.dimensions.width * (n * -1) + 4 * e,
                                            r > this.c.pixelData.length || r < 0 ? new t(0, 0, 0, 255, this.c) : this.pixelAtLocation(r)
                                }
                        ,
                                t.prototype.putPixelRelative = function (t, e, n) {
                                    var r;
                                    if (null == this.c)
                                        throw "Requires a CamanJS context";
                                    if (r = this.loc + 4 * this.c.dimensions.width * (e * -1) + 4 * t,
                                            !(newLoc > this.c.pixelData.length || newLoc < 0))
                                        return this.c.pixelData[newLoc] = n.r,
                                                this.c.pixelData[newLoc + 1] = n.g,
                                                this.c.pixelData[newLoc + 2] = n.b,
                                                this.c.pixelData[newLoc + 3] = n.a,
                                                !0
                                }
                        ,
                                t.prototype.getPixel = function (t, e) {
                                    var n;
                                    if (null == this.c)
                                        throw "Requires a CamanJS context";
                                    return n = this.coordinatesToLocation(t, e, this.width),
                                            this.pixelAtLocation(n)
                                }
                        ,
                                t.prototype.putPixel = function (t, e, n) {
                                    var r;
                                    if (null == this.c)
                                        throw "Requires a CamanJS context";
                                    return r = this.coordinatesToLocation(t, e, this.width),
                                            this.c.pixelData[r] = n.r,
                                            this.c.pixelData[r + 1] = n.g,
                                            this.c.pixelData[r + 2] = n.b,
                                            this.c.pixelData[r + 3] = n.a
                                }
                        ,
                                t.prototype.toString = function () {
                                    return this.toKey()
                                }
                        ,
                                t.prototype.toHex = function (t) {
                                    var e;
                                    return null == t && (t = !1),
                                            e = "#" + this.r.toString(16) + this.g.toString(16) + this.b.toString(16),
                                            t ? e + this.a.toString(16) : e
                                }
                        ,
                                t
                    }(),
                    v = i.Pixel,
                    i.Plugin = function () {
                        function t() {}
                        return t.plugins = {},
                                t.register = function (t, e) {
                                    return this.plugins[t] = e
                                }
                        ,
                                t.execute = function (t, e, n) {
                                    return this.plugins[e].apply(t, n)
                                }
                        ,
                                t
                    }(),
                    y = i.Plugin,
                    i.Renderer = function () {
                        function t(t) {
                            this.c = t,
                                    this.processNext = A(this.processNext, this),
                                    this.renderQueue = [],
                                    this.modPixelData = null
                        }
                        return t.Blocks = i.NodeJS ? require("os").cpus().length : 4,
                                t.prototype.add = function (t) {
                                    if (null != t)
                                        return this.renderQueue.push(t)
                                }
                        ,
                                t.prototype.processNext = function () {
                                    var t;
                                    if (0 === this.renderQueue.length)
                                        return s.trigger(this, "renderFinished"),
                                                null != this.finishedFn && this.finishedFn.call(this.c),
                                                this;
                                    switch (this.currentJob = this.renderQueue.shift(),
                                            this.currentJob.type) {
                                        case h.Type.LayerDequeue:
                                            return t = this.c.canvasQueue.shift(),
                                                    this.c.executeLayer(t),
                                                    this.processNext();
                                        case h.Type.LayerFinished:
                                            return this.c.applyCurrentLayer(),
                                                    this.c.popContext(),
                                                    this.processNext();
                                        case h.Type.LoadOverlay:
                                            return this.loadOverlay(this.currentJob.layer, this.currentJob.src);
                                        case h.Type.Plugin:
                                            return this.executePlugin();
                                        default:
                                            return this.executeFilter()
                                    }
                                }
                        ,
                                t.prototype.execute = function (t) {
                                    return this.finishedFn = t,
                                            this.modPixelData = w.dataArray(this.c.pixelData.length),
                                            this.processNext()
                                }
                        ,
                                t.prototype.eachBlock = function (e) {
                                    var n, r, o, a, u, s, h, l, f, p, g, d, v = this;
                                    for (this.blocksDone = 0,
                                            l = this.c.pixelData.length,
                                            r = Math.floor(l / 4 / t.Blocks),
                                            n = 4 * r,
                                            h = n + l / 4 % t.Blocks * 4,
                                            d = [],
                                            s = p = 0,
                                            g = t.Blocks; 0 <= g ? p < g : p > g; s = 0 <= g ? ++p : --p)
                                        f = s * n,
                                                a = f + (s === t.Blocks - 1 ? h : n),
                                                i.NodeJS ? (u = c(function () {
                                                    return e.call(v, s, f, a)
                                                }),
                                                        o = u.run(),
                                                        d.push(this.blockFinished(o))) : d.push(setTimeout(function (t, n, r) {
                                            return function () {
                                                return e.call(v, t, n, r)
                                            }
                                        }(s, f, a), 0));
                                    return d
                                }
                        ,
                                t.prototype.executeFilter = function () {
                                    return s.trigger(this.c, "processStart", this.currentJob),
                                            this.currentJob.type === h.Type.Single ? this.eachBlock(this.renderBlock) : this.eachBlock(this.renderKernel)
                                }
                        ,
                                t.prototype.executePlugin = function () {
                                    return g.debug("Executing plugin " + this.currentJob.plugin),
                                            y.execute(this.c, this.currentJob.plugin, this.currentJob.args),
                                            g.debug("Plugin " + this.currentJob.plugin + " finished!"),
                                            this.processNext()
                                }
                        ,
                                t.prototype.renderBlock = function (e, n, r) {
                                    var o, a, u;
                                    for (g.debug("Block #" + e + " - Filter: " + this.currentJob.name + ", Start: " + n + ", End: " + r),
                                            s.trigger(this.c, "blockStarted", {
                                            blockNum: e,
                                                    totalBlocks: t.Blocks,
                                                    startPixel: n,
                                                    endPixel: r
                                            }),
                                            a = new v,
                                            a.setContext(this.c),
                                            o = u = n; u < r; o = u += 4)
                                        a.loc = o,
                                                a.r = this.c.pixelData[o],
                                                a.g = this.c.pixelData[o + 1],
                                                a.b = this.c.pixelData[o + 2],
                                                a.a = this.c.pixelData[o + 3],
                                                this.currentJob.processFn(a),
                                                this.c.pixelData[o] = w.clampRGB(a.r),
                                                this.c.pixelData[o + 1] = w.clampRGB(a.g),
                                                this.c.pixelData[o + 2] = w.clampRGB(a.b),
                                                this.c.pixelData[o + 3] = w.clampRGB(a.a);
                                    return i.NodeJS ? c["yield"](e) : this.blockFinished(e)
                                }
                        ,
                                t.prototype.renderKernel = function (t, e, n) {
                                    var r, o, a, u, s, h, l, f, p, d, y, m, b, _, x, I, D, R;
                                    for (m = this.currentJob.name,
                                            a = this.currentJob.bias,
                                            h = this.currentJob.divisor,
                                            y = this.c.pixelData.length,
                                            r = this.currentJob.adjust,
                                            o = Math.sqrt(r.length),
                                            d = [],
                                            g.debug("Rendering kernel - Filter: " + this.currentJob.name),
                                            e = Math.max(e, 4 * this.c.dimensions.width * ((o - 1) / 2)),
                                            n = Math.min(n, y - 4 * this.c.dimensions.width * ((o - 1) / 2)),
                                            u = (o - 1) / 2,
                                            _ = new v,
                                            _.setContext(this.c),
                                            l = I = e; I < n; l = I += 4) {
                                        for (_.loc = l,
                                                s = 0,
                                                f = D = - u; - u <= u ? D <= u : D >= u; f = - u <= u ? ++D : --D)
                                            for (p = R = u; u <= - u ? R <= - u : R >= - u; p = u <= - u ? ++R : --R)
                                                b = _.getPixelRelative(f, p),
                                                        d[3 * s] = b.r,
                                                        d[3 * s + 1] = b.g,
                                                        d[3 * s + 2] = b.b,
                                                        s++;
                                        x = this.processKernel(r, d, h, a),
                                                this.modPixelData[l] = w.clampRGB(x.r),
                                                this.modPixelData[l + 1] = w.clampRGB(x.g),
                                                this.modPixelData[l + 2] = w.clampRGB(x.b),
                                                this.modPixelData[l + 3] = this.c.pixelData[l + 3]
                                    }
                                    return i.NodeJS ? c["yield"](t) : this.blockFinished(t)
                                }
                        ,
                                t.prototype.blockFinished = function (e) {
                                    var n, r, i;
                                    if (e >= 0 && g.debug("Block #" + e + " finished! Filter: " + this.currentJob.name),
                                            this.blocksDone++,
                                            s.trigger(this.c, "blockFinished", {
                                                blockNum: e,
                                                blocksFinished: this.blocksDone,
                                                totalBlocks: t.Blocks
                                            }),
                                            this.blocksDone === t.Blocks) {
                                        if (this.currentJob.type === h.Type.Kernel)
                                            for (n = r = 0,
                                                    i = this.c.pixelData.length; 0 <= i ? r < i : r > i; n = 0 <= i ? ++r : --r)
                                                this.c.pixelData[n] = this.modPixelData[n];
                                        return e >= 0 && g.debug("Filter " + this.currentJob.name + " finished!"),
                                                s.trigger(this.c, "processComplete", this.currentJob),
                                                this.processNext()
                                    }
                                }
                        ,
                                t.prototype.processKernel = function (t, e, n, r) {
                                    var i, o, a, u;
                                    for (o = {
                                    r: 0,
                                            g: 0,
                                            b: 0
                                    },
                                            i = a = 0,
                                            u = t.length; 0 <= u ? a < u : a > u; i = 0 <= u ? ++a : --a)
                                        o.r += t[i] * e[3 * i],
                                                o.g += t[i] * e[3 * i + 1],
                                                o.b += t[i] * e[3 * i + 2];
                                    return o.r = o.r / n + r,
                                            o.g = o.g / n + r,
                                            o.b = o.b / n + r,
                                            o
                                }
                        ,
                                t.prototype.loadOverlay = function (t, e) {
                                    var n, r, i = this;
                                    return n = document.createElement("img"),
                                            n.onload = function () {
                                                return t.context.drawImage(n, 0, 0, i.c.dimensions.width, i.c.dimensions.height),
                                                        t.imageData = t.context.getImageData(0, 0, i.c.dimensions.width, i.c.dimensions.height),
                                                        t.pixelData = t.imageData.data,
                                                        i.c.pixelData = t.pixelData,
                                                        i.processNext()
                                            }
                                    ,
                                            r = l.remoteCheck(e),
                                            n.src = null != r ? r : e
                                }
                        ,
                                t
                    }(),
                    m = i.Renderer,
                    i.Store = function () {
                        function t() {}
                        return t.items = {},
                                t.has = function (t) {
                                    return null != this.items[t]
                                }
                        ,
                                t.get = function (t) {
                                    return this.items[t]
                                }
                        ,
                                t.put = function (t, e) {
                                    return this.items[t] = e
                                }
                        ,
                                t.execute = function (t, e) {
                                    var n = this;
                                    return setTimeout(function () {
                                        return e.call(n.get(t), n.get(t))
                                    }, 0),
                                            this.get(t)
                                }
                        ,
                                t.flush = function (t) {
                                    return null == t && (t = !1),
                                            t ? delete this.items[t] : this.items = {}
                                }
                        ,
                                t
                    }(),
                    _ = i.Store,
                    n.register("normal", function (t, e) {
                        return {
                            r: t.r,
                            g: t.g,
                            b: t.b
                        }
                    }),
                    n.register("multiply", function (t, e) {
                        return {
                            r: t.r * e.r / 255,
                            g: t.g * e.g / 255,
                            b: t.b * e.b / 255
                        }
                    }),
                    n.register("screen", function (t, e) {
                        return {
                            r: 255 - (255 - t.r) * (255 - e.r) / 255,
                            g: 255 - (255 - t.g) * (255 - e.g) / 255,
                            b: 255 - (255 - t.b) * (255 - e.b) / 255
                        }
                    }),
                    n.register("overlay", function (t, e) {
                        var n;
                        return n = {},
                                n.r = e.r > 128 ? 255 - 2 * (255 - t.r) * (255 - e.r) / 255 : e.r * t.r * 2 / 255,
                                n.g = e.g > 128 ? 255 - 2 * (255 - t.g) * (255 - e.g) / 255 : e.g * t.g * 2 / 255,
                                n.b = e.b > 128 ? 255 - 2 * (255 - t.b) * (255 - e.b) / 255 : e.b * t.b * 2 / 255,
                                n
                    }),
                    n.register("difference", function (t, e) {
                        return {
                            r: t.r - e.r,
                            g: t.g - e.g,
                            b: t.b - e.b
                        }
                    }),
                    n.register("addition", function (t, e) {
                        return {
                            r: e.r + t.r,
                            g: e.g + t.g,
                            b: e.b + t.b
                        }
                    }),
                    n.register("exclusion", function (t, e) {
                        return {
                            r: 128 - 2 * (e.r - 128) * (t.r - 128) / 255,
                            g: 128 - 2 * (e.g - 128) * (t.g - 128) / 255,
                            b: 128 - 2 * (e.b - 128) * (t.b - 128) / 255
                        }
                    }),
                    n.register("softLight", function (t, e) {
                        var n;
                        return n = {},
                                n.r = e.r > 128 ? 255 - (255 - e.r) * (255 - (t.r - 128)) / 255 : e.r * (t.r + 128) / 255,
                                n.g = e.g > 128 ? 255 - (255 - e.g) * (255 - (t.g - 128)) / 255 : e.g * (t.g + 128) / 255,
                                n.b = e.b > 128 ? 255 - (255 - e.b) * (255 - (t.b - 128)) / 255 : e.b * (t.b + 128) / 255,
                                n
                    }),
                    n.register("lighten", function (t, e) {
                        return {
                            r: e.r > t.r ? e.r : t.r,
                            g: e.g > t.g ? e.g : t.g,
                            b: e.b > t.b ? e.b : t.b
                        }
                    }),
                    n.register("darken", function (t, e) {
                        return {
                            r: e.r > t.r ? t.r : e.r,
                            g: e.g > t.g ? t.g : e.g,
                            b: e.b > t.b ? t.b : e.b
                        }
                    }),
                    h.register("fillColor", function () {
                        var t;
                        return t = 1 === arguments.length ? u.hexToRGB(arguments[0]) : {
                            r: arguments[0],
                            g: arguments[1],
                            b: arguments[2]
                        },
                                this.process("fillColor", function (e) {
                                    return e.r = t.r,
                                            e.g = t.g,
                                            e.b = t.b,
                                            e.a = 255,
                                            e
                                })
                    }),
                    h.register("brightness", function (t) {
                        return t = Math.floor(255 * (t / 100)),
                                this.process("brightness", function (e) {
                                    return e.r += t,
                                            e.g += t,
                                            e.b += t,
                                            e
                                })
                    }),
                    h.register("saturation", function (t) {
                        return t *= -.01,
                                this.process("saturation", function (e) {
                                    var n;
                                    return n = Math.max(e.r, e.g, e.b),
                                            e.r !== n && (e.r += (n - e.r) * t),
                                            e.g !== n && (e.g += (n - e.g) * t),
                                            e.b !== n && (e.b += (n - e.b) * t),
                                            e
                                })
                    }),
                    h.register("vibrance", function (t) {
                        return t *= -1,
                                this.process("vibrance", function (e) {
                                    var n, r, i;
                                    return i = Math.max(e.r, e.g, e.b),
                                            r = (e.r + e.g + e.b) / 3,
                                            n = 2 * Math.abs(i - r) / 255 * t / 100,
                                            e.r !== i && (e.r += (i - e.r) * n),
                                            e.g !== i && (e.g += (i - e.g) * n),
                                            e.b !== i && (e.b += (i - e.b) * n),
                                            e
                                })
                    }),
                    h.register("greyscale", function (t) {
                        return this.process("greyscale", function (t) {
                            var e;
                            return e = r.luminance(t),
                                    t.r = e,
                                    t.g = e,
                                    t.b = e,
                                    t
                        })
                    }),
                    h.register("contrast", function (t) {
                        return t = Math.pow((t + 100) / 100, 2),
                                this.process("contrast", function (e) {
                                    return e.r /= 255,
                                            e.r -= .5,
                                            e.r *= t,
                                            e.r += .5,
                                            e.r *= 255,
                                            e.g /= 255,
                                            e.g -= .5,
                                            e.g *= t,
                                            e.g += .5,
                                            e.g *= 255,
                                            e.b /= 255,
                                            e.b -= .5,
                                            e.b *= t,
                                            e.b += .5,
                                            e.b *= 255,
                                            e
                                })
                    }),
                    h.register("hue", function (t) {
                        return this.process("hue", function (e) {
                            var n, r, i, o, a, s;
                            return o = u.rgbToHSV(e.r, e.g, e.b),
                                    i = 100 * o.h,
                                    i += Math.abs(t),
                                    i %= 100,
                                    i /= 100,
                                    o.h = i,
                                    s = u.hsvToRGB(o.h, o.s, o.v),
                                    a = s.r,
                                    r = s.g,
                                    n = s.b,
                                    e.r = a,
                                    e.g = r,
                                    e.b = n,
                                    e
                        })
                    }),
                    h.register("colorize", function () {
                        var t, e;
                        return 2 === arguments.length ? (e = u.hexToRGB(arguments[0]),
                                t = arguments[1]) : 4 === arguments.length && (e = {
                            r: arguments[0],
                            g: arguments[1],
                            b: arguments[2]
                        },
                                t = arguments[3]),
                                this.process("colorize", function (n) {
                                    return n.r -= (n.r - e.r) * (t / 100),
                                            n.g -= (n.g - e.g) * (t / 100),
                                            n.b -= (n.b - e.b) * (t / 100),
                                            n
                                })
                    }),
                    h.register("invert", function () {
                        return this.process("invert", function (t) {
                            return t.r = 255 - t.r,
                                    t.g = 255 - t.g,
                                    t.b = 255 - t.b,
                                    t
                        })
                    }),
                    h.register("sepia", function (t) {
                        return null == t && (t = 100),
                                t /= 100,
                                this.process("sepia", function (e) {
                                    return e.r = Math.min(255, e.r * (1 - .607 * t) + e.g * (.769 * t) + e.b * (.189 * t)),
                                            e.g = Math.min(255, e.r * (.349 * t) + e.g * (1 - .314 * t) + e.b * (.168 * t)),
                                            e.b = Math.min(255, e.r * (.272 * t) + e.g * (.534 * t) + e.b * (1 - .869 * t)),
                                            e
                                })
                    }),
                    h.register("gamma", function (t) {
                        return this.process("gamma", function (e) {
                            return e.r = 255 * Math.pow(e.r / 255, t),
                                    e.g = 255 * Math.pow(e.g / 255, t),
                                    e.b = 255 * Math.pow(e.b / 255, t),
                                    e
                        })
                    }),
                    h.register("noise", function (t) {
                        return t = 2.55 * Math.abs(t),
                                this.process("noise", function (e) {
                                    var n;
                                    return n = r.randomRange(t * -1, t),
                                            e.r += n,
                                            e.g += n,
                                            e.b += n,
                                            e
                                })
                    }),
                    h.register("clip", function (t) {
                        return t = 2.55 * Math.abs(t),
                                this.process("clip", function (e) {
                                    return e.r > 255 - t ? e.r = 255 : e.r < t && (e.r = 0),
                                            e.g > 255 - t ? e.g = 255 : e.g < t && (e.g = 0),
                                            e.b > 255 - t ? e.b = 255 : e.b < t && (e.b = 0),
                                            e
                                })
                    }),
                    h.register("channels", function (t) {
                        var e, n;
                        if ("object" != typeof t)
                            return this;
                        for (e in t)
                            k.call(t, e) && (n = t[e],
                                    0 !== n ? t[e] /= 100 : delete t[e]);
                        return 0 === t.length ? this : this.process("channels", function (e) {
                            return null != t.red && (t.red > 0 ? e.r += (255 - e.r) * t.red : e.r -= e.r * Math.abs(t.red)),
                                    null != t.green && (t.green > 0 ? e.g += (255 - e.g) * t.green : e.g -= e.g * Math.abs(t.green)),
                                    null != t.blue && (t.blue > 0 ? e.b += (255 - e.b) * t.blue : e.b -= e.b * Math.abs(t.blue)),
                                    e
                        })
                    }),
                    h.register("curves", function () {
                        var t, e, n, i, o, a, u, s, c, h, l, f;
                        if (e = arguments[0],
                                n = 2 <= arguments.length ? C.call(arguments, 1) : [],
                                "string" == typeof e && (e = e.split("")),
                                "v" === e[0] && (e = ["r", "g", "b"]),
                                n.length < 3 || n.length > 4)
                            throw "Invalid number of arguments to curves filter";
                        if (s = n[0],
                                i = n[1],
                                o = 4 === n.length ? n[2] : n[1],
                                a = n[n.length - 1],
                                t = r.bezier(s, i, o, a, 0, 255),
                                s[0] > 0)
                            for (u = c = 0,
                                    l = s[0]; 0 <= l ? c < l : c > l; u = 0 <= l ? ++c : --c)
                                t[u] = s[1];
                        if (a[0] < 255)
                            for (u = h = f = a[0]; f <= 255 ? h <= 255 : h >= 255; u = f <= 255 ? ++h : --h)
                                t[u] = a[1];
                        return this.process("curves", function (n) {
                            var r, i;
                            for (u = r = 0,
                                    i = e.length; 0 <= i ? r < i : r > i; u = 0 <= i ? ++r : --r)
                                n[e[u]] = t[n[e[u]]];
                            return n
                        })
                    }),
                    h.register("exposure", function (t) {
                        var e, n, r;
                        return r = Math.abs(t) / 100,
                                e = [0, 255 * r],
                                n = [255 - 255 * r, 255],
                                t < 0 && (e = e.reverse(),
                                        n = n.reverse()),
                                this.curves("rgb", [0, 0], e, n, [255, 255])
                    }),
                    i.Plugin.register("crop", function (t, e, n, r) {
                        var i, o;
                        return null == n && (n = 0),
                                null == r && (r = 0),
                                "undefined" != typeof exports && null !== exports ? i = new a(t, e) : (i = document.createElement("canvas"),
                                w.copyAttributes(this.canvas, i),
                                i.width = t,
                                i.height = e),
                                o = i.getContext("2d"),
                                o.drawImage(this.canvas, n, r, t, e, 0, 0, t, e),
                                this.cropCoordinates = {
                                    x: n,
                                    y: r
                                },
                                this.cropped = !0,
                                this.replaceCanvas(i)
                    }),
                    i.Plugin.register("resize", function (t) {
                        var e, n;
                        return null == t && (t = null),
                                null === t || null == t.width && null == t.height ? void g.error("Invalid or missing dimensions given for resize") : (null == t.width ? t.width = this.canvas.width * t.height / this.canvas.height : null == t.height && (t.height = this.canvas.height * t.width / this.canvas.width),
                                "undefined" != typeof exports && null !== exports ? e = new a(t.width, t.height) : (e = document.createElement("canvas"),
                                w.copyAttributes(this.canvas, e),
                                e.width = t.width,
                                e.height = t.height),
                                n = e.getContext("2d"),
                                n.drawImage(this.canvas, 0, 0, this.canvas.width, this.canvas.height, 0, 0, t.width, t.height),
                                this.resized = !0,
                                this.replaceCanvas(e))
                    }),
                    i.Filter.register("crop", function () {
                        return this.processPlugin("crop", Array.prototype.slice.call(arguments, 0))
                    }),
                    i.Filter.register("resize", function () {
                        return this.processPlugin("resize", Array.prototype.slice.call(arguments, 0))
                    }),
                    i.Filter.register("boxBlur", function () {
                        return this.processKernel("Box Blur", [1, 1, 1, 1, 1, 1, 1, 1, 1])
                    }),
                    i.Filter.register("heavyRadialBlur", function () {
                        return this.processKernel("Heavy Radial Blur", [0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0])
                    }),
                    i.Filter.register("gaussianBlur", function () {
                        return this.processKernel("Gaussian Blur", [1, 4, 6, 4, 1, 4, 16, 24, 16, 4, 6, 24, 36, 24, 6, 4, 16, 24, 16, 4, 1, 4, 6, 4, 1])
                    }),
                    i.Filter.register("motionBlur", function (t) {
                        var e;
                        return e = 0 === t || 180 === t ? [0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0] : t > 0 && t < 90 || t > 180 && t < 270 ? [0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0] : 90 === t || 270 === t ? [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] : [1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1],
                                this.processKernel("Motion Blur", e)
                    }),
                    i.Filter.register("sharpen", function (t) {
                        return null == t && (t = 100),
                                t /= 100,
                                this.processKernel("Sharpen", [0, -t, 0, -t, 4 * t + 1, -t, 0, -t, 0])
                    }),
                    R = {
                        brightness: function (t, e, n) {
                            return t.r = t.r - t.r * e * n.strength,
                                    t.g = t.g - t.g * e * n.strength,
                                    t.b = t.b - t.b * e * n.strength,
                                    t
                        },
                        gamma: function (t, e, n) {
                            return t.r = 255 * Math.pow(t.r / 255, Math.max(10 * e * n.strength, 1)),
                                    t.g = 255 * Math.pow(t.g / 255, Math.max(10 * e * n.strength, 1)),
                                    t.b = 255 * Math.pow(t.b / 255, Math.max(10 * e * n.strength, 1)),
                                    t
                        },
                        colorize: function (t, e, n) {
                            return t.r -= (t.r - n.color.r) * e,
                                    t.g -= (t.g - n.color.g) * e,
                                    t.b -= (t.b - n.color.b) * e,
                                    t
                        }
                    },
                    h.register("vignette", function (t, e) {
                        var n, i, o, a;
                        return null == e && (e = 60),
                                "string" == typeof t && "%" === t.substr(-1) && (t = this.dimensions.height > this.dimensions.width ? this.dimensions.width * (parseInt(t.substr(0, t.length - 1), 10) / 100) : this.dimensions.height * (parseInt(t.substr(0, t.length - 1), 10) / 100)),
                                e /= 100,
                                i = [this.dimensions.width / 2, this.dimensions.height / 2],
                                a = Math.sqrt(Math.pow(i[0], 2) + Math.pow(i[1], 2)),
                                o = a - t,
                                n = r.bezier([0, 1], [30, 30], [70, 60], [100, 80]),
                                this.process("vignette", function (a) {
                                    var u, s, c;
                                    return c = a.locationXY(),
                                            u = r.distance(c.x, c.y, i[0], i[1]),
                                            u > o && (s = Math.max(1, n[Math.round((u - o) / t * 100)] / 10 * e),
                                                    a.r = 255 * Math.pow(a.r / 255, s),
                                                    a.g = 255 * Math.pow(a.g / 255, s),
                                                    a.b = 255 * Math.pow(a.b / 255, s)),
                                            a
                                })
                    }),
                    h.register("rectangularVignette", function (t) {
                        var e, n, o, a, s, c, h;
                        if (e = {
                            strength: 50,
                            cornerRadius: 0,
                            method: "brightness",
                            color: {
                                r: 0,
                                g: 0,
                                b: 0
                            }
                        },
                                t = w.extend(e, t),
                                !t.size)
                            return this;
                        if ("string" == typeof t.size)
                            o = parseInt(t.size, 10) / 100,
                                    t.size = {
                                        width: this.dimensions.width * o,
                                        height: this.dimensions.height * o
                                    };
                        else if ("object" == typeof t.size)
                            for (h = ["width", "height"],
                                    s = 0,
                                    c = h.length; s < c; s++)
                                n = h[s],
                                        "string" == typeof t.size[n] && (t.size[n] = this.dimensions[n] * (parseInt(t.size[n], 10) / 100));
                        else
                            "number" === t.size && (a = t.size,
                                    t.size = {
                                        width: a,
                                        height: a
                                    });
                        return "string" == typeof t.cornerRadius && (t.cornerRadius = t.size.width / 2 * (parseInt(t.cornerRadius, 10) / 100)),
                                t.strength /= 100,
                                t.size.width = Math.floor(t.size.width),
                                t.size.height = Math.floor(t.size.height),
                                t.image = {
                                    width: this.dimensions.width,
                                    height: this.dimensions.height
                                },
                                "colorize" === t.method && "string" == typeof t.color && (t.color = u.hexToRGB(t.color)),
                                t.coords = {
                                    left: (this.dimensions.width - t.size.width) / 2,
                                    right: this.dimensions.width - t.coords.left,
                                    bottom: (this.dimensions.height - t.size.height) / 2,
                                    top: this.dimensions.height - t.coords.bottom
                                },
                                t.corners = [{
                                        x: t.coords.left + t.cornerRadius,
                                        y: t.coords.top - t.cornerRadius
                                    }, {
                                        x: t.coords.right - t.cornerRadius,
                                        y: t.coords.top - t.cornerRadius
                                    }, {
                                        x: t.coords.right - t.cornerRadius,
                                        y: t.coords.bottom + t.cornerRadius
                                    }, {
                                        x: t.coords.left + t.cornerRadius,
                                        y: t.coords.bottom + t.cornerRadius
                                    }],
                                t.maxDist = r.distance(0, 0, t.corners[3].x, t.corners[3].y) - t.cornerRadius,
                                this.process("rectangularVignette", function (e) {
                                    var n, r, o;
                                    return r = e.locationXY(),
                                            r.x > t.corners[0].x && r.x < t.corners[1].x && r.y > t.coords.bottom && r.y < t.coords.top ? e : r.x > t.coords.left && r.x < t.coords.right && r.y > t.corners[3].y && r.y < t.corners[2].y ? e : (r.x > t.corners[0].x && r.x < t.corners[1].x && r.y > t.coords.top ? n = (r.y - t.coords.top) / t.maxDist : r.y > t.corners[2].y && r.y < t.corners[1].y && r.x > t.coords.right ? n = (r.x - t.coords.right) / t.maxDist : r.x > t.corners[0].x && r.x < t.corners[1].x && r.y < t.coords.bottom ? n = (t.coords.bottom - r.y) / t.maxDist : r.y > t.corners[2].y && r.y < t.corners[1].y && r.x < t.coords.left ? n = (t.coords.left - r.x) / t.maxDist : r.x <= t.corners[0].x && r.y >= t.corners[0].y ? (o = i.distance(r.x, r.y, t.corners[0].x, t.corners[0].y),
                                            n = (o - t.cornerRadius) / t.maxDist) : r.x >= t.corners[1].x && r.y >= t.corners[1].y ? (o = i.distance(r.x, r.y, t.corners[1].x, t.corners[1].y),
                                            n = (o - t.cornerRadius) / t.maxDist) : r.x >= t.corners[2].x && r.y <= t.corners[2].y ? (o = i.distance(r.x, r.y, t.corners[2].x, t.corners[2].y),
                                            n = (o - t.cornerRadius) / t.maxDist) : r.x <= t.corners[3].x && r.y <= t.corners[3].y && (o = i.distance(r.x, r.y, t.corners[3].x, t.corners[3].y),
                                            n = (o - t.cornerRadius) / t.maxDist),
                                            n < 0 ? e : R[t.method](e, n, t))
                                })
                    }),
                    function () {
                        var t, e, n, r, o;
                        return r = [512, 512, 456, 512, 328, 456, 335, 512, 405, 328, 271, 456, 388, 335, 292, 512, 454, 405, 364, 328, 298, 271, 496, 456, 420, 388, 360, 335, 312, 292, 273, 512, 482, 454, 428, 405, 383, 364, 345, 328, 312, 298, 284, 271, 259, 496, 475, 456, 437, 420, 404, 388, 374, 360, 347, 335, 323, 312, 302, 292, 282, 273, 265, 512, 497, 482, 468, 454, 441, 428, 417, 405, 394, 383, 373, 364, 354, 345, 337, 328, 320, 312, 305, 298, 291, 284, 278, 271, 265, 259, 507, 496, 485, 475, 465, 456, 446, 437, 428, 420, 412, 404, 396, 388, 381, 374, 367, 360, 354, 347, 341, 335, 329, 323, 318, 312, 307, 302, 297, 292, 287, 282, 278, 273, 269, 265, 261, 512, 505, 497, 489, 482, 475, 468, 461, 454, 447, 441, 435, 428, 422, 417, 411, 405, 399, 394, 389, 383, 378, 373, 368, 364, 359, 354, 350, 345, 341, 337, 332, 328, 324, 320, 316, 312, 309, 305, 301, 298, 294, 291, 287, 284, 281, 278, 274, 271, 268, 265, 262, 259, 257, 507, 501, 496, 491, 485, 480, 475, 470, 465, 460, 456, 451, 446, 442, 437, 433, 428, 424, 420, 416, 412, 408, 404, 400, 396, 392, 388, 385, 381, 377, 374, 370, 367, 363, 360, 357, 354, 350, 347, 344, 341, 338, 335, 332, 329, 326, 323, 320, 318, 315, 312, 310, 307, 304, 302, 299, 297, 294, 292, 289, 287, 285, 282, 280, 278, 275, 273, 271, 269, 267, 265, 263, 261, 259],
                                o = [9, 11, 12, 13, 13, 14, 14, 15, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24],
                                e = function (t, e, n, r, i, o, u) {
                                    var s, c, h, l, f, p, g;
                                    return s = "undefined" != typeof exports && null !== exports ? new a : document.createElement("canvas"),
                                            s.width = t,
                                            s.height = e,
                                            l = n + Math.cos(i) * o * .5,
                                            p = r + Math.sin(i) * o * .5,
                                            f = n - Math.cos(i) * o * .5,
                                            g = r - Math.sin(i) * o * .5,
                                            c = s.getContext("2d"),
                                            h = c.createLinearGradient(l, p, f, g),
                                            u ? (h.addColorStop(0, "white"),
                                                    h.addColorStop(.5, "black"),
                                                    h.addColorStop(1, "white")) : (h.addColorStop(0, "white"),
                                            h.addColorStop(1, "black")),
                                            c.fillStyle = h,
                                            c.fillRect(0, 0, t, e),
                                            c.getImageData(0, 0, t, e)
                                }
                        ,
                                n = function (t, e, n, r, i, o) {
                                    var u, s, c;
                                    return u = "undefined" != typeof exports && null !== exports ? new a : document.createElement("canvas"),
                                            u.width = t,
                                            u.height = e,
                                            s = u.getContext("2d"),
                                            c = s.createRadialGradient(n, r, i, n, r, o),
                                            c.addColorStop(1, "white"),
                                            c.addColorStop(0, "black"),
                                            s.fillStyle = c,
                                            s.fillRect(0, 0, t, e),
                                            s.getImageData(0, 0, t, e)
                                }
                        ,
                                t = function () {
                                    return this.r = 0,
                                            this.g = 0,
                                            this.b = 0,
                                            this.a = 0,
                                            this.next = null
                                }
                        ,
                                i.Plugin.register("compoundBlur", function (e, n, i, a) {
                                    var u, s, c, h, l, f, p, g, d, v, y, m, b, _, w, x, I, D, R, S, C, k, A, M, P, L, B, j, O, E, F, T, z, N, W, U, H, J, G, q, $, K, V, Z, Y, Q, X, tt, et, nt, rt, it, ot, at, ut, st, ct, ht;
                                    for (K = this.dimensions.width,
                                            v = this.dimensions.height,
                                            w = this.pixelData,
                                            j = e.data,
                                            q = K * v,
                                            $ = q << 2,
                                            A = [],
                                            m = et = 0; 0 <= $ ? et < $ : et > $; m = 0 <= $ ? ++et : --et)
                                        A[m] = w[m];
                                    for (l = 0,
                                            H = a,
                                            a -= 1; H-- >= 0; )
                                        if (I = n + .5 | 0,
                                                0 !== I) {
                                            for (I > 256 && (I = 256),
                                                    f = I + I + 1,
                                                    G = K << 2,
                                                    V = K - 1,
                                                    y = v - 1,
                                                    O = I + 1,
                                                    J = O * (O + 1) / 2,
                                                    U = new t,
                                                    z = void 0,
                                                    T = U,
                                                    m = nt = 1; 1 <= f ? nt < f : nt > f; m = 1 <= f ? ++nt : --nt)
                                                T = T.next = new t,
                                                        m === O && (z = T);
                                            for (T.next = U,
                                                    N = null,
                                                    W = null,
                                                    tt = Q = 0,
                                                    R = r[I],
                                                    F = o[I],
                                                    Y = rt = 0; 0 <= v ? rt < v : rt > v; Y = 0 <= v ? ++rt : --rt) {
                                                for (P = p = u = B = d = c = 0,
                                                        L = O * (M = A[Q]),
                                                        g = O * (k = A[Q + 1]),
                                                        s = O * (C = A[Q + 2]),
                                                        B += J * M,
                                                        d += J * k,
                                                        c += J * C,
                                                        T = U,
                                                        m = it = 0; 0 <= O ? it < O : it > O; m = 0 <= O ? ++it : --it)
                                                    T.r = M,
                                                            T.g = k,
                                                            T.b = C,
                                                            T = T.next;
                                                for (m = ot = 1; 1 <= O ? ot < O : ot > O; m = 1 <= O ? ++ot : --ot)
                                                    S = Q + ((V < m ? V : m) << 2),
                                                            B += (T.r = M = A[S]) * (E = O - m),
                                                            d += (T.g = k = A[S + 1]) * E,
                                                            c += (T.b = C = A[S + 2]) * E,
                                                            P += M,
                                                            p += k,
                                                            u += C,
                                                            T = T.next;
                                                for (N = U,
                                                        W = z,
                                                        Z = at = 0; 0 <= K ? at < K : at > K; Z = 0 <= K ? ++at : --at)
                                                    A[Q] = B * R >> F,
                                                            A[Q + 1] = d * R >> F,
                                                            A[Q + 2] = c * R >> F,
                                                            B -= L,
                                                            d -= g,
                                                            c -= s,
                                                            L -= N.r,
                                                            g -= N.g,
                                                            s -= N.b,
                                                            S = tt + ((S = Z + O) < V ? S : V) << 2,
                                                            P += N.r = A[S],
                                                            p += N.g = A[S + 1],
                                                            u += N.b = A[S + 2],
                                                            B += P,
                                                            d += p,
                                                            c += u,
                                                            N = N.next,
                                                            L += M = W.r,
                                                            g += k = W.g,
                                                            s += C = W.b,
                                                            P -= M,
                                                            p -= k,
                                                            u -= C,
                                                            W = W.next,
                                                            Q += 4;
                                                tt += K
                                            }
                                            for (Z = ut = 0; 0 <= K ? ut < K : ut > K; Z = 0 <= K ? ++ut : --ut) {
                                                for (p = u = P = d = c = B = 0,
                                                        Q = Z << 2,
                                                        L = O * (M = A[Q]),
                                                        g = O * (k = A[Q + 1]),
                                                        s = O * (C = A[Q + 2]),
                                                        B += J * M,
                                                        d += J * k,
                                                        c += J * C,
                                                        T = U,
                                                        m = st = 0; 0 <= O ? st < O : st > O; m = 0 <= O ? ++st : --st)
                                                    T.r = M,
                                                            T.g = k,
                                                            T.b = C,
                                                            T = T.next;
                                                for (X = K,
                                                        m = ct = 1; 1 <= O ? ct < O : ct > O; m = 1 <= O ? ++ct : --ct)
                                                    Q = X + Z << 2,
                                                            B += (T.r = M = A[Q]) * (E = O - m),
                                                            d += (T.g = k = A[Q + 1]) * E,
                                                            c += (T.b = C = A[Q + 2]) * E,
                                                            P += M,
                                                            p += k,
                                                            u += C,
                                                            T = T.next,
                                                            m < y && (X += K);
                                                for (Q = Z,
                                                        N = U,
                                                        W = z,
                                                        Y = ht = 0; 0 <= v ? ht < v : ht > v; Y = 0 <= v ? ++ht : --ht)
                                                    S = Q << 2,
                                                            A[S] = B * R >> F,
                                                            A[S + 1] = d * R >> F,
                                                            A[S + 2] = c * R >> F,
                                                            B -= L,
                                                            d -= g,
                                                            c -= s,
                                                            L -= N.r,
                                                            g -= N.g,
                                                            s -= N.b,
                                                            S = Z + ((S = Y + O) < y ? S : y) * K << 2,
                                                            B += P += N.r = A[S],
                                                            d += p += N.g = A[S + 1],
                                                            c += u += N.b = A[S + 2],
                                                            N = N.next,
                                                            L += M = W.r,
                                                            g += k = W.g,
                                                            s += C = W.b,
                                                            P -= M,
                                                            p -= k,
                                                            u -= C,
                                                            W = W.next,
                                                            Q += K
                                            }
                                            for (n *= i,
                                                    m = q; --m > - 1; )
                                                _ = m << 2,
                                                        D = (255 & j[_ + 2]) / 255 * a,
                                                        x = 0 | D,
                                                        x === l ? (h = 256 * (D - (0 | D)),
                                                                b = 256 - h,
                                                                w[_] = w[_] * b + A[_] * h >> 8,
                                                                w[_ + 1] = w[_ + 1] * b + A[_ + 1] * h >> 8,
                                                                w[_ + 2] = w[_ + 2] * b + A[_ + 2] * h >> 8) : x === l + 1 && (w[_] = A[_],
                                                        w[_ + 1] = A[_ + 1],
                                                        w[_ + 2] = A[_ + 2]);
                                            l++
                                        }
                                    return this
                                }),
                                i.Filter.register("tiltShift", function (t) {
                                    var n, r;
                                    return n = {
                                        center: {
                                            x: this.dimensions.width / 2,
                                            y: this.dimensions.height / 2
                                        },
                                        angle: 45,
                                        focusWidth: 200,
                                        startRadius: 3,
                                        radiusFactor: 1.5,
                                        steps: 3
                                    },
                                            t = w.extend(n, t),
                                            t.angle *= Math.PI / 180,
                                            r = e(this.dimensions.width, this.dimensions.height, t.center.x, t.center.y, t.angle, t.focusWidth, !0),
                                            this.processPlugin("compoundBlur", [r, t.startRadius, t.radiusFactor, t.steps])
                                }),
                                i.Filter.register("radialBlur", function (t) {
                                    var e, r, i, o;
                                    return e = {
                                        size: 50,
                                        center: {
                                            x: this.dimensions.width / 2,
                                            y: this.dimensions.height / 2
                                        },
                                        startRadius: 3,
                                        radiusFactor: 1.5,
                                        steps: 3,
                                        radius: null
                                    },
                                            t = w.extend(e, t),
                                            t.radius || (t.radius = this.dimensions.width < this.dimensions.height ? this.dimensions.height : this.dimensions.width),
                                            i = t.radius / 2 - t.size,
                                            o = t.radius / 2,
                                            r = n(this.dimensions.width, this.dimensions.height, t.center.x, t.center.y, i, o),
                                            this.processPlugin("compoundBlur", [r, t.startRadius, t.radiusFactor, t.steps])
                                })
                    }(),
                    i.Filter.register("edgeEnhance", function () {
                        return this.processKernel("Edge Enhance", [0, 0, 0, -1, 1, 0, 0, 0, 0])
                    }),
                    i.Filter.register("edgeDetect", function () {
                        return this.processKernel("Edge Detect", [-1, -1, -1, -1, 8, -1, -1, -1, -1])
                    }),
                    i.Filter.register("emboss", function () {
                        return this.processKernel("Emboss", [-2, -1, 0, -1, 1, 1, 0, 1, 2])
                    }),
                    i.Filter.register("posterize", function (t) {
                        var e, n;
                        return e = 256 / t,
                                n = 255 / (t - 1),
                                this.process("posterize", function (t) {
                                    return t.r = Math.floor(Math.floor(t.r / e) * n),
                                            t.g = Math.floor(Math.floor(t.g / e) * n),
                                            t.b = Math.floor(Math.floor(t.b / e) * n),
                                            t
                                })
                    }),
                    i.Filter.register("vintage", function (t) {
                        if (null == t && (t = !0),
                                this.greyscale(),
                                this.contrast(5),
                                this.noise(3),
                                this.sepia(100),
                                this.channels({
                                    red: 8,
                                    blue: 2,
                                    green: 4
                                }),
                                this.gamma(.87),
                                t)
                            return this.vignette("40%", 30)
                    }),
                    i.Filter.register("lomo", function (t) {
                        return null == t && (t = !0),
                                this.brightness(15),
                                this.exposure(15),
                                this.curves("rgb", [0, 0], [200, 0], [155, 255], [255, 255]),
                                this.saturation(-20),
                                this.gamma(1.8),
                                t && this.vignette("50%", 60),
                                this.brightness(5)
                    }),
                    i.Filter.register("clarity", function (t) {
                        return null == t && (t = !1),
                                this.vibrance(20),
                                this.curves("rgb", [5, 0], [130, 150], [190, 220], [250, 255]),
                                this.sharpen(15),
                                this.vignette("45%", 20),
                                t && (this.greyscale(),
                                        this.contrast(4)),
                                this
                    }),
                    i.Filter.register("sinCity", function () {
                        return this.contrast(100),
                                this.brightness(15),
                                this.exposure(10),
                                this.posterize(80),
                                this.clip(30),
                                this.greyscale()
                    }),
                    i.Filter.register("sunrise", function () {
                        return this.exposure(3.5),
                                this.saturation(-5),
                                this.vibrance(50),
                                this.sepia(60),
                                this.colorize("#e87b22", 10),
                                this.channels({
                                    red: 8,
                                    blue: 8
                                }),
                                this.contrast(5),
                                this.gamma(1.2),
                                this.vignette("55%", 25)
                    }),
                    i.Filter.register("crossProcess", function () {
                        return this.exposure(5),
                                this.colorize("#e87b22", 4),
                                this.sepia(20),
                                this.channels({
                                    blue: 8,
                                    red: 3
                                }),
                                this.curves("b", [0, 0], [100, 150], [180, 180], [255, 255]),
                                this.contrast(15),
                                this.vibrance(75),
                                this.gamma(1.6)
                    }),
                    i.Filter.register("orangePeel", function () {
                        return this.curves("rgb", [0, 0], [100, 50], [140, 200], [255, 255]),
                                this.vibrance(-30),
                                this.saturation(-30),
                                this.colorize("#ff9000", 30),
                                this.contrast(-5),
                                this.gamma(1.4)
                    }),
                    i.Filter.register("love", function () {
                        return this.brightness(5),
                                this.exposure(8),
                                this.contrast(4),
                                this.colorize("#c42007", 30),
                                this.vibrance(50),
                                this.gamma(1.3)
                    }),
                    i.Filter.register("grungy", function () {
                        return this.gamma(1.5),
                                this.clip(25),
                                this.saturation(-60),
                                this.contrast(5),
                                this.noise(5),
                                this.vignette("50%", 30)
                    }),
                    i.Filter.register("jarques", function () {
                        return this.saturation(-35),
                                this.curves("b", [20, 0], [90, 120], [186, 144], [255, 230]),
                                this.curves("r", [0, 0], [144, 90], [138, 120], [255, 255]),
                                this.curves("g", [10, 0], [115, 105], [148, 100], [255, 248]),
                                this.curves("rgb", [0, 0], [120, 100], [128, 140], [255, 255]),
                                this.sharpen(20)
                    }),
                    i.Filter.register("pinhole", function () {
                        return this.greyscale(),
                                this.sepia(10),
                                this.exposure(10),
                                this.contrast(15),
                                this.vignette("60%", 35)
                    }),
                    i.Filter.register("oldBoot", function () {
                        return this.saturation(-20),
                                this.vibrance(-50),
                                this.gamma(1.1),
                                this.sepia(30),
                                this.channels({
                                    red: -10,
                                    blue: 5
                                }),
                                this.curves("rgb", [0, 0], [80, 50], [128, 230], [255, 255]),
                                this.vignette("60%", 30)
                    }),
                    i.Filter.register("glowingSun", function (t) {
                        if (null == t && (t = !0),
                                this.brightness(10),
                                this.newLayer(function () {
                                    return this.setBlendingMode("multiply"),
                                            this.opacity(80),
                                            this.copyParent(),
                                            this.filter.gamma(.8),
                                            this.filter.contrast(50),
                                            this.filter.exposure(10)
                                }),
                                this.newLayer(function () {
                                    return this.setBlendingMode("softLight"),
                                            this.opacity(80),
                                            this.fillColor("#f49600")
                                }),
                                this.exposure(20),
                                this.gamma(.8),
                                t)
                            return this.vignette("45%", 20)
                    }),
                    i.Filter.register("hazyDays", function () {
                        return this.gamma(1.2),
                                this.newLayer(function () {
                                    return this.setBlendingMode("overlay"),
                                            this.opacity(60),
                                            this.copyParent(),
                                            this.filter.channels({
                                                red: 5
                                            }),
                                            this.filter.stackBlur(15)
                                }),
                                this.newLayer(function () {
                                    return this.setBlendingMode("addition"),
                                            this.opacity(40),
                                            this.fillColor("#6899ba")
                                }),
                                this.newLayer(function () {
                                    return this.setBlendingMode("multiply"),
                                            this.opacity(35),
                                            this.copyParent(),
                                            this.filter.brightness(40),
                                            this.filter.vibrance(40),
                                            this.filter.exposure(30),
                                            this.filter.contrast(15),
                                            this.filter.curves("r", [0, 40], [128, 128], [128, 128], [255, 215]),
                                            this.filter.curves("g", [0, 40], [128, 128], [128, 128], [255, 215]),
                                            this.filter.curves("b", [0, 40], [128, 128], [128, 128], [255, 215]),
                                            this.filter.stackBlur(5)
                                }),
                                this.curves("r", [20, 0], [128, 158], [128, 128], [235, 255]),
                                this.curves("g", [20, 0], [128, 128], [128, 128], [235, 255]),
                                this.curves("b", [20, 0], [128, 108], [128, 128], [235, 255]),
                                this.vignette("45%", 20)
                    }),
                    i.Filter.register("herMajesty", function () {
                        return this.brightness(40),
                                this.colorize("#ea1c5d", 10),
                                this.curves("b", [0, 10], [128, 180], [190, 190], [255, 255]),
                                this.newLayer(function () {
                                    return this.setBlendingMode("overlay"),
                                            this.opacity(50),
                                            this.copyParent(),
                                            this.filter.gamma(.7),
                                            this.newLayer(function () {
                                                return this.setBlendingMode("normal"),
                                                        this.opacity(60),
                                                        this.fillColor("#ea1c5d")
                                            })
                                }),
                                this.newLayer(function () {
                                    return this.setBlendingMode("multiply"),
                                            this.opacity(60),
                                            this.copyParent(),
                                            this.filter.saturation(50),
                                            this.filter.hue(90),
                                            this.filter.contrast(10)
                                }),
                                this.gamma(1.4),
                                this.vibrance(-30),
                                this.newLayer(function () {
                                    return this.opacity(10),
                                            this.fillColor("#e5f0ff")
                                }),
                                this
                    }),
                    i.Filter.register("nostalgia", function () {
                        return this.saturation(20),
                                this.gamma(1.4),
                                this.greyscale(),
                                this.contrast(5),
                                this.sepia(100),
                                this.channels({
                                    red: 8,
                                    blue: 2,
                                    green: 4
                                }),
                                this.gamma(.8),
                                this.contrast(5),
                                this.exposure(10),
                                this.newLayer(function () {
                                    return this.setBlendingMode("overlay"),
                                            this.copyParent(),
                                            this.opacity(55),
                                            this.filter.stackBlur(10)
                                }),
                                this.vignette("50%", 30)
                    }),
                    i.Filter.register("hemingway", function () {
                        return this.greyscale(),
                                this.contrast(10),
                                this.gamma(.9),
                                this.newLayer(function () {
                                    return this.setBlendingMode("multiply"),
                                            this.opacity(40),
                                            this.copyParent(),
                                            this.filter.exposure(15),
                                            this.filter.contrast(15),
                                            this.filter.channels({
                                                green: 10,
                                                red: 5
                                            })
                                }),
                                this.sepia(30),
                                this.curves("rgb", [0, 10], [120, 90], [180, 200], [235, 255]),
                                this.channels({
                                    red: 5,
                                    green: -2
                                }),
                                this.exposure(15)
                    }),
                    i.Filter.register("concentrate", function () {
                        return this.sharpen(40),
                                this.saturation(-50),
                                this.channels({
                                    red: 3
                                }),
                                this.newLayer(function () {
                                    return this.setBlendingMode("multiply"),
                                            this.opacity(80),
                                            this.copyParent(),
                                            this.filter.sharpen(5),
                                            this.filter.contrast(50),
                                            this.filter.exposure(10),
                                            this.filter.channels({
                                                blue: 5
                                            })
                                }),
                                this.brightness(10)
                    }),
                    i.Plugin.register("rotate", function (t) {
                        var e, n, r, i, o, u, s, c;
                        return e = t % 360,
                                0 === e ? this.dimensions = {
                                    width: this.canvas.width,
                                    height: this.canvas.height
                                } : (o = Math.PI / 180,
                                "undefined" != typeof exports && null !== exports ? n = new a : (n = document.createElement("canvas"),
                                        w.copyAttributes(this.canvas, n)),
                                90 === e || e === -270 || 270 === e || e === -90 ? (u = this.canvas.height,
                                        i = this.canvas.width,
                                        s = u / 2,
                                        c = i / 2) : 180 === e ? (u = this.canvas.width,
                                i = this.canvas.height,
                                s = u / 2,
                                c = i / 2) : (u = Math.sqrt(Math.pow(this.originalWidth, 2) + Math.pow(this.originalHeight, 2)),
                                i = u,
                                s = this.canvas.height / 2,
                                c = this.canvas.width / 2),
                                n.width = u,
                                n.height = i,
                                r = n.getContext("2d"),
                                r.save(),
                                r.translate(s, c),
                                r.rotate(e * o),
                                r.drawImage(this.canvas, -this.canvas.width / 2, -this.canvas.height / 2, this.canvas.width, this.canvas.height),
                                r.restore(),
                                this.replaceCanvas(n))
                    }),
                    i.Filter.register("rotate", function () {
                        return this.processPlugin("rotate", Array.prototype.slice.call(arguments, 0))
                    }),
                    function () {
                        var t, e, n;
                        return e = [512, 512, 456, 512, 328, 456, 335, 512, 405, 328, 271, 456, 388, 335, 292, 512, 454, 405, 364, 328, 298, 271, 496, 456, 420, 388, 360, 335, 312, 292, 273, 512, 482, 454, 428, 405, 383, 364, 345, 328, 312, 298, 284, 271, 259, 496, 475, 456, 437, 420, 404, 388, 374, 360, 347, 335, 323, 312, 302, 292, 282, 273, 265, 512, 497, 482, 468, 454, 441, 428, 417, 405, 394, 383, 373, 364, 354, 345, 337, 328, 320, 312, 305, 298, 291, 284, 278, 271, 265, 259, 507, 496, 485, 475, 465, 456, 446, 437, 428, 420, 412, 404, 396, 388, 381, 374, 367, 360, 354, 347, 341, 335, 329, 323, 318, 312, 307, 302, 297, 292, 287, 282, 278, 273, 269, 265, 261, 512, 505, 497, 489, 482, 475, 468, 461, 454, 447, 441, 435, 428, 422, 417, 411, 405, 399, 394, 389, 383, 378, 373, 368, 364, 359, 354, 350, 345, 341, 337, 332, 328, 324, 320, 316, 312, 309, 305, 301, 298, 294, 291, 287, 284, 281, 278, 274, 271, 268, 265, 262, 259, 257, 507, 501, 496, 491, 485, 480, 475, 470, 465, 460, 456, 451, 446, 442, 437, 433, 428, 424, 420, 416, 412, 408, 404, 400, 396, 392, 388, 385, 381, 377, 374, 370, 367, 363, 360, 357, 354, 350, 347, 344, 341, 338, 335, 332, 329, 326, 323, 320, 318, 315, 312, 310, 307, 304, 302, 299, 297, 294, 292, 289, 287, 285, 282, 280, 278, 275, 273, 271, 269, 267, 265, 263, 261, 259],
                                n = [9, 11, 12, 13, 13, 14, 14, 15, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24],
                                t = function () {
                                    return this.r = 0,
                                            this.g = 0,
                                            this.b = 0,
                                            this.a = 0,
                                            this.next = null
                                }
                        ,
                                i.Plugin.register("stackBlur", function (r) {
                                    var i, o, a, u, s, c, h, l, f, p, g, d, v, y, m, b, _, w, x, I, D, R, S, C, k, A, M, P, L, B, j, O, E, F, T, z, N, W, U, H, J, G, q, $, K;
                                    if (!(isNaN(r) || r < 1)) {
                                        for (r |= 0,
                                                m = this.pixelData,
                                                B = this.dimensions.width,
                                                l = this.dimensions.height,
                                                u = r + r + 1,
                                                L = B << 2,
                                                j = B - 1,
                                                f = l - 1,
                                                I = r + 1,
                                                P = I * (I + 1) / 2,
                                                M = new t,
                                                S = M,
                                                p = N = 1; 1 <= u ? N < u : N > u; p = 1 <= u ? ++N : --N)
                                            S = S.next = new t,
                                                    p === I && (C = S);
                                        for (S.next = M,
                                                k = null,
                                                A = null,
                                                z = F = 0,
                                                g = e[r],
                                                R = n[r],
                                                E = W = 0; 0 <= l ? W < l : W > l; E = 0 <= l ? ++W : --W) {
                                            for (_ = s = i = x = h = a = 0,
                                                    w = I * (b = m[F]),
                                                    c = I * (y = m[F + 1]),
                                                    o = I * (v = m[F + 2]),
                                                    x += P * b,
                                                    h += P * y,
                                                    a += P * v,
                                                    S = M,
                                                    p = U = 0; 0 <= I ? U < I : U > I; p = 0 <= I ? ++U : --U)
                                                S.r = b,
                                                        S.g = y,
                                                        S.b = v,
                                                        S = S.next;
                                            for (p = H = 1; 1 <= I ? H < I : H > I; p = 1 <= I ? ++H : --H)
                                                d = F + ((j < p ? j : p) << 2),
                                                        x += (S.r = b = m[d]) * (D = I - p),
                                                        h += (S.g = y = m[d + 1]) * D,
                                                        a += (S.b = v = m[d + 2]) * D,
                                                        _ += b,
                                                        s += y,
                                                        i += v,
                                                        S = S.next;
                                            for (k = M,
                                                    A = C,
                                                    O = J = 0; 0 <= B ? J < B : J > B; O = 0 <= B ? ++J : --J)
                                                m[F] = x * g >> R,
                                                        m[F + 1] = h * g >> R,
                                                        m[F + 2] = a * g >> R,
                                                        x -= w,
                                                        h -= c,
                                                        a -= o,
                                                        w -= k.r,
                                                        c -= k.g,
                                                        o -= k.b,
                                                        d = z + ((d = O + r + 1) < j ? d : j) << 2,
                                                        _ += k.r = m[d],
                                                        s += k.g = m[d + 1],
                                                        i += k.b = m[d + 2],
                                                        x += _,
                                                        h += s,
                                                        a += i,
                                                        k = k.next,
                                                        w += b = A.r,
                                                        c += y = A.g,
                                                        o += v = A.b,
                                                        _ -= b,
                                                        s -= y,
                                                        i -= v,
                                                        A = A.next,
                                                        F += 4;
                                            z += B
                                        }
                                        for (O = G = 0; 0 <= B ? G < B : G > B; O = 0 <= B ? ++G : --G) {
                                            for (s = i = _ = h = a = x = 0,
                                                    F = O << 2,
                                                    w = I * (b = m[F]),
                                                    c = I * (y = m[F + 1]),
                                                    o = I * (v = m[F + 2]),
                                                    x += P * b,
                                                    h += P * y,
                                                    a += P * v,
                                                    S = M,
                                                    p = q = 0; 0 <= I ? q < I : q > I; p = 0 <= I ? ++q : --q)
                                                S.r = b,
                                                        S.g = y,
                                                        S.b = v,
                                                        S = S.next;
                                            for (T = B,
                                                    p = $ = 1; 1 <= r ? $ <= r : $ >= r; p = 1 <= r ? ++$ : --$)
                                                F = T + O << 2,
                                                        x += (S.r = b = m[F]) * (D = I - p),
                                                        h += (S.g = y = m[F + 1]) * D,
                                                        a += (S.b = v = m[F + 2]) * D,
                                                        _ += b,
                                                        s += y,
                                                        i += v,
                                                        S = S.next,
                                                        p < f && (T += B);
                                            for (F = O,
                                                    k = M,
                                                    A = C,
                                                    E = K = 0; 0 <= l ? K < l : K > l; E = 0 <= l ? ++K : --K)
                                                d = F << 2,
                                                        m[d] = x * g >> R,
                                                        m[d + 1] = h * g >> R,
                                                        m[d + 2] = a * g >> R,
                                                        x -= w,
                                                        h -= c,
                                                        a -= o,
                                                        w -= k.r,
                                                        c -= k.g,
                                                        o -= k.b,
                                                        d = O + ((d = E + I) < f ? d : f) * B << 2,
                                                        x += _ += k.r = m[d],
                                                        h += s += k.g = m[d + 1],
                                                        a += i += k.b = m[d + 2],
                                                        k = k.next,
                                                        w += b = A.r,
                                                        c += y = A.g,
                                                        o += v = A.b,
                                                        _ -= b,
                                                        s -= y,
                                                        i -= v,
                                                        A = A.next,
                                                        F += B
                                        }
                                        return this
                                    }
                                }),
                                i.Filter.register("stackBlur", function (t) {
                                    return this.processPlugin("stackBlur", [t])
                                })
                    }(),
                    i.Filter.register("threshold", function (t) {
                        return this.process("threshold", function (e) {
                            var n;
                            return n = .2126 * e.r + .7152 * e.g + .0722 * e.b,
                                    n < t ? (e.r = 0,
                                            e.g = 0,
                                            e.b = 0) : (e.r = 255,
                                    e.g = 255,
                                    e.b = 255),
                                    e
                        })
                    })
        }
.call(this),
        function () {
            function t(t, e) {
                return t.set(e[0], e[1]),
                        t
            }
            function e(t, e) {
                return t.add(e),
                        t
            }
            function n(t, e, n) {
                switch (n.length) {
                    case 0:
                        return t.call(e);
                    case 1:
                        return t.call(e, n[0]);
                    case 2:
                        return t.call(e, n[0], n[1]);
                    case 3:
                        return t.call(e, n[0], n[1], n[2])
                }
                return t.apply(e, n)
            }
            function r(t, e, n, r) {
                for (var i = -1, o = t ? t.length : 0; ++i < o; ) {
                    var a = t[i];
                    e(r, a, n(a), t)
                }
                return r
            }
            function i(t, e) {
                for (var n = -1, r = t ? t.length : 0; ++n < r && e(t[n], n, t) !== !1; )
                    ;
                return t
            }
            function o(t, e) {
                for (var n = t ? t.length : 0; n-- && e(t[n], n, t) !== !1; )
                    ;
                return t
            }
            function a(t, e) {
                for (var n = -1, r = t ? t.length : 0; ++n < r; )
                    if (!e(t[n], n, t))
                        return !1;
                return !0
            }
            function u(t, e) {
                for (var n = -1, r = t ? t.length : 0, i = 0, o = []; ++n < r; ) {
                    var a = t[n];
                    e(a, n, t) && (o[i++] = a)
                }
                return o
            }
            function s(t, e) {
                var n = t ? t.length : 0;
                return !!n && b(t, e, 0) > -1
            }
            function c(t, e, n) {
                for (var r = -1, i = t ? t.length : 0; ++r < i; )
                    if (n(e, t[r]))
                        return !0;
                return !1
            }
            function h(t, e) {
                for (var n = -1, r = t ? t.length : 0, i = Array(r); ++n < r; )
                    i[n] = e(t[n], n, t);
                return i
            }
            function l(t, e) {
                for (var n = -1, r = e.length, i = t.length; ++n < r; )
                    t[i + n] = e[n];
                return t
            }
            function f(t, e, n, r) {
                var i = -1
                        , o = t ? t.length : 0;
                for (r && o && (n = t[++i]); ++i < o; )
                    n = e(n, t[i], i, t);
                return n
            }
            function p(t, e, n, r) {
                var i = t ? t.length : 0;
                for (r && i && (n = t[--i]); i--; )
                    n = e(n, t[i], i, t);
                return n
            }
            function g(t, e) {
                for (var n = -1, r = t ? t.length : 0; ++n < r; )
                    if (e(t[n], n, t))
                        return !0;
                return !1
            }
            function d(t) {
                return t.split("")
            }
            function v(t) {
                return t.match(Me) || []
            }
            function y(t, e, n) {
                var r;
                return n(t, function (t, n, i) {
                    if (e(t, n, i))
                        return r = n,
                                !1
                }),
                        r
            }
            function m(t, e, n, r) {
                for (var i = t.length, o = n + (r ? 1 : -1); r ? o-- : ++o < i; )
                    if (e(t[o], o, t))
                        return o;
                return -1
            }
            function b(t, e, n) {
                return e === e ? q(t, e, n) : m(t, w, n)
            }
            function _(t, e, n, r) {
                for (var i = n - 1, o = t.length; ++i < o; )
                    if (r(t[i], e))
                        return i;
                return -1
            }
            function w(t) {
                return t !== t
            }
            function x(t, e) {
                var n = t ? t.length : 0;
                return n ? C(t, e) / n : At
            }
            function I(t) {
                return function (e) {
                    return null == e ? X : e[t]
                }
            }
            function D(t) {
                return function (e) {
                    return null == t ? X : t[e]
                }
            }
            function R(t, e, n, r, i) {
                return i(t, function (t, i, o) {
                    n = r ? (r = !1,
                            t) : e(n, t, i, o)
                }),
                        n
            }
            function S(t, e) {
                var n = t.length;
                for (t.sort(e); n--; )
                    t[n] = t[n].value;
                return t
            }
            function C(t, e) {
                for (var n, r = -1, i = t.length; ++r < i; ) {
                    var o = e(t[r]);
                    o !== X && (n = n === X ? o : n + o)
                }
                return n
            }
            function k(t, e) {
                for (var n = -1, r = Array(t); ++n < t; )
                    r[n] = e(n);
                return r
            }
            function A(t, e) {
                return h(e, function (e) {
                    return [e, t[e]]
                })
            }
            function M(t) {
                return function (e) {
                    return t(e)
                }
            }
            function P(t, e) {
                return h(e, function (e) {
                    return t[e]
                })
            }
            function L(t, e) {
                return t.has(e)
            }
            function B(t, e) {
                for (var n = -1, r = t.length; ++n < r && b(e, t[n], 0) > - 1; )
                    ;
                return n
            }
            function j(t, e) {
                for (var n = t.length; n-- && b(e, t[n], 0) > - 1; )
                    ;
                return n
            }
            function O(t, e) {
                for (var n = t.length, r = 0; n--; )
                    t[n] === e && ++r;
                return r
            }
            function E(t) {
                return "\\" + zn[t]
            }
            function F(t, e) {
                return null == t ? X : t[e]
            }
            function T(t) {
                return Mn.test(t)
            }
            function z(t) {
                return Pn.test(t)
            }
            function N(t) {
                for (var e, n = []; !(e = t.next()).done; )
                    n.push(e.value);
                return n
            }
            function W(t) {
                var e = -1
                        , n = Array(t.size);
                return t.forEach(function (t, r) {
                    n[++e] = [r, t]
                }),
                        n
            }
            function U(t, e) {
                return function (n) {
                    return t(e(n))
                }
            }
            function H(t, e) {
                for (var n = -1, r = t.length, i = 0, o = []; ++n < r; ) {
                    var a = t[n];
                    a !== e && a !== at || (t[n] = at,
                            o[i++] = n)
                }
                return o
            }
            function J(t) {
                var e = -1
                        , n = Array(t.size);
                return t.forEach(function (t) {
                    n[++e] = t
                }),
                        n
            }
            function G(t) {
                var e = -1
                        , n = Array(t.size);
                return t.forEach(function (t) {
                    n[++e] = [t, t]
                }),
                        n
            }
            function q(t, e, n) {
                for (var r = n - 1, i = t.length; ++r < i; )
                    if (t[r] === e)
                        return r;
                return -1
            }
            function $(t, e, n) {
                for (var r = n + 1; r--; )
                    if (t[r] === e)
                        return r;
                return r
            }
            function K(t) {
                return T(t) ? Z(t) : nr(t)
            }
            function V(t) {
                return T(t) ? Y(t) : d(t)
            }
            function Z(t) {
                for (var e = kn.lastIndex = 0; kn.test(t); )
                    ++e;
                return e
            }
            function Y(t) {
                return t.match(kn) || []
            }
            function Q(t) {
                return t.match(An) || []
            }
            var X, tt = "4.16.2", et = 200, nt = "Unsupported core-js use. Try https://github.com/es-shims.", rt = "Expected a function", it = "__lodash_hash_undefined__", ot = 500, at = "__lodash_placeholder__", ut = 1, st = 2, ct = 4, ht = 8, lt = 16, ft = 32, pt = 64, gt = 128, dt = 256, vt = 512, yt = 1, mt = 2, bt = 30, _t = "...", wt = 500, xt = 16, It = 1, Dt = 2, Rt = 3, St = 1 / 0, Ct = 9007199254740991, kt = 1.7976931348623157e308, At = NaN, Mt = 4294967295, Pt = Mt - 1, Lt = Mt >>> 1, Bt = [["ary", gt], ["bind", ut], ["bindKey", st], ["curry", ht], ["curryRight", lt], ["flip", vt], ["partial", ft], ["partialRight", pt], ["rearg", dt]], jt = "[object Arguments]", Ot = "[object Array]", Et = "[object Boolean]", Ft = "[object Date]", Tt = "[object Error]", zt = "[object Function]", Nt = "[object GeneratorFunction]", Wt = "[object Map]", Ut = "[object Number]", Ht = "[object Object]", Jt = "[object Promise]", Gt = "[object RegExp]", qt = "[object Set]", $t = "[object String]", Kt = "[object Symbol]", Vt = "[object WeakMap]", Zt = "[object WeakSet]", Yt = "[object ArrayBuffer]", Qt = "[object DataView]", Xt = "[object Float32Array]", te = "[object Float64Array]", ee = "[object Int8Array]", ne = "[object Int16Array]", re = "[object Int32Array]", ie = "[object Uint8Array]", oe = "[object Uint8ClampedArray]", ae = "[object Uint16Array]", ue = "[object Uint32Array]", se = /\b__p \+= '';/g, ce = /\b(__p \+=) '' \+/g, he = /(__e\(.*?\)|\b__t\)) \+\n'';/g, le = /&(?:amp|lt|gt|quot|#39);/g, fe = /[&<>"']/g, pe = RegExp(le.source), ge = RegExp(fe.source), de = /<%-([\s\S]+?)%>/g, ve = /<%([\s\S]+?)%>/g, ye = /<%=([\s\S]+?)%>/g, me = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, be = /^\w*$/, _e = /^\./, we = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g, xe = /[\\^$.*+?()[\]{}|]/g, Ie = RegExp(xe.source), De = /^\s+|\s+$/g, Re = /^\s+/, Se = /\s+$/, Ce = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/, ke = /\{\n\/\* \[wrapped with (.+)\] \*/, Ae = /,? & /, Me = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g, Pe = /\\(\\)?/g, Le = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g, Be = /\w*$/, je = /^[-+]0x[0-9a-f]+$/i, Oe = /^0b[01]+$/i, Ee = /^\[object .+?Constructor\]$/, Fe = /^0o[0-7]+$/i, Te = /^(?:0|[1-9]\d*)$/, ze = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g, Ne = /($^)/, We = /['\n\r\u2028\u2029\\]/g, Ue = "\\ud800-\\udfff", He = "\\u0300-\\u036f\\ufe20-\\ufe23", Je = "\\u20d0-\\u20f0", Ge = "\\u2700-\\u27bf", qe = "a-z\\xdf-\\xf6\\xf8-\\xff", $e = "\\xac\\xb1\\xd7\\xf7", Ke = "\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf", Ve = "\\u2000-\\u206f", Ze = " \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000", Ye = "A-Z\\xc0-\\xd6\\xd8-\\xde", Qe = "\\ufe0e\\ufe0f", Xe = $e + Ke + Ve + Ze, tn = "['’]", en = "[" + Ue + "]", nn = "[" + Xe + "]", rn = "[" + He + Je + "]", on = "\\d+", an = "[" + Ge + "]", un = "[" + qe + "]", sn = "[^" + Ue + Xe + on + Ge + qe + Ye + "]", cn = "\\ud83c[\\udffb-\\udfff]", hn = "(?:" + rn + "|" + cn + ")", ln = "[^" + Ue + "]", fn = "(?:\\ud83c[\\udde6-\\uddff]){2}", pn = "[\\ud800-\\udbff][\\udc00-\\udfff]", gn = "[" + Ye + "]", dn = "\\u200d", vn = "(?:" + un + "|" + sn + ")", yn = "(?:" + gn + "|" + sn + ")", mn = "(?:" + tn + "(?:d|ll|m|re|s|t|ve))?", bn = "(?:" + tn + "(?:D|LL|M|RE|S|T|VE))?", _n = hn + "?", wn = "[" + Qe + "]?", xn = "(?:" + dn + "(?:" + [ln, fn, pn].join("|") + ")" + wn + _n + ")*", In = wn + _n + xn, Dn = "(?:" + [an, fn, pn].join("|") + ")" + In, Rn = "(?:" + [ln + rn + "?", rn, fn, pn, en].join("|") + ")", Sn = RegExp(tn, "g"), Cn = RegExp(rn, "g"), kn = RegExp(cn + "(?=" + cn + ")|" + Rn + In, "g"), An = RegExp([gn + "?" + un + "+" + mn + "(?=" + [nn, gn, "$"].join("|") + ")", yn + "+" + bn + "(?=" + [nn, gn + vn, "$"].join("|") + ")", gn + "?" + vn + "+" + mn, gn + "+" + bn, on, Dn].join("|"), "g"), Mn = RegExp("[" + dn + Ue + He + Je + Qe + "]"), Pn = /[a-z][A-Z]|[A-Z]{2,}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/, Ln = ["Array", "Buffer", "DataView", "Date", "Error", "Float32Array", "Float64Array", "Function", "Int8Array", "Int16Array", "Int32Array", "Map", "Math", "Object", "Promise", "RegExp", "Set", "String", "Symbol", "TypeError", "Uint8Array", "Uint8ClampedArray", "Uint16Array", "Uint32Array", "WeakMap", "_", "clearTimeout", "isFinite", "parseInt", "setTimeout"], Bn = -1, jn = {};
            jn[Xt] = jn[te] = jn[ee] = jn[ne] = jn[re] = jn[ie] = jn[oe] = jn[ae] = jn[ue] = !0,
                    jn[jt] = jn[Ot] = jn[Yt] = jn[Et] = jn[Qt] = jn[Ft] = jn[Tt] = jn[zt] = jn[Wt] = jn[Ut] = jn[Ht] = jn[Gt] = jn[qt] = jn[$t] = jn[Vt] = !1;
            var On = {};
            On[jt] = On[Ot] = On[Yt] = On[Qt] = On[Et] = On[Ft] = On[Xt] = On[te] = On[ee] = On[ne] = On[re] = On[Wt] = On[Ut] = On[Ht] = On[Gt] = On[qt] = On[$t] = On[Kt] = On[ie] = On[oe] = On[ae] = On[ue] = !0,
                    On[Tt] = On[zt] = On[Vt] = !1;
            var En = {
                "À": "A",
                "Á": "A",
                "Â": "A",
                "Ã": "A",
                "Ä": "A",
                "Å": "A",
                "à": "a",
                "á": "a",
                "â": "a",
                "ã": "a",
                "ä": "a",
                "å": "a",
                "Ç": "C",
                "ç": "c",
                "Ð": "D",
                "ð": "d",
                "È": "E",
                "É": "E",
                "Ê": "E",
                "Ë": "E",
                "è": "e",
                "é": "e",
                "ê": "e",
                "ë": "e",
                "Ì": "I",
                "Í": "I",
                "Î": "I",
                "Ï": "I",
                "ì": "i",
                "í": "i",
                "î": "i",
                "ï": "i",
                "Ñ": "N",
                "ñ": "n",
                "Ò": "O",
                "Ó": "O",
                "Ô": "O",
                "Õ": "O",
                "Ö": "O",
                "Ø": "O",
                "ò": "o",
                "ó": "o",
                "ô": "o",
                "õ": "o",
                "ö": "o",
                "ø": "o",
                "Ù": "U",
                "Ú": "U",
                "Û": "U",
                "Ü": "U",
                "ù": "u",
                "ú": "u",
                "û": "u",
                "ü": "u",
                "Ý": "Y",
                "ý": "y",
                "ÿ": "y",
                "Æ": "Ae",
                "æ": "ae",
                "Þ": "Th",
                "þ": "th",
                "ß": "ss",
                "Ā": "A",
                "Ă": "A",
                "Ą": "A",
                "ā": "a",
                "ă": "a",
                "ą": "a",
                "Ć": "C",
                "Ĉ": "C",
                "Ċ": "C",
                "Č": "C",
                "ć": "c",
                "ĉ": "c",
                "ċ": "c",
                "č": "c",
                "Ď": "D",
                "Đ": "D",
                "ď": "d",
                "đ": "d",
                "Ē": "E",
                "Ĕ": "E",
                "Ė": "E",
                "Ę": "E",
                "Ě": "E",
                "ē": "e",
                "ĕ": "e",
                "ė": "e",
                "ę": "e",
                "ě": "e",
                "Ĝ": "G",
                "Ğ": "G",
                "Ġ": "G",
                "Ģ": "G",
                "ĝ": "g",
                "ğ": "g",
                "ġ": "g",
                "ģ": "g",
                "Ĥ": "H",
                "Ħ": "H",
                "ĥ": "h",
                "ħ": "h",
                "Ĩ": "I",
                "Ī": "I",
                "Ĭ": "I",
                "Į": "I",
                "İ": "I",
                "ĩ": "i",
                "ī": "i",
                "ĭ": "i",
                "į": "i",
                "ı": "i",
                "Ĵ": "J",
                "ĵ": "j",
                "Ķ": "K",
                "ķ": "k",
                "ĸ": "k",
                "Ĺ": "L",
                "Ļ": "L",
                "Ľ": "L",
                "Ŀ": "L",
                "Ł": "L",
                "ĺ": "l",
                "ļ": "l",
                "ľ": "l",
                "ŀ": "l",
                "ł": "l",
                "Ń": "N",
                "Ņ": "N",
                "Ň": "N",
                "Ŋ": "N",
                "ń": "n",
                "ņ": "n",
                "ň": "n",
                "ŋ": "n",
                "Ō": "O",
                "Ŏ": "O",
                "Ő": "O",
                "ō": "o",
                "ŏ": "o",
                "ő": "o",
                "Ŕ": "R",
                "Ŗ": "R",
                "Ř": "R",
                "ŕ": "r",
                "ŗ": "r",
                "ř": "r",
                "Ś": "S",
                "Ŝ": "S",
                "Ş": "S",
                "Š": "S",
                "ś": "s",
                "ŝ": "s",
                "ş": "s",
                "š": "s",
                "Ţ": "T",
                "Ť": "T",
                "Ŧ": "T",
                "ţ": "t",
                "ť": "t",
                "ŧ": "t",
                "Ũ": "U",
                "Ū": "U",
                "Ŭ": "U",
                "Ů": "U",
                "Ű": "U",
                "Ų": "U",
                "ũ": "u",
                "ū": "u",
                "ŭ": "u",
                "ů": "u",
                "ű": "u",
                "ų": "u",
                "Ŵ": "W",
                "ŵ": "w",
                "Ŷ": "Y",
                "ŷ": "y",
                "Ÿ": "Y",
                "Ź": "Z",
                "Ż": "Z",
                "Ž": "Z",
                "ź": "z",
                "ż": "z",
                "ž": "z",
                "Ĳ": "IJ",
                "ĳ": "ij",
                "Œ": "Oe",
                "œ": "oe",
                "ŉ": "'n",
                "ſ": "s"
            }
            , Fn = {
                "&": "&amp;",
                "<": "&lt;",
                ">": "&gt;",
                '"': "&quot;",
                "'": "&#39;"
            }
            , Tn = {
                "&amp;": "&",
                "&lt;": "<",
                "&gt;": ">",
                "&quot;": '"',
                "&#39;": "'"
            }
            , zn = {
                "\\": "\\",
                "'": "'",
                "\n": "n",
                "\r": "r",
                "\u2028": "u2028",
                "\u2029": "u2029"
            }
            , Nn = parseFloat
                    , Wn = parseInt
                    , Un = "object" == typeof global && global && global.Object === Object && global
                    , Hn = "object" == typeof self && self && self.Object === Object && self
                    , Jn = Un || Hn || Function("return this")()
                    , Gn = "object" == typeof exports && exports && !exports.nodeType && exports
                    , qn = Gn && "object" == typeof module && module && !module.nodeType && module
                    , $n = qn && qn.exports === Gn
                    , Kn = $n && Un.process
                    , Vn = function () {
                        try {
                            return Kn && Kn.binding("util")
                        } catch (t) {
                        }
                    }()
                    , Zn = Vn && Vn.isArrayBuffer
                    , Yn = Vn && Vn.isDate
                    , Qn = Vn && Vn.isMap
                    , Xn = Vn && Vn.isRegExp
                    , tr = Vn && Vn.isSet
                    , er = Vn && Vn.isTypedArray
                    , nr = I("length")
                    , rr = D(En)
                    , ir = D(Fn)
                    , or = D(Tn)
                    , ar = function sr(d) {
                        function D(t) {
                            if (Zu(t) && !uf(t) && !(t instanceof Y)) {
                                if (t instanceof Z)
                                    return t;
                                if (sh.call(t, "__wrapped__"))
                                    return qo(t)
                            }
                            return new Z(t)
                        }
                        function q() {}
                        function Z(t, e) {
                            this.__wrapped__ = t,
                                    this.__actions__ = [],
                                    this.__chain__ = !!e,
                                    this.__index__ = 0,
                                    this.__values__ = X
                        }
                        function Y(t) {
                            this.__wrapped__ = t,
                                    this.__actions__ = [],
                                    this.__dir__ = 1,
                                    this.__filtered__ = !1,
                                    this.__iteratees__ = [],
                                    this.__takeCount__ = Mt,
                                    this.__views__ = []
                        }
                        function Me() {
                            var t = new Y(this.__wrapped__);
                            return t.__actions__ = Pi(this.__actions__),
                                    t.__dir__ = this.__dir__,
                                    t.__filtered__ = this.__filtered__,
                                    t.__iteratees__ = Pi(this.__iteratees__),
                                    t.__takeCount__ = this.__takeCount__,
                                    t.__views__ = Pi(this.__views__),
                                    t
                        }
                        function Ue() {
                            if (this.__filtered__) {
                                var t = new Y(this);
                                t.__dir__ = -1,
                                        t.__filtered__ = !0
                            } else
                                t = this.clone(),
                                        t.__dir__ *= -1;
                            return t
                        }
                        function He() {
                            var t = this.__wrapped__.value()
                                    , e = this.__dir__
                                    , n = uf(t)
                                    , r = e < 0
                                    , i = n ? t.length : 0
                                    , o = vo(0, i, this.__views__)
                                    , a = o.start
                                    , u = o.end
                                    , s = u - a
                                    , c = r ? u : a - 1
                                    , h = this.__iteratees__
                                    , l = h.length
                                    , f = 0
                                    , p = Eh(s, this.__takeCount__);
                            if (!n || i < et || i == s && p == s)
                                return fi(t, this.__actions__);
                            var g = [];
                            t: for (; s-- && f < p; ) {
                                c += e;
                                for (var d = -1, v = t[c]; ++d < l; ) {
                                    var y = h[d]
                                            , m = y.iteratee
                                            , b = y.type
                                            , _ = m(v);
                                    if (b == Dt)
                                        v = _;
                                    else if (!_) {
                                        if (b == It)
                                            continue t;
                                        break t
                                    }
                                }
                                g[f++] = v
                            }
                            return g
                        }
                        function Je(t) {
                            var e = -1
                                    , n = t ? t.length : 0;
                            for (this.clear(); ++e < n; ) {
                                var r = t[e];
                                this.set(r[0], r[1])
                            }
                        }
                        function Ge() {
                            this.__data__ = qh ? qh(null) : {},
                                    this.size = 0
                        }
                        function qe(t) {
                            var e = this.has(t) && delete this.__data__[t];
                            return this.size -= e ? 1 : 0,
                                    e
                        }
                        function $e(t) {
                            var e = this.__data__;
                            if (qh) {
                                var n = e[t];
                                return n === it ? X : n
                            }
                            return sh.call(e, t) ? e[t] : X
                        }
                        function Ke(t) {
                            var e = this.__data__;
                            return qh ? e[t] !== X : sh.call(e, t)
                        }
                        function Ve(t, e) {
                            var n = this.__data__;
                            return this.size += this.has(t) ? 0 : 1,
                                    n[t] = qh && e === X ? it : e,
                                    this
                        }
                        function Ze(t) {
                            var e = -1
                                    , n = t ? t.length : 0;
                            for (this.clear(); ++e < n; ) {
                                var r = t[e];
                                this.set(r[0], r[1])
                            }
                        }
                        function Ye() {
                            this.__data__ = [],
                                    this.size = 0
                        }
                        function Qe(t) {
                            var e = this.__data__
                                    , n = Rn(e, t);
                            if (n < 0)
                                return !1;
                            var r = e.length - 1;
                            return n == r ? e.pop() : Ih.call(e, n, 1),
                                    --this.size,
                                    !0
                        }
                        function Xe(t) {
                            var e = this.__data__
                                    , n = Rn(e, t);
                            return n < 0 ? X : e[n][1]
                        }
                        function tn(t) {
                            return Rn(this.__data__, t) > -1
                        }
                        function en(t, e) {
                            var n = this.__data__
                                    , r = Rn(n, t);
                            return r < 0 ? (++this.size,
                                    n.push([t, e])) : n[r][1] = e,
                                    this
                        }
                        function nn(t) {
                            var e = -1
                                    , n = t ? t.length : 0;
                            for (this.clear(); ++e < n; ) {
                                var r = t[e];
                                this.set(r[0], r[1])
                            }
                        }
                        function rn() {
                            this.size = 0,
                                    this.__data__ = {
                                        hash: new Je,
                                        map: new (Uh || Ze),
                                        string: new Je
                                    }
                        }
                        function on(t) {
                            var e = fo(this, t)["delete"](t);
                            return this.size -= e ? 1 : 0,
                                    e
                        }
                        function an(t) {
                            return fo(this, t).get(t)
                        }
                        function un(t) {
                            return fo(this, t).has(t)
                        }
                        function sn(t, e) {
                            var n = fo(this, t)
                                    , r = n.size;
                            return n.set(t, e),
                                    this.size += n.size == r ? 0 : 1,
                                    this
                        }
                        function cn(t) {
                            var e = -1
                                    , n = t ? t.length : 0;
                            for (this.__data__ = new nn; ++e < n; )
                                this.add(t[e])
                        }
                        function hn(t) {
                            return this.__data__.set(t, it),
                                    this
                        }
                        function ln(t) {
                            return this.__data__.has(t)
                        }
                        function fn(t) {
                            var e = this.__data__ = new Ze(t);
                            this.size = e.size
                        }
                        function pn() {
                            this.__data__ = new Ze,
                                    this.size = 0
                        }
                        function gn(t) {
                            var e = this.__data__
                                    , n = e["delete"](t);
                            return this.size = e.size,
                                    n
                        }
                        function dn(t) {
                            return this.__data__.get(t)
                        }
                        function vn(t) {
                            return this.__data__.has(t)
                        }
                        function yn(t, e) {
                            var n = this.__data__;
                            if (n instanceof Ze) {
                                var r = n.__data__;
                                if (!Uh || r.length < et - 1)
                                    return r.push([t, e]),
                                            this.size = ++n.size,
                                            this;
                                n = this.__data__ = new nn(r)
                            }
                            return n.set(t, e),
                                    this.size = n.size,
                                    this
                        }
                        function mn(t, e) {
                            var n = uf(t) || Eu(t) ? k(t.length, th) : []
                                    , r = n.length
                                    , i = !!r;
                            for (var o in t)
                                !e && !sh.call(t, o) || i && ("length" == o || Do(o, r)) || n.push(o);
                            return n
                        }
                        function bn(t) {
                            var e = t.length;
                            return e ? t[$r(0, e - 1)] : X
                        }
                        function _n(t, e) {
                            return Uo(Pi(t), e)
                        }
                        function wn(t) {
                            return Uo(Pi(t))
                        }
                        function xn(t, e, n, r) {
                            return t === X || Ou(t, ih[n]) && !sh.call(r, n) ? e : t
                        }
                        function In(t, e, n) {
                            (n === X || Ou(t[e], n)) && ("number" != typeof e || n !== X || e in t) || Mn(t, e, n)
                        }
                        function Dn(t, e, n) {
                            var r = t[e];
                            sh.call(t, e) && Ou(r, n) && (n !== X || e in t) || Mn(t, e, n)
                        }
                        function Rn(t, e) {
                            for (var n = t.length; n--; )
                                if (Ou(t[n][0], e))
                                    return n;
                            return -1
                        }
                        function kn(t, e, n, r) {
                            return ol(t, function (t, i, o) {
                                e(r, t, n(t), o)
                            }),
                                    r
                        }
                        function An(t, e) {
                            return t && Li(e, Ps(e), t)
                        }
                        function Mn(t, e, n) {
                            "__proto__" == e && mh ? mh(t, e, {
                                configurable: !0,
                                enumerable: !0,
                                value: n,
                                writable: !0
                            }) : t[e] = n
                        }
                        function Pn(t, e) {
                            for (var n = -1, r = null == t, i = e.length, o = $c(i); ++n < i; )
                                o[n] = r ? X : ks(t, e[n]);
                            return o
                        }
                        function En(t, e, n) {
                            return t === t && (n !== X && (t = t <= n ? t : n),
                                    e !== X && (t = t >= e ? t : e)),
                                    t
                        }
                        function Fn(t, e, n, r, o, a, u) {
                            var s;
                            if (r && (s = a ? r(t, o, a, u) : r(t)),
                                    s !== X)
                                return s;
                            if (!Vu(t))
                                return t;
                            var c = uf(t);
                            if (c) {
                                if (s = bo(t),
                                        !e)
                                    return Pi(t, s)
                            } else {
                                var h = yl(t)
                                        , l = h == zt || h == Nt;
                                if (cf(t))
                                    return bi(t, e);
                                if (h == Ht || h == jt || l && !a) {
                                    if (s = _o(l ? {} : t),
                                            !e)
                                        return Bi(t, An(s, t))
                                } else {
                                    if (!On[h])
                                        return a ? t : {};
                                    s = wo(t, h, Fn, e)
                                }
                            }
                            u || (u = new fn);
                            var f = u.get(t);
                            if (f)
                                return f;
                            if (u.set(t, s),
                                    !c)
                                var p = n ? uo(t) : Ps(t);
                            return i(p || t, function (i, o) {
                                p && (o = i,
                                        i = t[o]),
                                        Dn(s, o, Fn(i, e, n, r, o, t, u))
                            }),
                                    s
                        }
                        function Tn(t) {
                            var e = Ps(t);
                            return function (n) {
                                return zn(n, t, e)
                            }
                        }
                        function zn(t, e, n) {
                            var r = n.length;
                            if (null == t)
                                return !r;
                            for (t = Qc(t); r--; ) {
                                var i = n[r]
                                        , o = e[i]
                                        , a = t[i];
                                if (a === X && !(i in t) || !o(a))
                                    return !1
                            }
                            return !0
                        }
                        function Un(t, e, n) {
                            if ("function" != typeof t)
                                throw new eh(rt);
                            return _l(function () {
                                t.apply(X, n)
                            }, e)
                        }
                        function Hn(t, e, n, r) {
                            var i = -1
                                    , o = s
                                    , a = !0
                                    , u = t.length
                                    , l = []
                                    , f = e.length;
                            if (!u)
                                return l;
                            n && (e = h(e, M(n))),
                                    r ? (o = c,
                                            a = !1) : e.length >= et && (o = L,
                                    a = !1,
                                    e = new cn(e));
                            t: for (; ++i < u; ) {
                                var p = t[i]
                                        , g = n ? n(p) : p;
                                if (p = r || 0 !== p ? p : 0,
                                        a && g === g) {
                                    for (var d = f; d--; )
                                        if (e[d] === g)
                                            continue t;
                                    l.push(p)
                                } else
                                    o(e, g, r) || l.push(p)
                            }
                            return l
                        }
                        function Gn(t, e) {
                            var n = !0;
                            return ol(t, function (t, r, i) {
                                return n = !!e(t, r, i)
                            }),
                                    n
                        }
                        function qn(t, e, n) {
                            for (var r = -1, i = t.length; ++r < i; ) {
                                var o = t[r]
                                        , a = e(o);
                                if (null != a && (u === X ? a === a && !us(a) : n(a, u)))
                                    var u = a
                                            , s = o
                            }
                            return s
                        }
                        function Kn(t, e, n, r) {
                            var i = t.length;
                            for (n = ps(n),
                                    n < 0 && (n = - n > i ? 0 : i + n),
                                    r = r === X || r > i ? i : ps(r),
                                    r < 0 && (r += i),
                                    r = n > r ? 0 : gs(r); n < r; )
                                t[n++] = e;
                            return t
                        }
                        function Vn(t, e) {
                            var n = [];
                            return ol(t, function (t, r, i) {
                                e(t, r, i) && n.push(t)
                            }),
                                    n
                        }
                        function nr(t, e, n, r, i) {
                            var o = -1
                                    , a = t.length;
                            for (n || (n = Io),
                                    i || (i = []); ++o < a; ) {
                                var u = t[o];
                                e > 0 && n(u) ? e > 1 ? nr(u, e - 1, n, r, i) : l(i, u) : r || (i[i.length] = u)
                            }
                            return i
                        }
                        function ar(t, e) {
                            return t && ul(t, e, Ps)
                        }
                        function cr(t, e) {
                            return t && sl(t, e, Ps)
                        }
                        function hr(t, e) {
                            return u(e, function (e) {
                                return qu(t[e])
                            })
                        }
                        function lr(t, e) {
                            e = So(e, t) ? [e] : yi(e);
                            for (var n = 0, r = e.length; null != t && n < r; )
                                t = t[Ho(e[n++])];
                            return n && n == r ? t : X
                        }
                        function fr(t, e, n) {
                            var r = e(t);
                            return uf(t) ? r : l(r, n(t))
                        }
                        function pr(t) {
                            return lh.call(t)
                        }
                        function gr(t, e) {
                            return t > e
                        }
                        function dr(t, e) {
                            return null != t && sh.call(t, e)
                        }
                        function vr(t, e) {
                            return null != t && e in Qc(t)
                        }
                        function yr(t, e, n) {
                            return t >= Eh(e, n) && t < Oh(e, n)
                        }
                        function mr(t, e, n) {
                            for (var r = n ? c : s, i = t[0].length, o = t.length, a = o, u = $c(o), l = 1 / 0, f = []; a--; ) {
                                var p = t[a];
                                a && e && (p = h(p, M(e))),
                                        l = Eh(p.length, l),
                                        u[a] = !n && (e || i >= 120 && p.length >= 120) ? new cn(a && p) : X
                            }
                            p = t[0];
                            var g = -1
                                    , d = u[0];
                            t: for (; ++g < i && f.length < l; ) {
                                var v = p[g]
                                        , y = e ? e(v) : v;
                                if (v = n || 0 !== v ? v : 0,
                                        !(d ? L(d, y) : r(f, y, n))) {
                                    for (a = o; --a; ) {
                                        var m = u[a];
                                        if (!(m ? L(m, y) : r(t[a], y, n)))
                                            continue t
                                    }
                                    d && d.push(y),
                                            f.push(v)
                                }
                            }
                            return f
                        }
                        function br(t, e, n, r) {
                            return ar(t, function (t, i, o) {
                                e(r, n(t), i, o)
                            }),
                                    r
                        }
                        function _r(t, e, r) {
                            So(e, t) || (e = yi(e),
                                    t = To(t, e),
                                    e = la(e));
                            var i = null == t ? t : t[Ho(e)];
                            return null == i ? X : n(i, t, r)
                        }
                        function wr(t) {
                            return Zu(t) && lh.call(t) == Yt
                        }
                        function xr(t) {
                            return Zu(t) && lh.call(t) == Ft
                        }
                        function Ir(t, e, n, r, i) {
                            return t === e || (null == t || null == e || !Vu(t) && !Zu(e) ? t !== t && e !== e : Dr(t, e, Ir, n, r, i))
                        }
                        function Dr(t, e, n, r, i, o) {
                            var a = uf(t)
                                    , u = uf(e)
                                    , s = Ot
                                    , c = Ot;
                            a || (s = yl(t),
                                    s = s == jt ? Ht : s),
                                    u || (c = yl(e),
                                            c = c == jt ? Ht : c);
                            var h = s == Ht
                                    , l = c == Ht
                                    , f = s == c;
                            if (f && !h)
                                return o || (o = new fn),
                                        a || gf(t) ? ro(t, e, n, r, i, o) : io(t, e, s, n, r, i, o);
                            if (!(i & mt)) {
                                var p = h && sh.call(t, "__wrapped__")
                                        , g = l && sh.call(e, "__wrapped__");
                                if (p || g) {
                                    var d = p ? t.value() : t
                                            , v = g ? e.value() : e;
                                    return o || (o = new fn),
                                            n(d, v, r, i, o)
                                }
                            }
                            return !!f && (o || (o = new fn),
                                    oo(t, e, n, r, i, o))
                        }
                        function Rr(t) {
                            return Zu(t) && yl(t) == Wt
                        }
                        function Sr(t, e, n, r) {
                            var i = n.length
                                    , o = i
                                    , a = !r;
                            if (null == t)
                                return !o;
                            for (t = Qc(t); i--; ) {
                                var u = n[i];
                                if (a && u[2] ? u[1] !== t[u[0]] : !(u[0]in t))
                                    return !1
                            }
                            for (; ++i < o; ) {
                                u = n[i];
                                var s = u[0]
                                        , c = t[s]
                                        , h = u[1];
                                if (a && u[2]) {
                                    if (c === X && !(s in t))
                                        return !1
                                } else {
                                    var l = new fn;
                                    if (r)
                                        var f = r(c, h, s, t, e, l);
                                    if (!(f === X ? Ir(h, c, r, yt | mt, l) : f))
                                        return !1
                                }
                            }
                            return !0
                        }
                        function Cr(t) {
                            if (!Vu(t) || Ao(t))
                                return !1;
                            var e = qu(t) ? ph : Ee;
                            return e.test(Jo(t))
                        }
                        function kr(t) {
                            return Vu(t) && lh.call(t) == Gt
                        }
                        function Ar(t) {
                            return Zu(t) && yl(t) == qt
                        }
                        function Mr(t) {
                            return Zu(t) && Ku(t.length) && !!jn[lh.call(t)]
                        }
                        function Pr(t) {
                            return "function" == typeof t ? t : null == t ? wc : "object" == typeof t ? uf(t) ? Fr(t[0], t[1]) : Er(t) : Ac(t)
                        }
                        function Lr(t) {
                            if (!Mo(t))
                                return jh(t);
                            var e = [];
                            for (var n in Qc(t))
                                sh.call(t, n) && "constructor" != n && e.push(n);
                            return e
                        }
                        function Br(t) {
                            if (!Vu(t))
                                return Eo(t);
                            var e = Mo(t)
                                    , n = [];
                            for (var r in t)
                                ("constructor" != r || !e && sh.call(t, r)) && n.push(r);
                            return n
                        }
                        function jr(t, e) {
                            return t < e
                        }
                        function Or(t, e) {
                            var n = -1
                                    , r = Fu(t) ? $c(t.length) : [];
                            return ol(t, function (t, i, o) {
                                r[++n] = e(t, i, o)
                            }),
                                    r
                        }
                        function Er(t) {
                            var e = po(t);
                            return 1 == e.length && e[0][2] ? Lo(e[0][0], e[0][1]) : function (n) {
                                return n === t || Sr(n, t, e)
                            }
                        }
                        function Fr(t, e) {
                            return So(t) && Po(e) ? Lo(Ho(t), e) : function (n) {
                                var r = ks(n, t);
                                return r === X && r === e ? Ms(n, t) : Ir(e, r, X, yt | mt)
                            }
                        }
                        function Tr(t, e, n, r, o) {
                            if (t !== e) {
                                if (!uf(e) && !gf(e))
                                    var a = Br(e);
                                i(a || e, function (i, u) {
                                    if (a && (u = i,
                                            i = e[u]),
                                            Vu(i))
                                        o || (o = new fn),
                                                zr(t, e, u, n, Tr, r, o);
                                    else {
                                        var s = r ? r(t[u], i, u + "", t, e, o) : X;
                                        s === X && (s = i),
                                                In(t, u, s)
                                    }
                                })
                            }
                        }
                        function zr(t, e, n, r, i, o, a) {
                            var u = t[n]
                                    , s = e[n]
                                    , c = a.get(s);
                            if (c)
                                return void In(t, n, c);
                            var h = o ? o(u, s, n + "", t, e, a) : X
                                    , l = h === X;
                            l && (h = s,
                                    uf(s) || gf(s) ? uf(u) ? h = u : Tu(u) ? h = Pi(u) : (l = !1,
                                    h = Fn(s, !0)) : is(s) || Eu(s) ? Eu(u) ? h = vs(u) : !Vu(u) || r && qu(u) ? (l = !1,
                                    h = Fn(s, !0)) : h = u : l = !1),
                                    l && (a.set(s, h),
                                            i(h, s, r, o, a),
                                            a["delete"](s)),
                                    In(t, n, h)
                        }
                        function Nr(t, e) {
                            var n = t.length;
                            if (n)
                                return e += e < 0 ? n : 0,
                                        Do(e, n) ? t[e] : X
                        }
                        function Wr(t, e, n) {
                            var r = -1;
                            e = h(e.length ? e : [wc], M(lo()));
                            var i = Or(t, function (t, n, i) {
                                var o = h(e, function (e) {
                                    return e(t)
                                });
                                return {
                                    criteria: o,
                                    index: ++r,
                                    value: t
                                }
                            });
                            return S(i, function (t, e) {
                                return ki(t, e, n)
                            })
                        }
                        function Ur(t, e) {
                            return t = Qc(t),
                                    Hr(t, e, function (e, n) {
                                        return n in t
                                    })
                        }
                        function Hr(t, e, n) {
                            for (var r = -1, i = e.length, o = {}; ++r < i; ) {
                                var a = e[r]
                                        , u = t[a];
                                n(u, a) && Mn(o, a, u)
                            }
                            return o
                        }
                        function Jr(t) {
                            return function (e) {
                                return lr(e, t)
                            }
                        }
                        function Gr(t, e, n, r) {
                            var i = r ? _ : b
                                    , o = -1
                                    , a = e.length
                                    , u = t;
                            for (t === e && (e = Pi(e)),
                                    n && (u = h(t, M(n))); ++o < a; )
                                for (var s = 0, c = e[o], l = n ? n(c) : c; (s = i(u, l, s, r)) > - 1; )
                                    u !== t && Ih.call(u, s, 1),
                                            Ih.call(t, s, 1);
                            return t
                        }
                        function qr(t, e) {
                            for (var n = t ? e.length : 0, r = n - 1; n--; ) {
                                var i = e[n];
                                if (n == r || i !== o) {
                                    var o = i;
                                    if (Do(i))
                                        Ih.call(t, i, 1);
                                    else if (So(i, t))
                                        delete t[Ho(i)];
                                    else {
                                        var a = yi(i)
                                                , u = To(t, a);
                                        null != u && delete u[Ho(la(a))]
                                    }
                                }
                            }
                            return t
                        }
                        function $r(t, e) {
                            return t + Ah(zh() * (e - t + 1))
                        }
                        function Kr(t, e, n, r) {
                            for (var i = -1, o = Oh(kh((e - t) / (n || 1)), 0), a = $c(o); o--; )
                                a[r ? o : ++i] = t,
                                        t += n;
                            return a
                        }
                        function Vr(t, e) {
                            var n = "";
                            if (!t || e < 1 || e > Ct)
                                return n;
                            do
                                e % 2 && (n += t),
                                        e = Ah(e / 2),
                                        e && (t += t);
                            while (e);
                            return n
                        }
                        function Zr(t, e) {
                            return wl(Fo(t, e, wc), t + "")
                        }
                        function Yr(t) {
                            return bn(Js(t))
                        }
                        function Qr(t, e) {
                            return Uo(Js(t), e)
                        }
                        function Xr(t, e, n, r) {
                            if (!Vu(t))
                                return t;
                            e = So(e, t) ? [e] : yi(e);
                            for (var i = -1, o = e.length, a = o - 1, u = t; null != u && ++i < o; ) {
                                var s = Ho(e[i])
                                        , c = n;
                                if (i != a) {
                                    var h = u[s];
                                    c = r ? r(h, s, u) : X,
                                            c === X && (c = Vu(h) ? h : Do(e[i + 1]) ? [] : {})
                                }
                                Dn(u, s, c),
                                        u = u[s]
                            }
                            return t
                        }
                        function ti(t) {
                            return Uo(Js(t))
                        }
                        function ei(t, e, n) {
                            var r = -1
                                    , i = t.length;
                            e < 0 && (e = -e > i ? 0 : i + e),
                                    n = n > i ? i : n,
                                    n < 0 && (n += i),
                                    i = e > n ? 0 : n - e >>> 0,
                                    e >>>= 0;
                            for (var o = $c(i); ++r < i; )
                                o[r] = t[r + e];
                            return o
                        }
                        function ni(t, e) {
                            var n;
                            return ol(t, function (t, r, i) {
                                return n = e(t, r, i),
                                        !n
                            }),
                                    !!n
                        }
                        function ri(t, e, n) {
                            var r = 0
                                    , i = t ? t.length : r;
                            if ("number" == typeof e && e === e && i <= Lt) {
                                for (; r < i; ) {
                                    var o = r + i >>> 1
                                            , a = t[o];
                                    null !== a && !us(a) && (n ? a <= e : a < e) ? r = o + 1 : i = o
                                }
                                return i
                            }
                            return ii(t, e, wc, n)
                        }
                        function ii(t, e, n, r) {
                            e = n(e);
                            for (var i = 0, o = t ? t.length : 0, a = e !== e, u = null === e, s = us(e), c = e === X; i < o; ) {
                                var h = Ah((i + o) / 2)
                                        , l = n(t[h])
                                        , f = l !== X
                                        , p = null === l
                                        , g = l === l
                                        , d = us(l);
                                if (a)
                                    var v = r || g;
                                else
                                    v = c ? g && (r || f) : u ? g && f && (r || !p) : s ? g && f && !p && (r || !d) : !p && !d && (r ? l <= e : l < e);
                                v ? i = h + 1 : o = h
                            }
                            return Eh(o, Pt)
                        }
                        function oi(t, e) {
                            for (var n = -1, r = t.length, i = 0, o = []; ++n < r; ) {
                                var a = t[n]
                                        , u = e ? e(a) : a;
                                if (!n || !Ou(u, s)) {
                                    var s = u;
                                    o[i++] = 0 === a ? 0 : a
                                }
                            }
                            return o
                        }
                        function ai(t) {
                            return "number" == typeof t ? t : us(t) ? At : +t
                        }
                        function ui(t) {
                            if ("string" == typeof t)
                                return t;
                            if (us(t))
                                return rl ? rl.call(t) : "";
                            var e = t + "";
                            return "0" == e && 1 / t == -St ? "-0" : e
                        }
                        function si(t, e, n) {
                            var r = -1
                                    , i = s
                                    , o = t.length
                                    , a = !0
                                    , u = []
                                    , h = u;
                            if (n)
                                a = !1,
                                        i = c;
                            else if (o >= et) {
                                var l = e ? null : pl(t);
                                if (l)
                                    return J(l);
                                a = !1,
                                        i = L,
                                        h = new cn
                            } else
                                h = e ? [] : u;
                            t: for (; ++r < o; ) {
                                var f = t[r]
                                        , p = e ? e(f) : f;
                                if (f = n || 0 !== f ? f : 0,
                                        a && p === p) {
                                    for (var g = h.length; g--; )
                                        if (h[g] === p)
                                            continue t;
                                    e && h.push(p),
                                            u.push(f)
                                } else
                                    i(h, p, n) || (h !== u && h.push(p),
                                            u.push(f))
                            }
                            return u
                        }
                        function ci(t, e) {
                            e = So(e, t) ? [e] : yi(e),
                                    t = To(t, e);
                            var n = Ho(la(e));
                            return !(null != t && sh.call(t, n)) || delete t[n]
                        }
                        function hi(t, e, n, r) {
                            return Xr(t, e, n(lr(t, e)), r)
                        }
                        function li(t, e, n, r) {
                            for (var i = t.length, o = r ? i : -1; (r ? o-- : ++o < i) && e(t[o], o, t); )
                                ;
                            return n ? ei(t, r ? 0 : o, r ? o + 1 : i) : ei(t, r ? o + 1 : 0, r ? i : o)
                        }
                        function fi(t, e) {
                            var n = t;
                            return n instanceof Y && (n = n.value()),
                                    f(e, function (t, e) {
                                        return e.func.apply(e.thisArg, l([t], e.args))
                                    }, n)
                        }
                        function pi(t, e, n) {
                            for (var r = -1, i = t.length; ++r < i; )
                                var o = o ? l(Hn(o, t[r], e, n), Hn(t[r], o, e, n)) : t[r];
                            return o && o.length ? si(o, e, n) : []
                        }
                        function gi(t, e, n) {
                            for (var r = -1, i = t.length, o = e.length, a = {}; ++r < i; ) {
                                var u = r < o ? e[r] : X;
                                n(a, t[r], u)
                            }
                            return a
                        }
                        function di(t) {
                            return Tu(t) ? t : []
                        }
                        function vi(t) {
                            return "function" == typeof t ? t : wc
                        }
                        function yi(t) {
                            return uf(t) ? t : xl(t)
                        }
                        function mi(t, e, n) {
                            var r = t.length;
                            return n = n === X ? r : n,
                                    !e && n >= r ? t : ei(t, e, n)
                        }
                        function bi(t, e) {
                            if (e)
                                return t.slice();
                            var n = t.length
                                    , r = yh ? yh(n) : new t.constructor(n);
                            return t.copy(r),
                                    r
                        }
                        function _i(t) {
                            var e = new t.constructor(t.byteLength);
                            return new vh(e).set(new vh(t)),
                                    e
                        }
                        function wi(t, e) {
                            var n = e ? _i(t.buffer) : t.buffer;
                            return new t.constructor(n, t.byteOffset, t.byteLength)
                        }
                        function xi(e, n, r) {
                            var i = n ? r(W(e), !0) : W(e);
                            return f(i, t, new e.constructor)
                        }
                        function Ii(t) {
                            var e = new t.constructor(t.source, Be.exec(t));
                            return e.lastIndex = t.lastIndex,
                                    e
                        }
                        function Di(t, n, r) {
                            var i = n ? r(J(t), !0) : J(t);
                            return f(i, e, new t.constructor)
                        }
                        function Ri(t) {
                            return nl ? Qc(nl.call(t)) : {}
                        }
                        function Si(t, e) {
                            var n = e ? _i(t.buffer) : t.buffer;
                            return new t.constructor(n, t.byteOffset, t.length)
                        }
                        function Ci(t, e) {
                            if (t !== e) {
                                var n = t !== X
                                        , r = null === t
                                        , i = t === t
                                        , o = us(t)
                                        , a = e !== X
                                        , u = null === e
                                        , s = e === e
                                        , c = us(e);
                                if (!u && !c && !o && t > e || o && a && s && !u && !c || r && a && s || !n && s || !i)
                                    return 1;
                                if (!r && !o && !c && t < e || c && n && i && !r && !o || u && n && i || !a && i || !s)
                                    return -1
                            }
                            return 0
                        }
                        function ki(t, e, n) {
                            for (var r = -1, i = t.criteria, o = e.criteria, a = i.length, u = n.length; ++r < a; ) {
                                var s = Ci(i[r], o[r]);
                                if (s) {
                                    if (r >= u)
                                        return s;
                                    var c = n[r];
                                    return s * ("desc" == c ? -1 : 1)
                                }
                            }
                            return t.index - e.index
                        }
                        function Ai(t, e, n, r) {
                            for (var i = -1, o = t.length, a = n.length, u = -1, s = e.length, c = Oh(o - a, 0), h = $c(s + c), l = !r; ++u < s; )
                                h[u] = e[u];
                            for (; ++i < a; )
                                (l || i < o) && (h[n[i]] = t[i]);
                            for (; c--; )
                                h[u++] = t[i++];
                            return h
                        }
                        function Mi(t, e, n, r) {
                            for (var i = -1, o = t.length, a = -1, u = n.length, s = -1, c = e.length, h = Oh(o - u, 0), l = $c(h + c), f = !r; ++i < h; )
                                l[i] = t[i];
                            for (var p = i; ++s < c; )
                                l[p + s] = e[s];
                            for (; ++a < u; )
                                (f || i < o) && (l[p + n[a]] = t[i++]);
                            return l
                        }
                        function Pi(t, e) {
                            var n = -1
                                    , r = t.length;
                            for (e || (e = $c(r)); ++n < r; )
                                e[n] = t[n];
                            return e
                        }
                        function Li(t, e, n, r) {
                            var i = !n;
                            n || (n = {});
                            for (var o = -1, a = e.length; ++o < a; ) {
                                var u = e[o]
                                        , s = r ? r(n[u], t[u], u, n, t) : X;
                                s === X && (s = t[u]),
                                        i ? Mn(n, u, s) : Dn(n, u, s)
                            }
                            return n
                        }
                        function Bi(t, e) {
                            return Li(t, dl(t), e)
                        }
                        function ji(t, e) {
                            return function (n, i) {
                                var o = uf(n) ? r : kn
                                        , a = e ? e() : {};
                                return o(n, t, lo(i, 2), a)
                            }
                        }
                        function Oi(t) {
                            return Zr(function (e, n) {
                                var r = -1
                                        , i = n.length
                                        , o = i > 1 ? n[i - 1] : X
                                        , a = i > 2 ? n[2] : X;
                                for (o = t.length > 3 && "function" == typeof o ? (i--,
                                        o) : X,
                                        a && Ro(n[0], n[1], a) && (o = i < 3 ? X : o,
                                        i = 1),
                                        e = Qc(e); ++r < i; ) {
                                    var u = n[r];
                                    u && t(e, u, r, o)
                                }
                                return e
                            })
                        }
                        function Ei(t, e) {
                            return function (n, r) {
                                if (null == n)
                                    return n;
                                if (!Fu(n))
                                    return t(n, r);
                                for (var i = n.length, o = e ? i : -1, a = Qc(n); (e ? o-- : ++o < i) && r(a[o], o, a) !== !1; )
                                    ;
                                return n
                            }
                        }
                        function Fi(t) {
                            return function (e, n, r) {
                                for (var i = -1, o = Qc(e), a = r(e), u = a.length; u--; ) {
                                    var s = a[t ? u : ++i];
                                    if (n(o[s], s, o) === !1)
                                        break
                                }
                                return e
                            }
                        }
                        function Ti(t, e, n) {
                            function r() {
                                var e = this && this !== Jn && this instanceof r ? o : t;
                                return e.apply(i ? n : this, arguments)
                            }
                            var i = e & ut
                                    , o = Wi(t);
                            return r
                        }
                        function zi(t) {
                            return function (e) {
                                e = ms(e);
                                var n = T(e) ? V(e) : X
                                        , r = n ? n[0] : e.charAt(0)
                                        , i = n ? mi(n, 1).join("") : e.slice(1);
                                return r[t]() + i
                            }
                        }
                        function Ni(t) {
                            return function (e) {
                                return f(vc(Zs(e).replace(Sn, "")), t, "")
                            }
                        }
                        function Wi(t) {
                            return function () {
                                var e = arguments;
                                switch (e.length) {
                                    case 0:
                                        return new t;
                                    case 1:
                                        return new t(e[0]);
                                    case 2:
                                        return new t(e[0], e[1]);
                                    case 3:
                                        return new t(e[0], e[1], e[2]);
                                    case 4:
                                        return new t(e[0], e[1], e[2], e[3]);
                                    case 5:
                                        return new t(e[0], e[1], e[2], e[3], e[4]);
                                    case 6:
                                        return new t(e[0], e[1], e[2], e[3], e[4], e[5]);
                                    case 7:
                                        return new t(e[0], e[1], e[2], e[3], e[4], e[5], e[6])
                                }
                                var n = il(t.prototype)
                                        , r = t.apply(n, e);
                                return Vu(r) ? r : n
                            }
                        }
                        function Ui(t, e, r) {
                            function i() {
                                for (var a = arguments.length, u = $c(a), s = a, c = ho(i); s--; )
                                    u[s] = arguments[s];
                                var h = a < 3 && u[0] !== c && u[a - 1] !== c ? [] : H(u, c);
                                if (a -= h.length,
                                        a < r)
                                    return Xi(t, e, Gi, i.placeholder, X, u, h, X, X, r - a);
                                var l = this && this !== Jn && this instanceof i ? o : t;
                                return n(l, this, u)
                            }
                            var o = Wi(t);
                            return i
                        }
                        function Hi(t) {
                            return function (e, n, r) {
                                var i = Qc(e);
                                if (!Fu(e)) {
                                    var o = lo(n, 3);
                                    e = Ps(e),
                                            n = function (t) {
                                                return o(i[t], t, i)
                                            }
                                }
                                var a = t(e, n, r);
                                return a > -1 ? i[o ? e[a] : a] : X
                            }
                        }
                        function Ji(t) {
                            return ao(function (e) {
                                var n = e.length
                                        , r = n
                                        , i = Z.prototype.thru;
                                for (t && e.reverse(); r--; ) {
                                    var o = e[r];
                                    if ("function" != typeof o)
                                        throw new eh(rt);
                                    if (i && !a && "wrapper" == co(o))
                                        var a = new Z([], (!0))
                                }
                                for (r = a ? r : n; ++r < n; ) {
                                    o = e[r];
                                    var u = co(o)
                                            , s = "wrapper" == u ? gl(o) : X;
                                    a = s && ko(s[0]) && s[1] == (gt | ht | ft | dt) && !s[4].length && 1 == s[9] ? a[co(s[0])].apply(a, s[3]) : 1 == o.length && ko(o) ? a[u]() : a.thru(o)
                                }
                                return function () {
                                    var t = arguments
                                            , r = t[0];
                                    if (a && 1 == t.length && uf(r) && r.length >= et)
                                        return a.plant(r).value();
                                    for (var i = 0, o = n ? e[i].apply(this, t) : r; ++i < n; )
                                        o = e[i].call(this, o);
                                    return o
                                }
                            })
                        }
                        function Gi(t, e, n, r, i, o, a, u, s, c) {
                            function h() {
                                for (var y = arguments.length, m = $c(y), b = y; b--; )
                                    m[b] = arguments[b];
                                if (g)
                                    var _ = ho(h)
                                            , w = O(m, _);
                                if (r && (m = Ai(m, r, i, g)),
                                        o && (m = Mi(m, o, a, g)),
                                        y -= w,
                                        g && y < c) {
                                    var x = H(m, _);
                                    return Xi(t, e, Gi, h.placeholder, n, m, x, u, s, c - y)
                                }
                                var I = f ? n : this
                                        , D = p ? I[t] : t;
                                return y = m.length,
                                        u ? m = zo(m, u) : d && y > 1 && m.reverse(),
                                        l && s < y && (m.length = s),
                                        this && this !== Jn && this instanceof h && (D = v || Wi(D)),
                                        D.apply(I, m)
                            }
                            var l = e & gt
                                    , f = e & ut
                                    , p = e & st
                                    , g = e & (ht | lt)
                                    , d = e & vt
                                    , v = p ? X : Wi(t);
                            return h
                        }
                        function qi(t, e) {
                            return function (n, r) {
                                return br(n, t, e(r), {})
                            }
                        }
                        function $i(t, e) {
                            return function (n, r) {
                                var i;
                                if (n === X && r === X)
                                    return e;
                                if (n !== X && (i = n),
                                        r !== X) {
                                    if (i === X)
                                        return r;
                                    "string" == typeof n || "string" == typeof r ? (n = ui(n),
                                            r = ui(r)) : (n = ai(n),
                                            r = ai(r)),
                                            i = t(n, r)
                                }
                                return i
                            }
                        }
                        function Ki(t) {
                            return ao(function (e) {
                                return e = h(e, M(lo())),
                                        Zr(function (r) {
                                            var i = this;
                                            return t(e, function (t) {
                                                return n(t, i, r)
                                            })
                                        })
                            })
                        }
                        function Vi(t, e) {
                            e = e === X ? " " : ui(e);
                            var n = e.length;
                            if (n < 2)
                                return n ? Vr(e, t) : e;
                            var r = Vr(e, kh(t / K(e)));
                            return T(e) ? mi(V(r), 0, t).join("") : r.slice(0, t)
                        }
                        function Zi(t, e, r, i) {
                            function o() {
                                for (var e = -1, s = arguments.length, c = -1, h = i.length, l = $c(h + s), f = this && this !== Jn && this instanceof o ? u : t; ++c < h; )
                                    l[c] = i[c];
                                for (; s--; )
                                    l[c++] = arguments[++e];
                                return n(f, a ? r : this, l)
                            }
                            var a = e & ut
                                    , u = Wi(t);
                            return o
                        }
                        function Yi(t) {
                            return function (e, n, r) {
                                return r && "number" != typeof r && Ro(e, n, r) && (n = r = X),
                                        e = fs(e),
                                        n === X ? (n = e,
                                                e = 0) : n = fs(n),
                                        r = r === X ? e < n ? 1 : -1 : fs(r),
                                        Kr(e, n, r, t)
                            }
                        }
                        function Qi(t) {
                            return function (e, n) {
                                return "string" == typeof e && "string" == typeof n || (e = ds(e),
                                        n = ds(n)),
                                        t(e, n)
                            }
                        }
                        function Xi(t, e, n, r, i, o, a, u, s, c) {
                            var h = e & ht
                                    , l = h ? a : X
                                    , f = h ? X : a
                                    , p = h ? o : X
                                    , g = h ? X : o;
                            e |= h ? ft : pt,
                                    e &= ~(h ? pt : ft),
                                    e & ct || (e &= ~(ut | st));
                            var d = [t, e, i, p, l, g, f, u, s, c]
                                    , v = n.apply(X, d);
                            return ko(t) && bl(v, d),
                                    v.placeholder = r,
                                    No(v, t, e)
                        }
                        function to(t) {
                            var e = Yc[t];
                            return function (t, n) {
                                if (t = ds(t),
                                        n = Eh(ps(n), 292)) {
                                    var r = (ms(t) + "e").split("e")
                                            , i = e(r[0] + "e" + (+r[1] + n));
                                    return r = (ms(i) + "e").split("e"),
                                            +(r[0] + "e" + (+r[1] - n))
                                }
                                return e(t)
                            }
                        }
                        function eo(t) {
                            return function (e) {
                                var n = yl(e);
                                return n == Wt ? W(e) : n == qt ? G(e) : A(e, t(e))
                            }
                        }
                        function no(t, e, n, r, i, o, a, u) {
                            var s = e & st;
                            if (!s && "function" != typeof t)
                                throw new eh(rt);
                            var c = r ? r.length : 0;
                            if (c || (e &= ~(ft | pt),
                                    r = i = X),
                                    a = a === X ? a : Oh(ps(a), 0),
                                    u = u === X ? u : ps(u),
                                    c -= i ? i.length : 0,
                                    e & pt) {
                                var h = r
                                        , l = i;
                                r = i = X
                            }
                            var f = s ? X : gl(t)
                                    , p = [t, e, n, r, i, h, l, o, a, u];
                            if (f && jo(p, f),
                                    t = p[0],
                                    e = p[1],
                                    n = p[2],
                                    r = p[3],
                                    i = p[4],
                                    u = p[9] = null == p[9] ? s ? 0 : t.length : Oh(p[9] - c, 0),
                                    !u && e & (ht | lt) && (e &= ~(ht | lt)),
                                    e && e != ut)
                                g = e == ht || e == lt ? Ui(t, e, u) : e != ft && e != (ut | ft) || i.length ? Gi.apply(X, p) : Zi(t, e, n, r);
                            else
                                var g = Ti(t, e, n);
                            var d = f ? cl : bl;
                            return No(d(g, p), t, e)
                        }
                        function ro(t, e, n, r, i, o) {
                            var a = i & mt
                                    , u = t.length
                                    , s = e.length;
                            if (u != s && !(a && s > u))
                                return !1;
                            var c = o.get(t);
                            if (c && o.get(e))
                                return c == e;
                            var h = -1
                                    , l = !0
                                    , f = i & yt ? new cn : X;
                            for (o.set(t, e),
                                    o.set(e, t); ++h < u; ) {
                                var p = t[h]
                                        , d = e[h];
                                if (r)
                                    var v = a ? r(d, p, h, e, t, o) : r(p, d, h, t, e, o);
                                if (v !== X) {
                                    if (v)
                                        continue;
                                    l = !1;
                                    break
                                }
                                if (f) {
                                    if (!g(e, function (t, e) {
                                        if (!L(f, e) && (p === t || n(p, t, r, i, o)))
                                            return f.push(e)
                                    })) {
                                        l = !1;
                                        break
                                    }
                                } else if (p !== d && !n(p, d, r, i, o)) {
                                    l = !1;
                                    break
                                }
                            }
                            return o["delete"](t),
                                    o["delete"](e),
                                    l
                        }
                        function io(t, e, n, r, i, o, a) {
                            switch (n) {
                                case Qt:
                                    if (t.byteLength != e.byteLength || t.byteOffset != e.byteOffset)
                                        return !1;
                                    t = t.buffer,
                                            e = e.buffer;
                                case Yt:
                                    return !(t.byteLength != e.byteLength || !r(new vh(t), new vh(e)));
                                case Et:
                                case Ft:
                                case Ut:
                                    return Ou(+t, +e);
                                case Tt:
                                    return t.name == e.name && t.message == e.message;
                                case Gt:
                                case $t:
                                    return t == e + "";
                                case Wt:
                                    var u = W;
                                case qt:
                                    var s = o & mt;
                                    if (u || (u = J),
                                            t.size != e.size && !s)
                                        return !1;
                                    var c = a.get(t);
                                    if (c)
                                        return c == e;
                                    o |= yt,
                                            a.set(t, e);
                                    var h = ro(u(t), u(e), r, i, o, a);
                                    return a["delete"](t),
                                            h;
                                case Kt:
                                    if (nl)
                                        return nl.call(t) == nl.call(e)
                            }
                            return !1
                        }
                        function oo(t, e, n, r, i, o) {
                            var a = i & mt
                                    , u = Ps(t)
                                    , s = u.length
                                    , c = Ps(e)
                                    , h = c.length;
                            if (s != h && !a)
                                return !1;
                            for (var l = s; l--; ) {
                                var f = u[l];
                                if (!(a ? f in e : sh.call(e, f)))
                                    return !1
                            }
                            var p = o.get(t);
                            if (p && o.get(e))
                                return p == e;
                            var g = !0;
                            o.set(t, e),
                                    o.set(e, t);
                            for (var d = a; ++l < s; ) {
                                f = u[l];
                                var v = t[f]
                                        , y = e[f];
                                if (r)
                                    var m = a ? r(y, v, f, e, t, o) : r(v, y, f, t, e, o);
                                if (!(m === X ? v === y || n(v, y, r, i, o) : m)) {
                                    g = !1;
                                    break
                                }
                                d || (d = "constructor" == f)
                            }
                            if (g && !d) {
                                var b = t.constructor
                                        , _ = e.constructor;
                                b != _ && "constructor"in t && "constructor"in e && !("function" == typeof b && b instanceof b && "function" == typeof _ && _ instanceof _) && (g = !1)
                            }
                            return o["delete"](t),
                                    o["delete"](e),
                                    g
                        }
                        function ao(t) {
                            return wl(Fo(t, X, ra), t + "")
                        }
                        function uo(t) {
                            return fr(t, Ps, dl)
                        }
                        function so(t) {
                            return fr(t, Ls, vl)
                        }
                        function co(t) {
                            for (var e = t.name + "", n = Vh[e], r = sh.call(Vh, e) ? n.length : 0; r--; ) {
                                var i = n[r]
                                        , o = i.func;
                                if (null == o || o == t)
                                    return i.name
                            }
                            return e
                        }
                        function ho(t) {
                            var e = sh.call(D, "placeholder") ? D : t;
                            return e.placeholder
                        }
                        function lo() {
                            var t = D.iteratee || xc;
                            return t = t === xc ? Pr : t,
                                    arguments.length ? t(arguments[0], arguments[1]) : t
                        }
                        function fo(t, e) {
                            var n = t.__data__;
                            return Co(e) ? n["string" == typeof e ? "string" : "hash"] : n.map
                        }
                        function po(t) {
                            for (var e = Ps(t), n = e.length; n--; ) {
                                var r = e[n]
                                        , i = t[r];
                                e[n] = [r, i, Po(i)]
                            }
                            return e
                        }
                        function go(t, e) {
                            var n = F(t, e);
                            return Cr(n) ? n : X
                        }
                        function vo(t, e, n) {
                            for (var r = -1, i = n.length; ++r < i; ) {
                                var o = n[r]
                                        , a = o.size;
                                switch (o.type) {
                                    case "drop":
                                        t += a;
                                        break;
                                    case "dropRight":
                                        e -= a;
                                        break;
                                    case "take":
                                        e = Eh(e, t + a);
                                        break;
                                    case "takeRight":
                                        t = Oh(t, e - a)
                                }
                            }
                            return {
                                start: t,
                                end: e
                            }
                        }
                        function yo(t) {
                            var e = t.match(ke);
                            return e ? e[1].split(Ae) : []
                        }
                        function mo(t, e, n) {
                            e = So(e, t) ? [e] : yi(e);
                            for (var r = -1, i = e.length, o = !1; ++r < i; ) {
                                var a = Ho(e[r]);
                                if (!(o = null != t && n(t, a)))
                                    break;
                                t = t[a]
                            }
                            return o || ++r != i ? o : (i = t ? t.length : 0,
                                    !!i && Ku(i) && Do(a, i) && (uf(t) || Eu(t)))
                        }
                        function bo(t) {
                            var e = t.length
                                    , n = t.constructor(e);
                            return e && "string" == typeof t[0] && sh.call(t, "index") && (n.index = t.index,
                                    n.input = t.input),
                                    n
                        }
                        function _o(t) {
                            return "function" != typeof t.constructor || Mo(t) ? {} : il(bh(t))
                        }
                        function wo(t, e, n, r) {
                            var i = t.constructor;
                            switch (e) {
                                case Yt:
                                    return _i(t);
                                case Et:
                                case Ft:
                                    return new i((+t));
                                case Qt:
                                    return wi(t, r);
                                case Xt:
                                case te:
                                case ee:
                                case ne:
                                case re:
                                case ie:
                                case oe:
                                case ae:
                                case ue:
                                    return Si(t, r);
                                case Wt:
                                    return xi(t, r, n);
                                case Ut:
                                case $t:
                                    return new i(t);
                                case Gt:
                                    return Ii(t);
                                case qt:
                                    return Di(t, r, n);
                                case Kt:
                                    return Ri(t)
                            }
                        }
                        function xo(t, e) {
                            var n = e.length;
                            if (!n)
                                return t;
                            var r = n - 1;
                            return e[r] = (n > 1 ? "& " : "") + e[r],
                                    e = e.join(n > 2 ? ", " : " "),
                                    t.replace(Ce, "{\n/* [wrapped with " + e + "] */\n")
                        }
                        function Io(t) {
                            return uf(t) || Eu(t) || !!(Dh && t && t[Dh])
                        }
                        function Do(t, e) {
                            return e = null == e ? Ct : e,
                                    !!e && ("number" == typeof t || Te.test(t)) && t > -1 && t % 1 == 0 && t < e
                        }
                        function Ro(t, e, n) {
                            if (!Vu(n))
                                return !1;
                            var r = typeof e;
                            return !!("number" == r ? Fu(n) && Do(e, n.length) : "string" == r && e in n) && Ou(n[e], t)
                        }
                        function So(t, e) {
                            if (uf(t))
                                return !1;
                            var n = typeof t;
                            return !("number" != n && "symbol" != n && "boolean" != n && null != t && !us(t)) || (be.test(t) || !me.test(t) || null != e && t in Qc(e))
                        }
                        function Co(t) {
                            var e = typeof t;
                            return "string" == e || "number" == e || "symbol" == e || "boolean" == e ? "__proto__" !== t : null === t
                        }
                        function ko(t) {
                            var e = co(t)
                                    , n = D[e];
                            if ("function" != typeof n || !(e in Y.prototype))
                                return !1;
                            if (t === n)
                                return !0;
                            var r = gl(n);
                            return !!r && t === r[0]
                        }
                        function Ao(t) {
                            return !!ah && ah in t
                        }
                        function Mo(t) {
                            var e = t && t.constructor
                                    , n = "function" == typeof e && e.prototype || ih;
                            return t === n
                        }
                        function Po(t) {
                            return t === t && !Vu(t)
                        }
                        function Lo(t, e) {
                            return function (n) {
                                return null != n && (n[t] === e && (e !== X || t in Qc(n)))
                            }
                        }
                        function Bo(t) {
                            var e = wu(t, function (t) {
                                return n.size === ot && n.clear(),
                                        t
                            })
                                    , n = e.cache;
                            return e
                        }
                        function jo(t, e) {
                            var n = t[1]
                                    , r = e[1]
                                    , i = n | r
                                    , o = i < (ut | st | gt)
                                    , a = r == gt && n == ht || r == gt && n == dt && t[7].length <= e[8] || r == (gt | dt) && e[7].length <= e[8] && n == ht;
                            if (!o && !a)
                                return t;
                            r & ut && (t[2] = e[2],
                                    i |= n & ut ? 0 : ct);
                            var u = e[3];
                            if (u) {
                                var s = t[3];
                                t[3] = s ? Ai(s, u, e[4]) : u,
                                        t[4] = s ? H(t[3], at) : e[4]
                            }
                            return u = e[5],
                                    u && (s = t[5],
                                            t[5] = s ? Mi(s, u, e[6]) : u,
                                            t[6] = s ? H(t[5], at) : e[6]),
                                    u = e[7],
                                    u && (t[7] = u),
                                    r & gt && (t[8] = null == t[8] ? e[8] : Eh(t[8], e[8])),
                                    null == t[9] && (t[9] = e[9]),
                                    t[0] = e[0],
                                    t[1] = i,
                                    t
                        }
                        function Oo(t, e, n, r, i, o) {
                            return Vu(t) && Vu(e) && (o.set(e, t),
                                    Tr(t, e, X, Oo, o),
                                    o["delete"](e)),
                                    t
                        }
                        function Eo(t) {
                            var e = [];
                            if (null != t)
                                for (var n in Qc(t))
                                    e.push(n);
                            return e
                        }
                        function Fo(t, e, r) {
                            return e = Oh(e === X ? t.length - 1 : e, 0),
                                    function () {
                                        for (var i = arguments, o = -1, a = Oh(i.length - e, 0), u = $c(a); ++o < a; )
                                            u[o] = i[e + o];
                                        o = -1;
                                        for (var s = $c(e + 1); ++o < e; )
                                            s[o] = i[o];
                                        return s[e] = r(u),
                                                n(t, this, s)
                                    }
                        }
                        function To(t, e) {
                            return 1 == e.length ? t : lr(t, ei(e, 0, -1))
                        }
                        function zo(t, e) {
                            for (var n = t.length, r = Eh(e.length, n), i = Pi(t); r--; ) {
                                var o = e[r];
                                t[r] = Do(o, n) ? i[o] : X
                            }
                            return t
                        }
                        function No(t, e, n) {
                            var r = e + "";
                            return wl(t, xo(r, Go(yo(r), n)))
                        }
                        function Wo(t) {
                            var e = 0
                                    , n = 0;
                            return function () {
                                var r = Fh()
                                        , i = xt - (r - n);
                                if (n = r,
                                        i > 0) {
                                    if (++e >= wt)
                                        return arguments[0]
                                } else
                                    e = 0;
                                return t.apply(X, arguments)
                            }
                        }
                        function Uo(t, e) {
                            var n = -1
                                    , r = t.length
                                    , i = r - 1;
                            for (e = e === X ? r : En(e, 0, r); ++n < e; ) {
                                var o = $r(n, i)
                                        , a = t[o];
                                t[o] = t[n],
                                        t[n] = a
                            }
                            return t.length = e,
                                    t
                        }
                        function Ho(t) {
                            if ("string" == typeof t || us(t))
                                return t;
                            var e = t + "";
                            return "0" == e && 1 / t == -St ? "-0" : e
                        }
                        function Jo(t) {
                            if (null != t) {
                                try {
                                    return uh.call(t)
                                } catch (e) {
                                }
                                try {
                                    return t + ""
                                } catch (e) {
                                }
                            }
                            return ""
                        }
                        function Go(t, e) {
                            return i(Bt, function (n) {
                                var r = "_." + n[0];
                                e & n[1] && !s(t, r) && t.push(r)
                            }),
                                    t.sort()
                        }
                        function qo(t) {
                            if (t instanceof Y)
                                return t.clone();
                            var e = new Z(t.__wrapped__, t.__chain__);
                            return e.__actions__ = Pi(t.__actions__),
                                    e.__index__ = t.__index__,
                                    e.__values__ = t.__values__,
                                    e
                        }
                        function $o(t, e, n) {
                            e = (n ? Ro(t, e, n) : e === X) ? 1 : Oh(ps(e), 0);
                            var r = t ? t.length : 0;
                            if (!r || e < 1)
                                return [];
                            for (var i = 0, o = 0, a = $c(kh(r / e)); i < r; )
                                a[o++] = ei(t, i, i += e);
                            return a
                        }
                        function Ko(t) {
                            for (var e = -1, n = t ? t.length : 0, r = 0, i = []; ++e < n; ) {
                                var o = t[e];
                                o && (i[r++] = o)
                            }
                            return i
                        }
                        function Vo() {
                            var t = arguments.length;
                            if (!t)
                                return [];
                            for (var e = $c(t - 1), n = arguments[0], r = t; r--; )
                                e[r - 1] = arguments[r];
                            return l(uf(n) ? Pi(n) : [n], nr(e, 1))
                        }
                        function Zo(t, e, n) {
                            var r = t ? t.length : 0;
                            return r ? (e = n || e === X ? 1 : ps(e),
                                    ei(t, e < 0 ? 0 : e, r)) : []
                        }
                        function Yo(t, e, n) {
                            var r = t ? t.length : 0;
                            return r ? (e = n || e === X ? 1 : ps(e),
                                    e = r - e,
                                    ei(t, 0, e < 0 ? 0 : e)) : []
                        }
                        function Qo(t, e) {
                            return t && t.length ? li(t, lo(e, 3), !0, !0) : []
                        }
                        function Xo(t, e) {
                            return t && t.length ? li(t, lo(e, 3), !0) : []
                        }
                        function ta(t, e, n, r) {
                            var i = t ? t.length : 0;
                            return i ? (n && "number" != typeof n && Ro(t, e, n) && (n = 0,
                                    r = i),
                                    Kn(t, e, n, r)) : []
                        }
                        function ea(t, e, n) {
                            var r = t ? t.length : 0;
                            if (!r)
                                return -1;
                            var i = null == n ? 0 : ps(n);
                            return i < 0 && (i = Oh(r + i, 0)),
                                    m(t, lo(e, 3), i)
                        }
                        function na(t, e, n) {
                            var r = t ? t.length : 0;
                            if (!r)
                                return -1;
                            var i = r - 1;
                            return n !== X && (i = ps(n),
                                    i = n < 0 ? Oh(r + i, 0) : Eh(i, r - 1)),
                                    m(t, lo(e, 3), i, !0)
                        }
                        function ra(t) {
                            var e = t ? t.length : 0;
                            return e ? nr(t, 1) : []
                        }
                        function ia(t) {
                            var e = t ? t.length : 0;
                            return e ? nr(t, St) : []
                        }
                        function oa(t, e) {
                            var n = t ? t.length : 0;
                            return n ? (e = e === X ? 1 : ps(e),
                                    nr(t, e)) : []
                        }
                        function aa(t) {
                            for (var e = -1, n = t ? t.length : 0, r = {}; ++e < n; ) {
                                var i = t[e];
                                r[i[0]] = i[1]
                            }
                            return r
                        }
                        function ua(t) {
                            return t && t.length ? t[0] : X
                        }
                        function sa(t, e, n) {
                            var r = t ? t.length : 0;
                            if (!r)
                                return -1;
                            var i = null == n ? 0 : ps(n);
                            return i < 0 && (i = Oh(r + i, 0)),
                                    b(t, e, i)
                        }
                        function ca(t) {
                            var e = t ? t.length : 0;
                            return e ? ei(t, 0, -1) : []
                        }
                        function ha(t, e) {
                            return t ? Bh.call(t, e) : ""
                        }
                        function la(t) {
                            var e = t ? t.length : 0;
                            return e ? t[e - 1] : X
                        }
                        function fa(t, e, n) {
                            var r = t ? t.length : 0;
                            if (!r)
                                return -1;
                            var i = r;
                            return n !== X && (i = ps(n),
                                    i = i < 0 ? Oh(r + i, 0) : Eh(i, r - 1)),
                                    e === e ? $(t, e, i) : m(t, w, i, !0)
                        }
                        function pa(t, e) {
                            return t && t.length ? Nr(t, ps(e)) : X
                        }
                        function ga(t, e) {
                            return t && t.length && e && e.length ? Gr(t, e) : t
                        }
                        function da(t, e, n) {
                            return t && t.length && e && e.length ? Gr(t, e, lo(n, 2)) : t
                        }
                        function va(t, e, n) {
                            return t && t.length && e && e.length ? Gr(t, e, X, n) : t
                        }
                        function ya(t, e) {
                            var n = [];
                            if (!t || !t.length)
                                return n;
                            var r = -1
                                    , i = []
                                    , o = t.length;
                            for (e = lo(e, 3); ++r < o; ) {
                                var a = t[r];
                                e(a, r, t) && (n.push(a),
                                        i.push(r))
                            }
                            return qr(t, i),
                                    n
                        }
                        function ma(t) {
                            return t ? Nh.call(t) : t
                        }
                        function ba(t, e, n) {
                            var r = t ? t.length : 0;
                            return r ? (n && "number" != typeof n && Ro(t, e, n) ? (e = 0,
                                    n = r) : (e = null == e ? 0 : ps(e),
                                    n = n === X ? r : ps(n)),
                                    ei(t, e, n)) : []
                        }
                        function _a(t, e) {
                            return ri(t, e)
                        }
                        function wa(t, e, n) {
                            return ii(t, e, lo(n, 2))
                        }
                        function xa(t, e) {
                            var n = t ? t.length : 0;
                            if (n) {
                                var r = ri(t, e);
                                if (r < n && Ou(t[r], e))
                                    return r
                            }
                            return -1
                        }
                        function Ia(t, e) {
                            return ri(t, e, !0)
                        }
                        function Da(t, e, n) {
                            return ii(t, e, lo(n, 2), !0)
                        }
                        function Ra(t, e) {
                            var n = t ? t.length : 0;
                            if (n) {
                                var r = ri(t, e, !0) - 1;
                                if (Ou(t[r], e))
                                    return r
                            }
                            return -1
                        }
                        function Sa(t) {
                            return t && t.length ? oi(t) : []
                        }
                        function Ca(t, e) {
                            return t && t.length ? oi(t, lo(e, 2)) : []
                        }
                        function ka(t) {
                            var e = t ? t.length : 0;
                            return e ? ei(t, 1, e) : []
                        }
                        function Aa(t, e, n) {
                            return t && t.length ? (e = n || e === X ? 1 : ps(e),
                                    ei(t, 0, e < 0 ? 0 : e)) : []
                        }
                        function Ma(t, e, n) {
                            var r = t ? t.length : 0;
                            return r ? (e = n || e === X ? 1 : ps(e),
                                    e = r - e,
                                    ei(t, e < 0 ? 0 : e, r)) : []
                        }
                        function Pa(t, e) {
                            return t && t.length ? li(t, lo(e, 3), !1, !0) : []
                        }
                        function La(t, e) {
                            return t && t.length ? li(t, lo(e, 3)) : []
                        }
                        function Ba(t) {
                            return t && t.length ? si(t) : []
                        }
                        function ja(t, e) {
                            return t && t.length ? si(t, lo(e, 2)) : []
                        }
                        function Oa(t, e) {
                            return t && t.length ? si(t, X, e) : []
                        }
                        function Ea(t) {
                            if (!t || !t.length)
                                return [];
                            var e = 0;
                            return t = u(t, function (t) {
                                if (Tu(t))
                                    return e = Oh(t.length, e),
                                            !0
                            }),
                                    k(e, function (e) {
                                        return h(t, I(e))
                                    })
                        }
                        function Fa(t, e) {
                            if (!t || !t.length)
                                return [];
                            var r = Ea(t);
                            return null == e ? r : h(r, function (t) {
                                return n(e, X, t)
                            })
                        }
                        function Ta(t, e) {
                            return gi(t || [], e || [], Dn)
                        }
                        function za(t, e) {
                            return gi(t || [], e || [], Xr)
                        }
                        function Na(t) {
                            var e = D(t);
                            return e.__chain__ = !0,
                                    e
                        }
                        function Wa(t, e) {
                            return e(t),
                                    t
                        }
                        function Ua(t, e) {
                            return e(t)
                        }
                        function Ha() {
                            return Na(this)
                        }
                        function Ja() {
                            return new Z(this.value(), this.__chain__)
                        }
                        function Ga() {
                            this.__values__ === X && (this.__values__ = ls(this.value()));
                            var t = this.__index__ >= this.__values__.length
                                    , e = t ? X : this.__values__[this.__index__++];
                            return {
                                done: t,
                                value: e
                            }
                        }
                        function qa() {
                            return this
                        }
                        function $a(t) {
                            for (var e, n = this; n instanceof q; ) {
                                var r = qo(n);
                                r.__index__ = 0,
                                        r.__values__ = X,
                                        e ? i.__wrapped__ = r : e = r;
                                var i = r;
                                n = n.__wrapped__
                            }
                            return i.__wrapped__ = t,
                                    e
                        }
                        function Ka() {
                            var t = this.__wrapped__;
                            if (t instanceof Y) {
                                var e = t;
                                return this.__actions__.length && (e = new Y(this)),
                                        e = e.reverse(),
                                        e.__actions__.push({
                                            func: Ua,
                                            args: [ma],
                                            thisArg: X
                                        }),
                                        new Z(e, this.__chain__)
                            }
                            return this.thru(ma)
                        }
                        function Va() {
                            return fi(this.__wrapped__, this.__actions__)
                        }
                        function Za(t, e, n) {
                            var r = uf(t) ? a : Gn;
                            return n && Ro(t, e, n) && (e = X),
                                    r(t, lo(e, 3))
                        }
                        function Ya(t, e) {
                            var n = uf(t) ? u : Vn;
                            return n(t, lo(e, 3))
                        }
                        function Qa(t, e) {
                            return nr(iu(t, e), 1)
                        }
                        function Xa(t, e) {
                            return nr(iu(t, e), St)
                        }
                        function tu(t, e, n) {
                            return n = n === X ? 1 : ps(n),
                                    nr(iu(t, e), n)
                        }
                        function eu(t, e) {
                            var n = uf(t) ? i : ol;
                            return n(t, lo(e, 3))
                        }
                        function nu(t, e) {
                            var n = uf(t) ? o : al;
                            return n(t, lo(e, 3))
                        }
                        function ru(t, e, n, r) {
                            t = Fu(t) ? t : Js(t),
                                    n = n && !r ? ps(n) : 0;
                            var i = t.length;
                            return n < 0 && (n = Oh(i + n, 0)),
                                    as(t) ? n <= i && t.indexOf(e, n) > -1 : !!i && b(t, e, n) > -1
                        }
                        function iu(t, e) {
                            var n = uf(t) ? h : Or;
                            return n(t, lo(e, 3))
                        }
                        function ou(t, e, n, r) {
                            return null == t ? [] : (uf(e) || (e = null == e ? [] : [e]),
                                    n = r ? X : n,
                                    uf(n) || (n = null == n ? [] : [n]),
                                    Wr(t, e, n))
                        }
                        function au(t, e, n) {
                            var r = uf(t) ? f : R
                                    , i = arguments.length < 3;
                            return r(t, lo(e, 4), n, i, ol)
                        }
                        function uu(t, e, n) {
                            var r = uf(t) ? p : R
                                    , i = arguments.length < 3;
                            return r(t, lo(e, 4), n, i, al)
                        }
                        function su(t, e) {
                            var n = uf(t) ? u : Vn;
                            return n(t, xu(lo(e, 3)))
                        }
                        function cu(t) {
                            var e = uf(t) ? bn : Yr;
                            return e(t)
                        }
                        function hu(t, e, n) {
                            e = (n ? Ro(t, e, n) : e === X) ? 1 : ps(e);
                            var r = uf(t) ? _n : Qr;
                            return r(t, e)
                        }
                        function lu(t) {
                            var e = uf(t) ? wn : ti;
                            return e(t)
                        }
                        function fu(t) {
                            if (null == t)
                                return 0;
                            if (Fu(t))
                                return as(t) ? K(t) : t.length;
                            var e = yl(t);
                            return e == Wt || e == qt ? t.size : Lr(t).length
                        }
                        function pu(t, e, n) {
                            var r = uf(t) ? g : ni;
                            return n && Ro(t, e, n) && (e = X),
                                    r(t, lo(e, 3))
                        }
                        function gu(t, e) {
                            if ("function" != typeof e)
                                throw new eh(rt);
                            return t = ps(t),
                                    function () {
                                        if (--t < 1)
                                            return e.apply(this, arguments)
                                    }
                        }
                        function du(t, e, n) {
                            return e = n ? X : e,
                                    e = t && null == e ? t.length : e,
                                    no(t, gt, X, X, X, X, e)
                        }
                        function vu(t, e) {
                            var n;
                            if ("function" != typeof e)
                                throw new eh(rt);
                            return t = ps(t),
                                    function () {
                                        return --t > 0 && (n = e.apply(this, arguments)),
                                                t <= 1 && (e = X),
                                                n
                                    }
                        }
                        function yu(t, e, n) {
                            e = n ? X : e;
                            var r = no(t, ht, X, X, X, X, X, e);
                            return r.placeholder = yu.placeholder,
                                    r
                        }
                        function mu(t, e, n) {
                            e = n ? X : e;
                            var r = no(t, lt, X, X, X, X, X, e);
                            return r.placeholder = mu.placeholder,
                                    r
                        }
                        function bu(t, e, n) {
                            function r(e) {
                                var n = f
                                        , r = p;
                                return f = p = X,
                                        m = e,
                                        d = t.apply(r, n)
                            }
                            function i(t) {
                                return m = t,
                                        v = _l(u, e),
                                        b ? r(t) : d
                            }
                            function o(t) {
                                var n = t - y
                                        , r = t - m
                                        , i = e - n;
                                return _ ? Eh(i, g - r) : i
                            }
                            function a(t) {
                                var n = t - y
                                        , r = t - m;
                                return y === X || n >= e || n < 0 || _ && r >= g
                            }
                            function u() {
                                var t = Vl();
                                return a(t) ? s(t) : void (v = _l(u, o(t)))
                            }
                            function s(t) {
                                return v = X,
                                        w && f ? r(t) : (f = p = X,
                                        d)
                            }
                            function c() {
                                v !== X && fl(v),
                                        m = 0,
                                        f = y = p = v = X
                            }
                            function h() {
                                return v === X ? d : s(Vl())
                            }
                            function l() {
                                var t = Vl()
                                        , n = a(t);
                                if (f = arguments,
                                        p = this,
                                        y = t,
                                        n) {
                                    if (v === X)
                                        return i(y);
                                    if (_)
                                        return v = _l(u, e),
                                                r(y)
                                }
                                return v === X && (v = _l(u, e)),
                                        d
                            }
                            var f, p, g, d, v, y, m = 0, b = !1, _ = !1, w = !0;
                            if ("function" != typeof t)
                                throw new eh(rt);
                            return e = ds(e) || 0,
                                    Vu(n) && (b = !!n.leading,
                                    _ = "maxWait"in n,
                                    g = _ ? Oh(ds(n.maxWait) || 0, e) : g,
                                    w = "trailing"in n ? !!n.trailing : w),
                                    l.cancel = c,
                                    l.flush = h,
                                    l
                        }
                        function _u(t) {
                            return no(t, vt)
                        }
                        function wu(t, e) {
                            if ("function" != typeof t || e && "function" != typeof e)
                                throw new eh(rt);
                            var n = function () {
                                var r = arguments
                                        , i = e ? e.apply(this, r) : r[0]
                                        , o = n.cache;
                                if (o.has(i))
                                    return o.get(i);
                                var a = t.apply(this, r);
                                return n.cache = o.set(i, a) || o,
                                        a
                            };
                            return n.cache = new (wu.Cache || nn),
                                    n
                        }
                        function xu(t) {
                            if ("function" != typeof t)
                                throw new eh(rt);
                            return function () {
                                var e = arguments;
                                switch (e.length) {
                                    case 0:
                                        return !t.call(this);
                                    case 1:
                                        return !t.call(this, e[0]);
                                    case 2:
                                        return !t.call(this, e[0], e[1]);
                                    case 3:
                                        return !t.call(this, e[0], e[1], e[2])
                                }
                                return !t.apply(this, e)
                            }
                        }
                        function Iu(t) {
                            return vu(2, t)
                        }
                        function Du(t, e) {
                            if ("function" != typeof t)
                                throw new eh(rt);
                            return e = e === X ? e : ps(e),
                                    Zr(t, e)
                        }
                        function Ru(t, e) {
                            if ("function" != typeof t)
                                throw new eh(rt);
                            return e = e === X ? 0 : Oh(ps(e), 0),
                                    Zr(function (r) {
                                        var i = r[e]
                                                , o = mi(r, 0, e);
                                        return i && l(o, i),
                                                n(t, this, o)
                                    })
                        }
                        function Su(t, e, n) {
                            var r = !0
                                    , i = !0;
                            if ("function" != typeof t)
                                throw new eh(rt);
                            return Vu(n) && (r = "leading"in n ? !!n.leading : r,
                                    i = "trailing"in n ? !!n.trailing : i),
                                    bu(t, e, {
                                        leading: r,
                                        maxWait: e,
                                        trailing: i
                                    })
                        }
                        function Cu(t) {
                            return du(t, 1)
                        }
                        function ku(t, e) {
                            return e = null == e ? wc : e,
                                    ef(e, t)
                        }
                        function Au() {
                            if (!arguments.length)
                                return [];
                            var t = arguments[0];
                            return uf(t) ? t : [t]
                        }
                        function Mu(t) {
                            return Fn(t, !1, !0)
                        }
                        function Pu(t, e) {
                            return Fn(t, !1, !0, e)
                        }
                        function Lu(t) {
                            return Fn(t, !0, !0)
                        }
                        function Bu(t, e) {
                            return Fn(t, !0, !0, e)
                        }
                        function ju(t, e) {
                            return null == e || zn(t, e, Ps(e))
                        }
                        function Ou(t, e) {
                            return t === e || t !== t && e !== e
                        }
                        function Eu(t) {
                            return Tu(t) && sh.call(t, "callee") && (!xh.call(t, "callee") || lh.call(t) == jt)
                        }
                        function Fu(t) {
                            return null != t && Ku(t.length) && !qu(t)
                        }
                        function Tu(t) {
                            return Zu(t) && Fu(t)
                        }
                        function zu(t) {
                            return t === !0 || t === !1 || Zu(t) && lh.call(t) == Et
                        }
                        function Nu(t) {
                            return null != t && 1 === t.nodeType && Zu(t) && !is(t)
                        }
                        function Wu(t) {
                            if (Fu(t) && (uf(t) || "string" == typeof t || "function" == typeof t.splice || cf(t) || Eu(t)))
                                return !t.length;
                            var e = yl(t);
                            if (e == Wt || e == qt)
                                return !t.size;
                            if (Mo(t))
                                return !jh(t).length;
                            for (var n in t)
                                if (sh.call(t, n))
                                    return !1;
                            return !0
                        }
                        function Uu(t, e) {
                            return Ir(t, e)
                        }
                        function Hu(t, e, n) {
                            n = "function" == typeof n ? n : X;
                            var r = n ? n(t, e) : X;
                            return r === X ? Ir(t, e, n) : !!r
                        }
                        function Ju(t) {
                            return !!Zu(t) && (lh.call(t) == Tt || "string" == typeof t.message && "string" == typeof t.name)
                        }
                        function Gu(t) {
                            return "number" == typeof t && Lh(t)
                        }
                        function qu(t) {
                            var e = Vu(t) ? lh.call(t) : "";
                            return e == zt || e == Nt
                        }
                        function $u(t) {
                            return "number" == typeof t && t == ps(t)
                        }
                        function Ku(t) {
                            return "number" == typeof t && t > -1 && t % 1 == 0 && t <= Ct
                        }
                        function Vu(t) {
                            var e = typeof t;
                            return null != t && ("object" == e || "function" == e)
                        }
                        function Zu(t) {
                            return null != t && "object" == typeof t
                        }
                        function Yu(t, e) {
                            return t === e || Sr(t, e, po(e))
                        }
                        function Qu(t, e, n) {
                            return n = "function" == typeof n ? n : X,
                                    Sr(t, e, po(e), n)
                        }
                        function Xu(t) {
                            return rs(t) && t != +t
                        }
                        function ts(t) {
                            if (ml(t))
                                throw new Vc(nt);
                            return Cr(t)
                        }
                        function es(t) {
                            return null === t
                        }
                        function ns(t) {
                            return null == t
                        }
                        function rs(t) {
                            return "number" == typeof t || Zu(t) && lh.call(t) == Ut
                        }
                        function is(t) {
                            if (!Zu(t) || lh.call(t) != Ht)
                                return !1;
                            var e = bh(t);
                            if (null === e)
                                return !0;
                            var n = sh.call(e, "constructor") && e.constructor;
                            return "function" == typeof n && n instanceof n && uh.call(n) == hh
                        }
                        function os(t) {
                            return $u(t) && t >= -Ct && t <= Ct
                        }
                        function as(t) {
                            return "string" == typeof t || !uf(t) && Zu(t) && lh.call(t) == $t
                        }
                        function us(t) {
                            return "symbol" == typeof t || Zu(t) && lh.call(t) == Kt
                        }
                        function ss(t) {
                            return t === X
                        }
                        function cs(t) {
                            return Zu(t) && yl(t) == Vt
                        }
                        function hs(t) {
                            return Zu(t) && lh.call(t) == Zt
                        }
                        function ls(t) {
                            if (!t)
                                return [];
                            if (Fu(t))
                                return as(t) ? V(t) : Pi(t);
                            if (_h && t[_h])
                                return N(t[_h]());
                            var e = yl(t)
                                    , n = e == Wt ? W : e == qt ? J : Js;
                            return n(t)
                        }
                        function fs(t) {
                            if (!t)
                                return 0 === t ? t : 0;
                            if (t = ds(t),
                                    t === St || t === -St) {
                                var e = t < 0 ? -1 : 1;
                                return e * kt
                            }
                            return t === t ? t : 0
                        }
                        function ps(t) {
                            var e = fs(t)
                                    , n = e % 1;
                            return e === e ? n ? e - n : e : 0
                        }
                        function gs(t) {
                            return t ? En(ps(t), 0, Mt) : 0
                        }
                        function ds(t) {
                            if ("number" == typeof t)
                                return t;
                            if (us(t))
                                return At;
                            if (Vu(t)) {
                                var e = "function" == typeof t.valueOf ? t.valueOf() : t;
                                t = Vu(e) ? e + "" : e
                            }
                            if ("string" != typeof t)
                                return 0 === t ? t : +t;
                            t = t.replace(De, "");
                            var n = Oe.test(t);
                            return n || Fe.test(t) ? Wn(t.slice(2), n ? 2 : 8) : je.test(t) ? At : +t
                        }
                        function vs(t) {
                            return Li(t, Ls(t))
                        }
                        function ys(t) {
                            return En(ps(t), -Ct, Ct)
                        }
                        function ms(t) {
                            return null == t ? "" : ui(t)
                        }
                        function bs(t, e) {
                            var n = il(t);
                            return e ? An(n, e) : n
                        }
                        function _s(t, e) {
                            return y(t, lo(e, 3), ar)
                        }
                        function ws(t, e) {
                            return y(t, lo(e, 3), cr)
                        }
                        function xs(t, e) {
                            return null == t ? t : ul(t, lo(e, 3), Ls)
                        }
                        function Is(t, e) {
                            return null == t ? t : sl(t, lo(e, 3), Ls)
                        }
                        function Ds(t, e) {
                            return t && ar(t, lo(e, 3))
                        }
                        function Rs(t, e) {
                            return t && cr(t, lo(e, 3))
                        }
                        function Ss(t) {
                            return null == t ? [] : hr(t, Ps(t))
                        }
                        function Cs(t) {
                            return null == t ? [] : hr(t, Ls(t))
                        }
                        function ks(t, e, n) {
                            var r = null == t ? X : lr(t, e);
                            return r === X ? n : r
                        }
                        function As(t, e) {
                            return null != t && mo(t, e, dr)
                        }
                        function Ms(t, e) {
                            return null != t && mo(t, e, vr)
                        }
                        function Ps(t) {
                            return Fu(t) ? mn(t) : Lr(t)
                        }
                        function Ls(t) {
                            return Fu(t) ? mn(t, !0) : Br(t)
                        }
                        function Bs(t, e) {
                            var n = {};
                            return e = lo(e, 3),
                                    ar(t, function (t, r, i) {
                                        Mn(n, e(t, r, i), t)
                                    }),
                                    n
                        }
                        function js(t, e) {
                            var n = {};
                            return e = lo(e, 3),
                                    ar(t, function (t, r, i) {
                                        Mn(n, r, e(t, r, i))
                                    }),
                                    n
                        }
                        function Os(t, e) {
                            return Es(t, xu(lo(e)))
                        }
                        function Es(t, e) {
                            return null == t ? {} : Hr(t, so(t), lo(e))
                        }
                        function Fs(t, e, n) {
                            e = So(e, t) ? [e] : yi(e);
                            var r = -1
                                    , i = e.length;
                            for (i || (t = X,
                                    i = 1); ++r < i; ) {
                                var o = null == t ? X : t[Ho(e[r])];
                                o === X && (r = i,
                                        o = n),
                                        t = qu(o) ? o.call(t) : o
                            }
                            return t
                        }
                        function Ts(t, e, n) {
                            return null == t ? t : Xr(t, e, n)
                        }
                        function zs(t, e, n, r) {
                            return r = "function" == typeof r ? r : X,
                                    null == t ? t : Xr(t, e, n, r)
                        }
                        function Ns(t, e, n) {
                            var r = uf(t) || gf(t);
                            if (e = lo(e, 4),
                                    null == n)
                                if (r || Vu(t)) {
                                    var o = t.constructor;
                                    n = r ? uf(t) ? new o : [] : qu(o) ? il(bh(t)) : {}
                                } else
                                    n = {};
                            return (r ? i : ar)(t, function (t, r, i) {
                                return e(n, t, r, i)
                            }),
                                    n
                        }
                        function Ws(t, e) {
                            return null == t || ci(t, e)
                        }
                        function Us(t, e, n) {
                            return null == t ? t : hi(t, e, vi(n))
                        }
                        function Hs(t, e, n, r) {
                            return r = "function" == typeof r ? r : X,
                                    null == t ? t : hi(t, e, vi(n), r)
                        }
                        function Js(t) {
                            return t ? P(t, Ps(t)) : []
                        }
                        function Gs(t) {
                            return null == t ? [] : P(t, Ls(t))
                        }
                        function qs(t, e, n) {
                            return n === X && (n = e,
                                    e = X),
                                    n !== X && (n = ds(n),
                                            n = n === n ? n : 0),
                                    e !== X && (e = ds(e),
                                            e = e === e ? e : 0),
                                    En(ds(t), e, n)
                        }
                        function $s(t, e, n) {
                            return e = fs(e),
                                    n === X ? (n = e,
                                            e = 0) : n = fs(n),
                                    t = ds(t),
                                    yr(t, e, n)
                        }
                        function Ks(t, e, n) {
                            if (n && "boolean" != typeof n && Ro(t, e, n) && (e = n = X),
                                    n === X && ("boolean" == typeof e ? (n = e,
                                            e = X) : "boolean" == typeof t && (n = t,
                                            t = X)),
                                    t === X && e === X ? (t = 0,
                                            e = 1) : (t = fs(t),
                                    e === X ? (e = t,
                                            t = 0) : e = fs(e)),
                                    t > e) {
                                var r = t;
                                t = e,
                                        e = r
                            }
                            if (n || t % 1 || e % 1) {
                                var i = zh();
                                return Eh(t + i * (e - t + Nn("1e-" + ((i + "").length - 1))), e)
                            }
                            return $r(t, e)
                        }
                        function Vs(t) {
                            return Nf(ms(t).toLowerCase())
                        }
                        function Zs(t) {
                            return t = ms(t),
                                    t && t.replace(ze, rr).replace(Cn, "")
                        }
                        function Ys(t, e, n) {
                            t = ms(t),
                                    e = ui(e);
                            var r = t.length;
                            n = n === X ? r : En(ps(n), 0, r);
                            var i = n;
                            return n -= e.length,
                                    n >= 0 && t.slice(n, i) == e
                        }
                        function Qs(t) {
                            return t = ms(t),
                                    t && ge.test(t) ? t.replace(fe, ir) : t
                        }
                        function Xs(t) {
                            return t = ms(t),
                                    t && Ie.test(t) ? t.replace(xe, "\\$&") : t
                        }
                        function tc(t, e, n) {
                            t = ms(t),
                                    e = ps(e);
                            var r = e ? K(t) : 0;
                            if (!e || r >= e)
                                return t;
                            var i = (e - r) / 2;
                            return Vi(Ah(i), n) + t + Vi(kh(i), n)
                        }
                        function ec(t, e, n) {
                            t = ms(t),
                                    e = ps(e);
                            var r = e ? K(t) : 0;
                            return e && r < e ? t + Vi(e - r, n) : t
                        }
                        function nc(t, e, n) {
                            t = ms(t),
                                    e = ps(e);
                            var r = e ? K(t) : 0;
                            return e && r < e ? Vi(e - r, n) + t : t
                        }
                        function rc(t, e, n) {
                            return n || null == e ? e = 0 : e && (e = +e),
                                    Th(ms(t).replace(Re, ""), e || 0)
                        }
                        function ic(t, e, n) {
                            return e = (n ? Ro(t, e, n) : e === X) ? 1 : ps(e),
                                    Vr(ms(t), e)
                        }
                        function oc() {
                            var t = arguments
                                    , e = ms(t[0]);
                            return t.length < 3 ? e : e.replace(t[1], t[2])
                        }
                        function ac(t, e, n) {
                            return n && "number" != typeof n && Ro(t, e, n) && (e = n = X),
                                    (n = n === X ? Mt : n >>> 0) ? (t = ms(t),
                                    t && ("string" == typeof e || null != e && !ff(e)) && (e = ui(e),
                                    !e && T(t)) ? mi(V(t), 0, n) : t.split(e, n)) : []
                        }
                        function uc(t, e, n) {
                            return t = ms(t),
                                    n = En(ps(n), 0, t.length),
                                    e = ui(e),
                                    t.slice(n, n + e.length) == e
                        }
                        function sc(t, e, n) {
                            var r = D.templateSettings;
                            n && Ro(t, e, n) && (e = X),
                                    t = ms(t),
                                    e = bf({}, e, r, xn);
                            var i, o, a = bf({}, e.imports, r.imports, xn), u = Ps(a), s = P(a, u), c = 0, h = e.interpolate || Ne, l = "__p += '", f = Xc((e.escape || Ne).source + "|" + h.source + "|" + (h === ye ? Le : Ne).source + "|" + (e.evaluate || Ne).source + "|$", "g"), p = "//# sourceURL=" + ("sourceURL"in e ? e.sourceURL : "lodash.templateSources[" + ++Bn + "]") + "\n";
                            t.replace(f, function (e, n, r, a, u, s) {
                                return r || (r = a),
                                        l += t.slice(c, s).replace(We, E),
                                        n && (i = !0,
                                                l += "' +\n__e(" + n + ") +\n'"),
                                        u && (o = !0,
                                                l += "';\n" + u + ";\n__p += '"),
                                        r && (l += "' +\n((__t = (" + r + ")) == null ? '' : __t) +\n'"),
                                        c = s + e.length,
                                        e
                            }),
                                    l += "';\n";
                            var g = e.variable;
                            g || (l = "with (obj) {\n" + l + "\n}\n"),
                                    l = (o ? l.replace(se, "") : l).replace(ce, "$1").replace(he, "$1;"),
                                    l = "function(" + (g || "obj") + ") {\n" + (g ? "" : "obj || (obj = {});\n") + "var __t, __p = ''" + (i ? ", __e = _.escape" : "") + (o ? ", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n" : ";\n") + l + "return __p\n}";
                            var d = Wf(function () {
                                return Zc(u, p + "return " + l).apply(X, s)
                            });
                            if (d.source = l,
                                    Ju(d))
                                throw d;
                            return d
                        }
                        function cc(t) {
                            return ms(t).toLowerCase()
                        }
                        function hc(t) {
                            return ms(t).toUpperCase()
                        }
                        function lc(t, e, n) {
                            if (t = ms(t),
                                    t && (n || e === X))
                                return t.replace(De, "");
                            if (!t || !(e = ui(e)))
                                return t;
                            var r = V(t)
                                    , i = V(e)
                                    , o = B(r, i)
                                    , a = j(r, i) + 1;
                            return mi(r, o, a).join("")
                        }
                        function fc(t, e, n) {
                            if (t = ms(t),
                                    t && (n || e === X))
                                return t.replace(Se, "");
                            if (!t || !(e = ui(e)))
                                return t;
                            var r = V(t)
                                    , i = j(r, V(e)) + 1;
                            return mi(r, 0, i).join("")
                        }
                        function pc(t, e, n) {
                            if (t = ms(t),
                                    t && (n || e === X))
                                return t.replace(Re, "");
                            if (!t || !(e = ui(e)))
                                return t;
                            var r = V(t)
                                    , i = B(r, V(e));
                            return mi(r, i).join("")
                        }
                        function gc(t, e) {
                            var n = bt
                                    , r = _t;
                            if (Vu(e)) {
                                var i = "separator"in e ? e.separator : i;
                                n = "length"in e ? ps(e.length) : n,
                                        r = "omission"in e ? ui(e.omission) : r
                            }
                            t = ms(t);
                            var o = t.length;
                            if (T(t)) {
                                var a = V(t);
                                o = a.length
                            }
                            if (n >= o)
                                return t;
                            var u = n - K(r);
                            if (u < 1)
                                return r;
                            var s = a ? mi(a, 0, u).join("") : t.slice(0, u);
                            if (i === X)
                                return s + r;
                            if (a && (u += s.length - u),
                                    ff(i)) {
                                if (t.slice(u).search(i)) {
                                    var c, h = s;
                                    for (i.global || (i = Xc(i.source, ms(Be.exec(i)) + "g")),
                                            i.lastIndex = 0; c = i.exec(h); )
                                        var l = c.index;
                                    s = s.slice(0, l === X ? u : l)
                                }
                            } else if (t.indexOf(ui(i), u) != u) {
                                var f = s.lastIndexOf(i);
                                f > -1 && (s = s.slice(0, f))
                            }
                            return s + r
                        }
                        function dc(t) {
                            return t = ms(t),
                                    t && pe.test(t) ? t.replace(le, or) : t
                        }
                        function vc(t, e, n) {
                            return t = ms(t),
                                    e = n ? X : e,
                                    e === X ? z(t) ? Q(t) : v(t) : t.match(e) || []
                        }
                        function yc(t) {
                            var e = t ? t.length : 0
                                    , r = lo();
                            return t = e ? h(t, function (t) {
                                if ("function" != typeof t[1])
                                    throw new eh(rt);
                                return [r(t[0]), t[1]]
                            }) : [],
                                    Zr(function (r) {
                                        for (var i = -1; ++i < e; ) {
                                            var o = t[i];
                                            if (n(o[0], this, r))
                                                return n(o[1], this, r)
                                        }
                                    })
                        }
                        function mc(t) {
                            return Tn(Fn(t, !0))
                        }
                        function bc(t) {
                            return function () {
                                return t
                            }
                        }
                        function _c(t, e) {
                            return null == t || t !== t ? e : t
                        }
                        function wc(t) {
                            return t
                        }
                        function xc(t) {
                            return Pr("function" == typeof t ? t : Fn(t, !0))
                        }
                        function Ic(t) {
                            return Er(Fn(t, !0))
                        }
                        function Dc(t, e) {
                            return Fr(t, Fn(e, !0))
                        }
                        function Rc(t, e, n) {
                            var r = Ps(e)
                                    , o = hr(e, r);
                            null != n || Vu(e) && (o.length || !r.length) || (n = e,
                                    e = t,
                                    t = this,
                                    o = hr(e, Ps(e)));
                            var a = !(Vu(n) && "chain"in n && !n.chain)
                                    , u = qu(t);
                            return i(o, function (n) {
                                var r = e[n];
                                t[n] = r,
                                        u && (t.prototype[n] = function () {
                                            var e = this.__chain__;
                                            if (a || e) {
                                                var n = t(this.__wrapped__)
                                                        , i = n.__actions__ = Pi(this.__actions__);
                                                return i.push({
                                                    func: r,
                                                    args: arguments,
                                                    thisArg: t
                                                }),
                                                        n.__chain__ = e,
                                                        n
                                            }
                                            return r.apply(t, l([this.value()], arguments))
                                        }
                                        )
                            }),
                                    t
                        }
                        function Sc() {
                            return Jn._ === this && (Jn._ = fh),
                                    this
                        }
                        function Cc() {}
                        function kc(t) {
                            return t = ps(t),
                                    Zr(function (e) {
                                        return Nr(e, t)
                                    })
                        }
                        function Ac(t) {
                            return So(t) ? I(Ho(t)) : Jr(t)
                        }
                        function Mc(t) {
                            return function (e) {
                                return null == t ? X : lr(t, e)
                            }
                        }
                        function Pc() {
                            return []
                        }
                        function Lc() {
                            return !1
                        }
                        function Bc() {
                            return {}
                        }
                        function jc() {
                            return ""
                        }
                        function Oc() {
                            return !0
                        }
                        function Ec(t, e) {
                            if (t = ps(t),
                                    t < 1 || t > Ct)
                                return [];
                            var n = Mt
                                    , r = Eh(t, Mt);
                            e = lo(e),
                                    t -= Mt;
                            for (var i = k(r, e); ++n < t; )
                                e(n);
                            return i
                        }
                        function Fc(t) {
                            return uf(t) ? h(t, Ho) : us(t) ? [t] : Pi(xl(t))
                        }
                        function Tc(t) {
                            var e = ++ch;
                            return ms(t) + e
                        }
                        function zc(t) {
                            return t && t.length ? qn(t, wc, gr) : X
                        }
                        function Nc(t, e) {
                            return t && t.length ? qn(t, lo(e, 2), gr) : X
                        }
                        function Wc(t) {
                            return x(t, wc)
                        }
                        function Uc(t, e) {
                            return x(t, lo(e, 2))
                        }
                        function Hc(t) {
                            return t && t.length ? qn(t, wc, jr) : X
                        }
                        function Jc(t, e) {
                            return t && t.length ? qn(t, lo(e, 2), jr) : X
                        }
                        function Gc(t) {
                            return t && t.length ? C(t, wc) : 0
                        }
                        function qc(t, e) {
                            return t && t.length ? C(t, lo(e, 2)) : 0
                        }
                        d = d ? ur.defaults(Jn.Object(), d, ur.pick(Jn, Ln)) : Jn;
                        var $c = d.Array
                                , Kc = d.Date
                                , Vc = d.Error
                                , Zc = d.Function
                                , Yc = d.Math
                                , Qc = d.Object
                                , Xc = d.RegExp
                                , th = d.String
                                , eh = d.TypeError
                                , nh = $c.prototype
                                , rh = Zc.prototype
                                , ih = Qc.prototype
                                , oh = d["__core-js_shared__"]
                                , ah = function () {
                                    var t = /[^.]+$/.exec(oh && oh.keys && oh.keys.IE_PROTO || "");
                                    return t ? "Symbol(src)_1." + t : ""
                                }()
                                , uh = rh.toString
                                , sh = ih.hasOwnProperty
                                , ch = 0
                                , hh = uh.call(Qc)
                                , lh = ih.toString
                                , fh = Jn._
                                , ph = Xc("^" + uh.call(sh).replace(xe, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$")
                                , gh = $n ? d.Buffer : X
                                , dh = d.Symbol
                                , vh = d.Uint8Array
                                , yh = gh ? gh.allocUnsafe : X
                                , mh = Qc.defineProperty
                                , bh = U(Qc.getPrototypeOf, Qc)
                                , _h = dh ? dh.iterator : X
                                , wh = Qc.create
                                , xh = ih.propertyIsEnumerable
                                , Ih = nh.splice
                                , Dh = dh ? dh.isConcatSpreadable : X
                                , Rh = d.clearTimeout !== Jn.clearTimeout && d.clearTimeout
                                , Sh = Kc && Kc.now !== Jn.Date.now && Kc.now
                                , Ch = d.setTimeout !== Jn.setTimeout && d.setTimeout
                                , kh = Yc.ceil
                                , Ah = Yc.floor
                                , Mh = Qc.getOwnPropertySymbols
                                , Ph = gh ? gh.isBuffer : X
                                , Lh = d.isFinite
                                , Bh = nh.join
                                , jh = U(Qc.keys, Qc)
                                , Oh = Yc.max
                                , Eh = Yc.min
                                , Fh = Kc.now
                                , Th = d.parseInt
                                , zh = Yc.random
                                , Nh = nh.reverse
                                , Wh = go(d, "DataView")
                                , Uh = go(d, "Map")
                                , Hh = go(d, "Promise")
                                , Jh = go(d, "Set")
                                , Gh = go(d, "WeakMap")
                                , qh = go(Qc, "create")
                                , $h = go(Qc, "defineProperty")
                                , Kh = Gh && new Gh
                                , Vh = {}
                        , Zh = Jo(Wh)
                                , Yh = Jo(Uh)
                                , Qh = Jo(Hh)
                                , Xh = Jo(Jh)
                                , tl = Jo(Gh)
                                , el = dh ? dh.prototype : X
                                , nl = el ? el.valueOf : X
                                , rl = el ? el.toString : X
                                , il = function () {
                                    function t() {}
                                    return function (e) {
                                        if (!Vu(e))
                                            return {};
                                        if (wh)
                                            return wh(e);
                                        t.prototype = prototype;
                                        var n = new t;
                                        return t.prototype = X,
                                                n
                                    }
                                }();
                        D.templateSettings = {
                            escape: de,
                            evaluate: ve,
                            interpolate: ye,
                            variable: "",
                            imports: {
                                _: D
                            }
                        },
                                D.prototype = q.prototype,
                                D.prototype.constructor = D,
                                Z.prototype = il(q.prototype),
                                Z.prototype.constructor = Z,
                                Y.prototype = il(q.prototype),
                                Y.prototype.constructor = Y,
                                Je.prototype.clear = Ge,
                                Je.prototype["delete"] = qe,
                                Je.prototype.get = $e,
                                Je.prototype.has = Ke,
                                Je.prototype.set = Ve,
                                Ze.prototype.clear = Ye,
                                Ze.prototype["delete"] = Qe,
                                Ze.prototype.get = Xe,
                                Ze.prototype.has = tn,
                                Ze.prototype.set = en,
                                nn.prototype.clear = rn,
                                nn.prototype["delete"] = on,
                                nn.prototype.get = an,
                                nn.prototype.has = un,
                                nn.prototype.set = sn,
                                cn.prototype.add = cn.prototype.push = hn,
                                cn.prototype.has = ln,
                                fn.prototype.clear = pn,
                                fn.prototype["delete"] = gn,
                                fn.prototype.get = dn,
                                fn.prototype.has = vn,
                                fn.prototype.set = yn;
                        var ol = Ei(ar)
                                , al = Ei(cr, !0)
                                , ul = Fi()
                                , sl = Fi(!0)
                                , cl = Kh ? function (t, e) {
                                    return Kh.set(t, e),
                                            t
                                }
                        : wc
                                , hl = $h ? function (t, e) {
                                    return $h(t, "toString", {
                                        configurable: !0,
                                        enumerable: !1,
                                        value: bc(e),
                                        writable: !0
                                    })
                                }
                        : wc
                                , ll = Zr
                                , fl = Rh || function (t) {
                                    return Jn.clearTimeout(t)
                                }
                        , pl = Jh && 1 / J(new Jh([, -0]))[1] == St ? function (t) {
                            return new Jh(t)
                        }
                        : Cc
                                , gl = Kh ? function (t) {
                                    return Kh.get(t)
                                }
                        : Cc
                                , dl = Mh ? U(Mh, Qc) : Pc
                                , vl = Mh ? function (t) {
                                    for (var e = []; t; )
                                        l(e, dl(t)),
                                                t = bh(t);
                                    return e
                                }
                        : Pc
                                , yl = pr;
                        (Wh && yl(new Wh(new ArrayBuffer(1))) != Qt || Uh && yl(new Uh) != Wt || Hh && yl(Hh.resolve()) != Jt || Jh && yl(new Jh) != qt || Gh && yl(new Gh) != Vt) && (yl = function (t) {
                            var e = lh.call(t)
                                    , n = e == Ht ? t.constructor : X
                                    , r = n ? Jo(n) : X;
                            if (r)
                                switch (r) {
                                    case Zh:
                                        return Qt;
                                    case Yh:
                                        return Wt;
                                    case Qh:
                                        return Jt;
                                    case Xh:
                                        return qt;
                                    case tl:
                                        return Vt
                                }
                            return e
                        }
                        );
                        var ml = oh ? qu : Lc
                                , bl = Wo(cl)
                                , _l = Ch || function (t, e) {
                                    return Jn.setTimeout(t, e)
                                }
                        , wl = Wo(hl)
                                , xl = Bo(function (t) {
                                    t = ms(t);
                                    var e = [];
                                    return _e.test(t) && e.push(""),
                                            t.replace(we, function (t, n, r, i) {
                                                e.push(r ? i.replace(Pe, "$1") : n || t)
                                            }),
                                            e
                                })
                                , Il = Zr(function (t, e) {
                                    return Tu(t) ? Hn(t, nr(e, 1, Tu, !0)) : []
                                })
                                , Dl = Zr(function (t, e) {
                                    var n = la(e);
                                    return Tu(n) && (n = X),
                                            Tu(t) ? Hn(t, nr(e, 1, Tu, !0), lo(n, 2)) : []
                                })
                                , Rl = Zr(function (t, e) {
                                    var n = la(e);
                                    return Tu(n) && (n = X),
                                            Tu(t) ? Hn(t, nr(e, 1, Tu, !0), X, n) : []
                                })
                                , Sl = Zr(function (t) {
                                    var e = h(t, di);
                                    return e.length && e[0] === t[0] ? mr(e) : []
                                })
                                , Cl = Zr(function (t) {
                                    var e = la(t)
                                            , n = h(t, di);
                                    return e === la(n) ? e = X : n.pop(),
                                            n.length && n[0] === t[0] ? mr(n, lo(e, 2)) : []
                                })
                                , kl = Zr(function (t) {
                                    var e = la(t)
                                            , n = h(t, di);
                                    return e === la(n) ? e = X : n.pop(),
                                            n.length && n[0] === t[0] ? mr(n, X, e) : []
                                })
                                , Al = Zr(ga)
                                , Ml = ao(function (t, e) {
                                    var n = t ? t.length : 0
                                            , r = Pn(t, e);
                                    return qr(t, h(e, function (t) {
                                        return Do(t, n) ? +t : t
                                    }).sort(Ci)),
                                            r
                                })
                                , Pl = Zr(function (t) {
                                    return si(nr(t, 1, Tu, !0))
                                })
                                , Ll = Zr(function (t) {
                                    var e = la(t);
                                    return Tu(e) && (e = X),
                                            si(nr(t, 1, Tu, !0), lo(e, 2))
                                })
                                , Bl = Zr(function (t) {
                                    var e = la(t);
                                    return Tu(e) && (e = X),
                                            si(nr(t, 1, Tu, !0), X, e)
                                })
                                , jl = Zr(function (t, e) {
                                    return Tu(t) ? Hn(t, e) : []
                                })
                                , Ol = Zr(function (t) {
                                    return pi(u(t, Tu))
                                })
                                , El = Zr(function (t) {
                                    var e = la(t);
                                    return Tu(e) && (e = X),
                                            pi(u(t, Tu), lo(e, 2))
                                })
                                , Fl = Zr(function (t) {
                                    var e = la(t);
                                    return Tu(e) && (e = X),
                                            pi(u(t, Tu), X, e)
                                })
                                , Tl = Zr(Ea)
                                , zl = Zr(function (t) {
                                    var e = t.length
                                            , n = e > 1 ? t[e - 1] : X;
                                    return n = "function" == typeof n ? (t.pop(),
                                            n) : X,
                                            Fa(t, n)
                                })
                                , Nl = ao(function (t) {
                                    var e = t.length
                                            , n = e ? t[0] : 0
                                            , r = this.__wrapped__
                                            , i = function (e) {
                                                return Pn(e, t)
                                            };
                                    return !(e > 1 || this.__actions__.length) && r instanceof Y && Do(n) ? (r = r.slice(n, +n + (e ? 1 : 0)),
                                            r.__actions__.push({
                                                func: Ua,
                                                args: [i],
                                                thisArg: X
                                            }),
                                            new Z(r, this.__chain__).thru(function (t) {
                                        return e && !t.length && t.push(X),
                                                t
                                    })) : this.thru(i)
                                })
                                , Wl = ji(function (t, e, n) {
                                    sh.call(t, n) ? ++t[n] : Mn(t, n, 1)
                                })
                                , Ul = Hi(ea)
                                , Hl = Hi(na)
                                , Jl = ji(function (t, e, n) {
                                    sh.call(t, n) ? t[n].push(e) : Mn(t, n, [e])
                                })
                                , Gl = Zr(function (t, e, r) {
                                    var i = -1
                                            , o = "function" == typeof e
                                            , a = So(e)
                                            , u = Fu(t) ? $c(t.length) : [];
                                    return ol(t, function (t) {
                                        var s = o ? e : a && null != t ? t[e] : X;
                                        u[++i] = s ? n(s, t, r) : _r(t, e, r)
                                    }),
                                            u
                                })
                                , ql = ji(function (t, e, n) {
                                    Mn(t, n, e)
                                })
                                , $l = ji(function (t, e, n) {
                                    t[n ? 0 : 1].push(e)
                                }, function () {
                                    return [[], []]
                                })
                                , Kl = Zr(function (t, e) {
                                    if (null == t)
                                        return [];
                                    var n = e.length;
                                    return n > 1 && Ro(t, e[0], e[1]) ? e = [] : n > 2 && Ro(e[0], e[1], e[2]) && (e = [e[0]]),
                                            Wr(t, nr(e, 1), [])
                                })
                                , Vl = Sh || function () {
                                    return Jn.Date.now()
                                }
                        , Zl = Zr(function (t, e, n) {
                            var r = ut;
                            if (n.length) {
                                var i = H(n, ho(Zl));
                                r |= ft
                            }
                            return no(t, r, e, n, i)
                        })
                                , Yl = Zr(function (t, e, n) {
                                    var r = ut | st;
                                    if (n.length) {
                                        var i = H(n, ho(Yl));
                                        r |= ft
                                    }
                                    return no(e, r, t, n, i)
                                })
                                , Ql = Zr(function (t, e) {
                                    return Un(t, 1, e)
                                })
                                , Xl = Zr(function (t, e, n) {
                                    return Un(t, ds(e) || 0, n)
                                });
                        wu.Cache = nn;
                        var tf = ll(function (t, e) {
                            e = 1 == e.length && uf(e[0]) ? h(e[0], M(lo())) : h(nr(e, 1), M(lo()));
                            var r = e.length;
                            return Zr(function (i) {
                                for (var o = -1, a = Eh(i.length, r); ++o < a; )
                                    i[o] = e[o].call(this, i[o]);
                                return n(t, this, i)
                            })
                        })
                                , ef = Zr(function (t, e) {
                                    var n = H(e, ho(ef));
                                    return no(t, ft, X, e, n)
                                })
                                , nf = Zr(function (t, e) {
                                    var n = H(e, ho(nf));
                                    return no(t, pt, X, e, n)
                                })
                                , rf = ao(function (t, e) {
                                    return no(t, dt, X, X, X, e)
                                })
                                , of = Qi(gr)
                                , af = Qi(function (t, e) {
                                    return t >= e
                                })
                                , uf = $c.isArray
                                , sf = Zn ? M(Zn) : wr
                                , cf = Ph || Lc
                                , hf = Yn ? M(Yn) : xr
                                , lf = Qn ? M(Qn) : Rr
                                , ff = Xn ? M(Xn) : kr
                                , pf = tr ? M(tr) : Ar
                                , gf = er ? M(er) : Mr
                                , df = Qi(jr)
                                , vf = Qi(function (t, e) {
                                    return t <= e
                                })
                                , yf = Oi(function (t, e) {
                                    if (Mo(e) || Fu(e))
                                        return void Li(e, Ps(e), t);
                                    for (var n in e)
                                        sh.call(e, n) && Dn(t, n, e[n])
                                })
                                , mf = Oi(function (t, e) {
                                    Li(e, Ls(e), t)
                                })
                                , bf = Oi(function (t, e, n, r) {
                                    Li(e, Ls(e), t, r)
                                })
                                , _f = Oi(function (t, e, n, r) {
                                    Li(e, Ps(e), t, r)
                                })
                                , wf = ao(Pn)
                                , xf = Zr(function (t) {
                                    return t.push(X, xn),
                                            n(bf, X, t)
                                })
                                , If = Zr(function (t) {
                                    return t.push(X, Oo),
                                            n(kf, X, t)
                                })
                                , Df = qi(function (t, e, n) {
                                    t[e] = n
                                }, bc(wc))
                                , Rf = qi(function (t, e, n) {
                                    sh.call(t, e) ? t[e].push(n) : t[e] = [n]
                                }, lo)
                                , Sf = Zr(_r)
                                , Cf = Oi(function (t, e, n) {
                                    Tr(t, e, n)
                                })
                                , kf = Oi(function (t, e, n, r) {
                                    Tr(t, e, n, r)
                                })
                                , Af = ao(function (t, e) {
                                    return null == t ? {} : (e = h(e, Ho),
                                            Ur(t, Hn(so(t), e)))
                                })
                                , Mf = ao(function (t, e) {
                                    return null == t ? {} : Ur(t, h(e, Ho))
                                })
                                , Pf = eo(Ps)
                                , Lf = eo(Ls)
                                , Bf = Ni(function (t, e, n) {
                                    return e = e.toLowerCase(),
                                            t + (n ? Vs(e) : e)
                                })
                                , jf = Ni(function (t, e, n) {
                                    return t + (n ? "-" : "") + e.toLowerCase()
                                })
                                , Of = Ni(function (t, e, n) {
                                    return t + (n ? " " : "") + e.toLowerCase()
                                })
                                , Ef = zi("toLowerCase")
                                , Ff = Ni(function (t, e, n) {
                                    return t + (n ? "_" : "") + e.toLowerCase()
                                })
                                , Tf = Ni(function (t, e, n) {
                                    return t + (n ? " " : "") + Nf(e)
                                })
                                , zf = Ni(function (t, e, n) {
                                    return t + (n ? " " : "") + e.toUpperCase()
                                })
                                , Nf = zi("toUpperCase")
                                , Wf = Zr(function (t, e) {
                                    try {
                                        return n(t, X, e)
                                    } catch (r) {
                                        return Ju(r) ? r : new Vc(r)
                                    }
                                })
                                , Uf = ao(function (t, e) {
                                    return i(e, function (e) {
                                        e = Ho(e),
                                                Mn(t, e, Zl(t[e], t))
                                    }),
                                            t
                                })
                                , Hf = Ji()
                                , Jf = Ji(!0)
                                , Gf = Zr(function (t, e) {
                                    return function (n) {
                                        return _r(n, t, e)
                                    }
                                })
                                , qf = Zr(function (t, e) {
                                    return function (n) {
                                        return _r(t, n, e)
                                    }
                                })
                                , $f = Ki(h)
                                , Kf = Ki(a)
                                , Vf = Ki(g)
                                , Zf = Yi()
                                , Yf = Yi(!0)
                                , Qf = $i(function (t, e) {
                                    return t + e
                                }, 0)
                                , Xf = to("ceil")
                                , tp = $i(function (t, e) {
                                    return t / e
                                }, 1)
                                , ep = to("floor")
                                , np = $i(function (t, e) {
                                    return t * e
                                }, 1)
                                , rp = to("round")
                                , ip = $i(function (t, e) {
                                    return t - e
                                }, 0);
                        return D.after = gu,
                                D.ary = du,
                                D.assign = yf,
                                D.assignIn = mf,
                                D.assignInWith = bf,
                                D.assignWith = _f,
                                D.at = wf,
                                D.before = vu,
                                D.bind = Zl,
                                D.bindAll = Uf,
                                D.bindKey = Yl,
                                D.castArray = Au,
                                D.chain = Na,
                                D.chunk = $o,
                                D.compact = Ko,
                                D.concat = Vo,
                                D.cond = yc,
                                D.conforms = mc,
                                D.constant = bc,
                                D.countBy = Wl,
                                D.create = bs,
                                D.curry = yu,
                                D.curryRight = mu,
                                D.debounce = bu,
                                D.defaults = xf,
                                D.defaultsDeep = If,
                                D.defer = Ql,
                                D.delay = Xl,
                                D.difference = Il,
                                D.differenceBy = Dl,
                                D.differenceWith = Rl,
                                D.drop = Zo,
                                D.dropRight = Yo,
                                D.dropRightWhile = Qo,
                                D.dropWhile = Xo,
                                D.fill = ta,
                                D.filter = Ya,
                                D.flatMap = Qa,
                                D.flatMapDeep = Xa,
                                D.flatMapDepth = tu,
                                D.flatten = ra,
                                D.flattenDeep = ia,
                                D.flattenDepth = oa,
                                D.flip = _u,
                                D.flow = Hf,
                                D.flowRight = Jf,
                                D.fromPairs = aa,
                                D.functions = Ss,
                                D.functionsIn = Cs,
                                D.groupBy = Jl,
                                D.initial = ca,
                                D.intersection = Sl,
                                D.intersectionBy = Cl,
                                D.intersectionWith = kl,
                                D.invert = Df,
                                D.invertBy = Rf,
                                D.invokeMap = Gl,
                                D.iteratee = xc,
                                D.keyBy = ql,
                                D.keys = Ps,
                                D.keysIn = Ls,
                                D.map = iu,
                                D.mapKeys = Bs,
                                D.mapValues = js,
                                D.matches = Ic,
                                D.matchesProperty = Dc,
                                D.memoize = wu,
                                D.merge = Cf,
                                D.mergeWith = kf,
                                D.method = Gf,
                                D.methodOf = qf,
                                D.mixin = Rc,
                                D.negate = xu,
                                D.nthArg = kc,
                                D.omit = Af,
                                D.omitBy = Os,
                                D.once = Iu,
                                D.orderBy = ou,
                                D.over = $f,
                                D.overArgs = tf,
                                D.overEvery = Kf,
                                D.overSome = Vf,
                                D.partial = ef,
                                D.partialRight = nf,
                                D.partition = $l,
                                D.pick = Mf,
                                D.pickBy = Es,
                                D.property = Ac,
                                D.propertyOf = Mc,
                                D.pull = Al,
                                D.pullAll = ga,
                                D.pullAllBy = da,
                                D.pullAllWith = va,
                                D.pullAt = Ml,
                                D.range = Zf,
                                D.rangeRight = Yf,
                                D.rearg = rf,
                                D.reject = su,
                                D.remove = ya,
                                D.rest = Du,
                                D.reverse = ma,
                                D.sampleSize = hu,
                                D.set = Ts,
                                D.setWith = zs,
                                D.shuffle = lu,
                                D.slice = ba,
                                D.sortBy = Kl,
                                D.sortedUniq = Sa,
                                D.sortedUniqBy = Ca,
                                D.split = ac,
                                D.spread = Ru,
                                D.tail = ka,
                                D.take = Aa,
                                D.takeRight = Ma,
                                D.takeRightWhile = Pa,
                                D.takeWhile = La,
                                D.tap = Wa,
                                D.throttle = Su,
                                D.thru = Ua,
                                D.toArray = ls,
                                D.toPairs = Pf,
                                D.toPairsIn = Lf,
                                D.toPath = Fc,
                                D.toPlainObject = vs,
                                D.transform = Ns,
                                D.unary = Cu,
                                D.union = Pl,
                                D.unionBy = Ll,
                                D.unionWith = Bl,
                                D.uniq = Ba,
                                D.uniqBy = ja,
                                D.uniqWith = Oa,
                                D.unset = Ws,
                                D.unzip = Ea,
                                D.unzipWith = Fa,
                                D.update = Us,
                                D.updateWith = Hs,
                                D.values = Js,
                                D.valuesIn = Gs,
                                D.without = jl,
                                D.words = vc,
                                D.wrap = ku,
                                D.xor = Ol,
                                D.xorBy = El,
                                D.xorWith = Fl,
                                D.zip = Tl,
                                D.zipObject = Ta,
                                D.zipObjectDeep = za,
                                D.zipWith = zl,
                                D.entries = Pf,
                                D.entriesIn = Lf,
                                D.extend = mf,
                                D.extendWith = bf,
                                Rc(D, D),
                                D.add = Qf,
                                D.attempt = Wf,
                                D.camelCase = Bf,
                                D.capitalize = Vs,
                                D.ceil = Xf,
                                D.clamp = qs,
                                D.clone = Mu,
                                D.cloneDeep = Lu,
                                D.cloneDeepWith = Bu,
                                D.cloneWith = Pu,
                                D.conformsTo = ju,
                                D.deburr = Zs,
                                D.defaultTo = _c,
                                D.divide = tp,
                                D.endsWith = Ys,
                                D.eq = Ou,
                                D.escape = Qs,
                                D.escapeRegExp = Xs,
                                D.every = Za,
                                D.find = Ul,
                                D.findIndex = ea,
                                D.findKey = _s,
                                D.findLast = Hl,
                                D.findLastIndex = na,
                                D.findLastKey = ws,
                                D.floor = ep,
                                D.forEach = eu,
                                D.forEachRight = nu,
                                D.forIn = xs,
                                D.forInRight = Is,
                                D.forOwn = Ds,
                                D.forOwnRight = Rs,
                                D.get = ks,
                                D.gt = of,
                                D.gte = af,
                                D.has = As,
                                D.hasIn = Ms,
                                D.head = ua,
                                D.identity = wc,
                                D.includes = ru,
                                D.indexOf = sa,
                                D.inRange = $s,
                                D.invoke = Sf,
                                D.isArguments = Eu,
                                D.isArray = uf,
                                D.isArrayBuffer = sf,
                                D.isArrayLike = Fu,
                                D.isArrayLikeObject = Tu,
                                D.isBoolean = zu,
                                D.isBuffer = cf,
                                D.isDate = hf,
                                D.isElement = Nu,
                                D.isEmpty = Wu,
                                D.isEqual = Uu,
                                D.isEqualWith = Hu,
                                D.isError = Ju,
                                D.isFinite = Gu,
                                D.isFunction = qu,
                                D.isInteger = $u,
                                D.isLength = Ku,
                                D.isMap = lf,
                                D.isMatch = Yu,
                                D.isMatchWith = Qu,
                                D.isNaN = Xu,
                                D.isNative = ts,
                                D.isNil = ns,
                                D.isNull = es,
                                D.isNumber = rs,
                                D.isObject = Vu,
                                D.isObjectLike = Zu,
                                D.isPlainObject = is,
                                D.isRegExp = ff,
                                D.isSafeInteger = os,
                                D.isSet = pf,
                                D.isString = as,
                                D.isSymbol = us,
                                D.isTypedArray = gf,
                                D.isUndefined = ss,
                                D.isWeakMap = cs,
                                D.isWeakSet = hs,
                                D.join = ha,
                                D.kebabCase = jf,
                                D.last = la,
                                D.lastIndexOf = fa,
                                D.lowerCase = Of,
                                D.lowerFirst = Ef,
                                D.lt = df,
                                D.lte = vf,
                                D.max = zc,
                                D.maxBy = Nc,
                                D.mean = Wc,
                                D.meanBy = Uc,
                                D.min = Hc,
                                D.minBy = Jc,
                                D.stubArray = Pc,
                                D.stubFalse = Lc,
                                D.stubObject = Bc,
                                D.stubString = jc,
                                D.stubTrue = Oc,
                                D.multiply = np,
                                D.nth = pa,
                                D.noConflict = Sc,
                                D.noop = Cc,
                                D.now = Vl,
                                D.pad = tc,
                                D.padEnd = ec,
                                D.padStart = nc,
                                D.parseInt = rc,
                                D.random = Ks,
                                D.reduce = au,
                                D.reduceRight = uu,
                                D.repeat = ic,
                                D.replace = oc,
                                D.result = Fs,
                                D.round = rp,
                                D.runInContext = sr,
                                D.sample = cu,
                                D.size = fu,
                                D.snakeCase = Ff,
                                D.some = pu,
                                D.sortedIndex = _a,
                                D.sortedIndexBy = wa,
                                D.sortedIndexOf = xa,
                                D.sortedLastIndex = Ia,
                                D.sortedLastIndexBy = Da,
                                D.sortedLastIndexOf = Ra,
                                D.startCase = Tf,
                                D.startsWith = uc,
                                D.subtract = ip,
                                D.sum = Gc,
                                D.sumBy = qc,
                                D.template = sc,
                                D.times = Ec,
                                D.toFinite = fs,
                                D.toInteger = ps,
                                D.toLength = gs,
                                D.toLower = cc,
                                D.toNumber = ds,
                                D.toSafeInteger = ys,
                                D.toString = ms,
                                D.toUpper = hc,
                                D.trim = lc,
                                D.trimEnd = fc,
                                D.trimStart = pc,
                                D.truncate = gc,
                                D.unescape = dc,
                                D.uniqueId = Tc,
                                D.upperCase = zf,
                                D.upperFirst = Nf,
                                D.each = eu,
                                D.eachRight = nu,
                                D.first = ua,
                                Rc(D, function () {
                                    var t = {};
                                    return ar(D, function (e, n) {
                                        sh.call(D.prototype, n) || (t[n] = e)
                                    }),
                                            t
                                }(), {
                                    chain: !1
                                }),
                                D.VERSION = tt,
                                i(["bind", "bindKey", "curry", "curryRight", "partial", "partialRight"], function (t) {
                                    D[t].placeholder = D
                                }),
                                i(["drop", "take"], function (t, e) {
                                    Y.prototype[t] = function (n) {
                                        var r = this.__filtered__;
                                        if (r && !e)
                                            return new Y(this);
                                        n = n === X ? 1 : Oh(ps(n), 0);
                                        var i = this.clone();
                                        return r ? i.__takeCount__ = Eh(n, i.__takeCount__) : i.__views__.push({
                                            size: Eh(n, Mt),
                                            type: t + (i.__dir__ < 0 ? "Right" : "")
                                        }),
                                                i
                                    }
                                    ,
                                            Y.prototype[t + "Right"] = function (e) {
                                        return this.reverse()[t](e).reverse()
                                    }
                                }),
                                i(["filter", "map", "takeWhile"], function (t, e) {
                                    var n = e + 1
                                            , r = n == It || n == Rt;
                                    Y.prototype[t] = function (t) {
                                        var e = this.clone();
                                        return e.__iteratees__.push({
                                            iteratee: lo(t, 3),
                                            type: n
                                        }),
                                                e.__filtered__ = e.__filtered__ || r,
                                                e
                                    }
                                }),
                                i(["head", "last"], function (t, e) {
                                    var n = "take" + (e ? "Right" : "");
                                    Y.prototype[t] = function () {
                                        return this[n](1).value()[0]
                                    }
                                }),
                                i(["initial", "tail"], function (t, e) {
                                    var n = "drop" + (e ? "" : "Right");
                                    Y.prototype[t] = function () {
                                        return this.__filtered__ ? new Y(this) : this[n](1)
                                    }
                                }),
                                Y.prototype.compact = function () {
                                    return this.filter(wc)
                                }
                        ,
                                Y.prototype.find = function (t) {
                                    return this.filter(t).head()
                                }
                        ,
                                Y.prototype.findLast = function (t) {
                                    return this.reverse().find(t)
                                }
                        ,
                                Y.prototype.invokeMap = Zr(function (t, e) {
                                    return "function" == typeof t ? new Y(this) : this.map(function (n) {
                                        return _r(n, t, e)
                                    })
                                }),
                                Y.prototype.reject = function (t) {
                                    return this.filter(xu(lo(t)))
                                }
                        ,
                                Y.prototype.slice = function (t, e) {
                                    t = ps(t);
                                    var n = this;
                                    return n.__filtered__ && (t > 0 || e < 0) ? new Y(n) : (t < 0 ? n = n.takeRight(-t) : t && (n = n.drop(t)),
                                            e !== X && (e = ps(e),
                                                    n = e < 0 ? n.dropRight(-e) : n.take(e - t)),
                                            n)
                                }
                        ,
                                Y.prototype.takeRightWhile = function (t) {
                                    return this.reverse().takeWhile(t).reverse()
                                }
                        ,
                                Y.prototype.toArray = function () {
                                    return this.take(Mt)
                                }
                        ,
                                ar(Y.prototype, function (t, e) {
                                    var n = /^(?:filter|find|map|reject)|While$/.test(e)
                                            , r = /^(?:head|last)$/.test(e)
                                            , i = D[r ? "take" + ("last" == e ? "Right" : "") : e]
                                            , o = r || /^find/.test(e);
                                    i && (D.prototype[e] = function () {
                                        var e = this.__wrapped__
                                                , a = r ? [1] : arguments
                                                , u = e instanceof Y
                                                , s = a[0]
                                                , c = u || uf(e)
                                                , h = function (t) {
                                                    var e = i.apply(D, l([t], a));
                                                    return r && f ? e[0] : e
                                                };
                                        c && n && "function" == typeof s && 1 != s.length && (u = c = !1);
                                        var f = this.__chain__
                                                , p = !!this.__actions__.length
                                                , g = o && !f
                                                , d = u && !p;
                                        if (!o && c) {
                                            e = d ? e : new Y(this);
                                            var v = t.apply(e, a);
                                            return v.__actions__.push({
                                                func: Ua,
                                                args: [h],
                                                thisArg: X
                                            }),
                                                    new Z(v, f)
                                        }
                                        return g && d ? t.apply(this, a) : (v = this.thru(h),
                                                g ? r ? v.value()[0] : v.value() : v)
                                    }
                                    )
                                }),
                                i(["pop", "push", "shift", "sort", "splice", "unshift"], function (t) {
                                    var e = nh[t]
                                            , n = /^(?:push|sort|unshift)$/.test(t) ? "tap" : "thru"
                                            , r = /^(?:pop|shift)$/.test(t);
                                    D.prototype[t] = function () {
                                        var t = arguments;
                                        if (r && !this.__chain__) {
                                            var i = this.value();
                                            return e.apply(uf(i) ? i : [], t)
                                        }
                                        return this[n](function (n) {
                                            return e.apply(uf(n) ? n : [], t)
                                        })
                                    }
                                }),
                                ar(Y.prototype, function (t, e) {
                                    var n = D[e];
                                    if (n) {
                                        var r = n.name + ""
                                                , i = Vh[r] || (Vh[r] = []);
                                        i.push({
                                            name: e,
                                            func: n
                                        })
                                    }
                                }),
                                Vh[Gi(X, st).name] = [{
                                name: "wrapper",
                                func: X
                            }],
                                Y.prototype.clone = Me,
                                Y.prototype.reverse = Ue,
                                Y.prototype.value = He,
                                D.prototype.at = Nl,
                                D.prototype.chain = Ha,
                                D.prototype.commit = Ja,
                                D.prototype.next = Ga,
                                D.prototype.plant = $a,
                                D.prototype.reverse = Ka,
                                D.prototype.toJSON = D.prototype.valueOf = D.prototype.value = Va,
                                D.prototype.first = D.prototype.head,
                                _h && (D.prototype[_h] = qa),
                                D
                    }
            , ur = ar();
            "function" == typeof define && "object" == typeof define.amd && define.amd ? (Jn._ = ur,
                    define(function () {
                        return ur
                    })) : qn ? ((qn.exports = ur)._ = ur,
                    Gn._ = ur) : Jn._ = ur
        }
.call(this),
        function (t) {
            "use strict";
            function e(t) {
                var e = (window.getComputedStyle ? getComputedStyle(t, null) : t.currentStyle).display;
                "none" !== e ? t.style.display = "none" : t.style.display = "block"
            }
            function n(e) {
                return parseFloat(t.getElement(e).value)
            }
            function r() {
                var t = []
                        , e = !0;
                this.filters.map(function (n) {
                    t.push(n.processor()),
                            n.sync === !1 && (e = !1)
                }),
                        this.viewer.setFilterOptions({
                            filters: {
                                processors: t
                            },
                            loadMode: e ? "sync" : "async"
                        })
            }
            if (!t.version || t.version.major < 2)
                throw new Error("This version of OpenSeadragonImagefilters requires OpenSeadragon version 2.0.0+");
            var i = Caman;
            i.Store.put = function () {}
            ,
                    t.Viewer.prototype.imagefilters = function (e) {
                        return this.imageFilterInstance && !e || (e = e || {},
                                e.viewer = this,
                                this.imageFilterInstance = new t.ImagefilterTools(e)),
                                this.imageFilterInstance
                    }
            ,
                    t.ImagefilterTools = function (e) {
                        t.extend(!0, this, {
                            viewer: null,
                            buttonActiveImg: !1,
                            showControl: !0,
                            startOpen: !1,
                            prefixUrl: null,
                            toolsLeft: null,
                            toolsTop: null,
                            toolsWidth: 180,
                            toolsHeight: 150,
                            popUpClass: null,
                            navImages: {
                                imagetools: {
                                    REST: "imagetools_rest.png",
                                    GROUP: "imagetools_grouphover.png",
                                    HOVER: "imagetools_hover.png",
                                    DOWN: "imagetools_pressed.png"
                                }
                            },
                            filters: [{
                                    filterName: "brightness",
                                    min: brightnessminValue,
                                    max: brightnessMaxValue,
                                    value: brightnessDefaultValue,
                                    callback: null,
                                    processor: function () {
                                        var t = n("osd-filter-brightness");
                                        return null !== this.callback && this.callback(t),
                                                OpenSeadragon.Filters.BRIGHTNESS(t)
                                    }
                                }, {
                                    filterName: "contrast",
                                    min: contrastMinValue,
                                    max: contrastMaxValue,
                                    value: 1,
                                    defaultValue: contrastDefaultValue,
                                    step: .1,
                                    callback: null,
                                    processor: function () {
                                        var t = n("osd-filter-contrast");
                                        return null !== this.callback && this.callback(t),
                                                OpenSeadragon.Filters.CONTRAST(t)
                                    }
                                }, {
                                    filterName: "gamma",
                                    min: gammaMinValue,
                                    max: gammaMaxValue,
                                    value: 1,
                                    defaultValue: gammaDefaultValue,
                                    step: .1,
                                    callback: null,
                                    processor: function () {
                                        var t = n("osd-filter-gamma");
                                        return null !== this.callback && this.callback(t),
                                                OpenSeadragon.Filters.GAMMA(t)
                                    }
                                }],
                            toggleButton: null
                        }, e),
                                t.extend(!0, this.navImages, this.viewer.navImages);
                        var r = this.prefixUrl || this.viewer.prefixUrl || ""
                                , i = this.viewer.buttons && this.viewer.buttons.buttons;
                        this.showControl && (this.toggleButton = new t.Button({
                            element: this.toggleButton ? t.getElement(this.toggleButton) : null,
                            clickTimeThreshold: this.viewer.clickTimeThreshold,
                            clickDistThreshold: this.viewer.clickDistThreshold,
                            tooltip: t.getString("Tooltips.ImageTools") || "Image tools",
                            srcRest: r + this.navImages.imagetools.REST,
                            srcGroup: r + this.navImages.imagetools.GROUP,
                            srcHover: r + this.navImages.imagetools.HOVER,
                            srcDown: r + this.navImages.imagetools.DOWN,
                            onRelease: this.openTools.bind(this)
                        }),
                                i && (this.viewer.buttons.buttons.push(this.toggleButton),
                                        this.viewer.buttons.element.appendChild(this.toggleButton.element)),
                                this.toggleButton.imgDown && (this.buttonActiveImg = this.toggleButton.imgDown.cloneNode(!0),
                                        this.toggleButton.element.appendChild(this.buttonActiveImg))),
                                this.viewer.addHandler("open", function () {
                                    this.createPopupDiv(),
                                            this.updateFilters()
                                }
                                .bind(this)),
                                this.startOpen && this.viewer.addHandler("open", function () {
                                    this.openTools()
                                }
                                .bind(this))
                    }
            ,
                    t.extend(t.ImagefilterTools.prototype, t.ControlDock.prototype, {
                        createPopupDiv: function () {
                            var e = t.getElement("osd-imagetools");
                            if (!e) {
                                var n = this.toolsWidth
                                        , r = this.toolsHeight
                                        , i = t.getElement(this.viewer.id)
                                        , o = i.getBoundingClientRect()
                                        , a = this.toolsTop || o.height / 2 - r / 2
                                        , u = this.toolsLeft || 10;
                                e = document.createElement("div"),
                                        e.id = "osd-imagetools",
                                        this.popUpClass ? e["class"] = this.popUpClass : (e.style.display = "none",
                                        e.style.textAlign = "center",
                                        e.style.position = "absolute",
                                        e.style.border = "1px solid #d6e9c6",
                                        e.style.backgroundColor = "#dff0d8",
										e.style.borderRadius = "4px",
                                        e.style.width = n + "px",
                                        e.style.height = r + "px",
                                        e.style.top = a + "px",
                                        //e.style.left = u + "0px"),
										e.style.left = "0px"),
										
                                        this.viewer.addControl(e, {}),
                                        e.style.display = "none",
                                        this.filters.map(function (n) {
                                            var r = document.createElement("input");
											r.class="filter",
                                            r.type = "range",
											r.className = "filter_bar",
                                                    r.min = n.min,
                                                    r.max = n.max,
                                                    r.step = n.step || 1,
                                                    r.value = n.value || 0,
                                                    r.id = "osd-filter-" + n.filterName,
                                                    this.onRangeChange(r);
                                            var i = document.createElement("p");
											var sp = document.createElement("p");
												i.style.margin = "0",
												sp.style.margin = "0",
                                                    r.style.width = "140px",
                                                    sp.innerHTML = t.getString("Tool." + n.filterName) +' ( '+ r.value +' )' || n.filterName +' ( '+ r.value +' )',
                                                    e.appendChild(i),
													i.appendChild(sp),
                                                    i.appendChild(r)													
                                        }
                                        .bind(this));
                                var s = document.createElement("button");
                                s.innerHTML = t.getString("Tool.reset") || "reset",
                                        s.type = "button";
										//s.style.display = "block",
                                        //s.style.margin = "0 auto",
										s.className = "btn btn-filter",
										//s.style.padding = "2px",
                                        s.addEventListener("click", function () {
                                            
											this.resetFilters()
                                        }
                                        .bind(this)),
                                        e.appendChild(s)
                                var s2 = document.createElement("button");
                                s2.innerHTML = t.getString("Tool.close") || "Chiudi",
//                                s2.innerHTML = "Close",
                                        s2.type = "button";
                                //s2.style.display = "block",
										s2.className = "btn btn-filter",
                                        //s2.style.margin = "0 auto",
                                        //s2.style.padding = "2px",
                                        s2.addEventListener("click", function () {
                                            t.getElement("osd-imagetools").style.display = "none";
                                        }
                                        .bind(this)),
                                        e.appendChild(s2)
                            }
                        },
                        openTools: function () {
                            var n = t.getElement("osd-imagetools");
                            e(n)
                        },
                        hideToolsPanel: function () {
                            t.getElement("osd-imagetools").style.display = "none";
                        },
                        
						updateFilters: _.debounce(r, 50),
									
                        resetFilters: function () {
                            this.filters.map(function (e) {
                                var n = t.getElement("osd-filter-" + e.filterName);
								resetFilterValues();
								n.value = e.defaultValue || 0
								var str = $('#osd-filter-'+ e.filterName).parent().children('p').text().replace(/ \(.*\)/,"");
								$('#osd-filter-'+ e.filterName).parent().children('p').html(str +" ( " + (e.defaultValue || 0 ) + " )");
								//console.log("resetFilter: " + e.filterName + " : " + e.defaultValue + " : " + str);
								
								
                            }),
                                    this.updateFilters()
                        },
                        updateValues: function (filterName, filterValue) {
                            var filterId = viewer.tileSources[viewer.currentPage()].sectionGroup + "-" + viewer.tileSources[viewer.currentPage()].croppingType;
                            if (viewer.tileSources[viewer.currentPage()].isGenerated) {
										var str = $('#'+ filterName).parent().children('p').text().replace(/ \(.*\)/,"");
										$('#'+ filterName).parent().children('p').html(str +" ( " + (filterValue || 0 ) + " )");
                                switch (filterName) {
                                    case "osd-filter-brightness":
                                        filterValues[filterId].brightness = filterValue;
										
                                        break;
                                    case "osd-filter-contrast":
                                        filterValues[filterId].contrast = filterValue;
										
                                        break;
                                    case "osd-filter-gamma":
                                        filterValues[filterId].gamma = filterValue;
										
                                        break;
                                }
                            }
                        },
                        onRangeChange: function (t) {
							var e = !0;
                            t.addEventListener("input", function () {
                                e = !1,
                                        this.updateValues(t.id, n(t.id)),
                                        this.updateFilters()
										
                            }
                            .bind(this)),
                                    t.addEventListener("change", function () {
                                        this.updateValues(t.id, n(t.id)),
                                                e && this.updateFilters()
												
                                    }
                                    .bind(this))
                        }
                    })
        }(OpenSeadragon, _, Caman);
//# sourceMappingURL=openseadragonimagefilter.js.map
