<?php

class LiveController extends Controller
{
	protected function beforeAction($event)
	{
	  access_denied_check("view_live");
	  return parent::beforeAction($event);
	}
	
	public function filters()
	{
		return array(
				array('application.filters.SyslogFilter',),
		);
	}
	
  public function actionIndex($id=null)
  {
    $gates = $this->findStreamingGates();
	$selectedGate = null;
	if($id == null)
	{
	  if(isset($gates) && count($gates) > 0)
	    $selectedGate = $gates[0];
	}
	else 
		$selectedGate = $this->loadGate($id);
		
    $this->render('index',array('gates'=>$gates, 'selectedGate'=>$selectedGate));
  }

  public function actionWall()
  {
    $gates = $this->findStreamingGates();
     
    $first = true;
    $index = 0;
    $grid = array();
    
    foreach ($gates as $g)
    {
      if($first)
      {
        $grid[$index] = array();
        $grid[$index][] = $g;
      }
      else
      {
        $grid[$index][] = $g;
        $index++;
      }
      $first = !$first;
    }
    
    if(count($gates) % 2 == 1)
      $grid[$index][] = null;
    
    $this->render('wall',array('grid'=>$grid));
  }

  public function actionDirect($id)
  {
    //$gate = $this->loadGate($id);
    //$this->render('direct',array('gate'=>$gate));
    $this->actionIndex($id);
  }
  
  public function findStreamingGates()
  {
    return Gate::model()->findAll('(live_url IS NOT NULL AND live_url<>\'\')');    
  }
  
  /**
   * find the Gate model
   * @param integer $id id of the gate
   * @return Gate gate data
  * */
  public function loadGate($id)
  {
    $model = Gate::model()->findByPk($id);
    if($model === null)
      throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
    return $model;
  }

  // Uncomment the following methods and override them if needed
  /*
  public function filters()
  {
  // return the filter configuration for this controller, e.g.:
  return array(
      'inlineFilterName',
      array(
          'class'=>'path.to.FilterClass',
          'propertyName'=>'propertyValue',
      ),
  );
  }

  public function actions()
  {
  // return external action classes, e.g.:
  return array(
      'action1'=>'path.to.ActionClass',
      'action2'=>array(
          'class'=>'path.to.AnotherActionClass',
          'propertyName'=>'propertyValue',
      ),
  );
  }
  */
}