<div class="page-header">
  <h2>
    <li class="icon-puzzle-piece"></li>
    <?php echo htmlspecialchars(Yii::t("app", "Migrations"),ENT_QUOTES,'UTF-8'); ?>
  </h2>
</div>
<style><?php echo htmlspecialchars(".linkami { padding: 2px; }",ENT_QUOTES,'UTF-8'); ?></style>
<div style="width: 100%; border: darkgray solid 1px; border-radius: 6px; padding: 5px; background-color: lightgray;">
  <b>
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'linkami'), array('href', (url('debug/migrationCreate')))), 'html5', 'UTF-8'); ?>>
      <div class="icon-plus"></div>
    </a>
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'linkami'), array('href', (url('debug/migrationUp',array('version'=>'')))), array('title', (t('Apply next migration')))), 'html5', 'UTF-8'); ?>>
      <div class="icon-arrow-up"></div>
    </a>
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'linkami'), array('href', (url('debug/migrationDown',array('version'=>'')))), array('title', (t('Remove previous migration')))), 'html5', 'UTF-8'); ?>>
      <div class="icon-arrow-down"></div>
    </a>
  </b>
</div>
<table class="table table-condensed">
  <thead>
    <tr>
      <th></th>
      <th><?php echo htmlspecialchars(t('Name'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('File'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Database'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Actions'),ENT_QUOTES,'UTF-8'); ?></th>
    </tr>
  </thead>
  <tbody>
    <?php $index=0; ?>
    <?php $countDown=0; ?>
    <?php foreach($migrations as $m) { ?>
      <?php $onFile = false; ?>
      <?php $onDb = false; ?>
      <tr>
        <td><?php echo htmlspecialchars($index++,ENT_QUOTES,'UTF-8'); ?></td>
        <td>
          <?php if(array_key_exists($m,$fileMigrations)) { ?>
            <?php $onFile = true; ?>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/viewAsText',array('filename'=>$fileMigrations[$m]->path))))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars($m,ENT_QUOTES,'UTF-8'); ?></a>
          <?php } else { ?>
            <?php echo htmlspecialchars($m,ENT_QUOTES,'UTF-8'); ?>
          <?php } ?>
        </td>
        <td>
          <?php if($onFile) { ?>
            <div class="icon-ok color-green"></div>
          <?php } else { ?>
            <div class="icon-remove color-red"></div>
          <?php } ?>
        </td>
        <td>
          <?php if(array_key_exists($m,$dbMigrations)) { ?>
            <div class="icon-ok color-green"></div>
            <?php $onDb = true; ?>
          <?php } else { ?>
            <div class="icon-remove color-red"></div>
          <?php } ?>
        </td>
        <td>
          <?php if($onFile && !$onDb) { ?>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/migrationUp',array('version'=>$m)))), array('title', (t('Apply all migrations to version')))), 'html5', 'UTF-8'); ?>>
              <div class="icon-arrow-left"></div>
            </a>
          <?php } ?>
          <?php if($onFile && $onDb && $countDown == 0) { ?>
            <?php $countDown++; ?>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/migrationDown',array('version'=>null)))), array('title', (t('Apply all migrations to version')))), 'html5', 'UTF-8'); ?>>
              <div class="icon-arrow-right"></div>
            </a>
          <?php } ?>
          <?php if(!$onDb) { ?>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/migrationBypass',array('version'=>$m)))), array('title', (t('Bypass this version'))), array('onclick', 'return confirm(\'Confirm BYPASS?\');')), 'html5', 'UTF-8'); ?>>
              <div class="icon-angle-up"></div>
            </a>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/migrationBypassTo',array('version'=>$m)))), array('title', (t('Bypass all to version'))), array('onclick', 'return confirm(\'Confirm BYPASS?\');')), 'html5', 'UTF-8'); ?>>
              <div class="icon-double-angle-up"></div>
            </a>
          <?php } ?>
        </td>
      </tr>
    <?php } ?>
  </tbody>
</table>
<pre>
  <?php echo htmlspecialchars($this->getMigrateHelp(),ENT_QUOTES,'UTF-8'); ?>
</pre>
