<h1><?php echo htmlspecialchars('Log Routes',ENT_QUOTES,'UTF-8'); ?></h1>
<span>
  <?php foreach(log_routes_classes() as $className) { ?>
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/LoggerCreate', array('type'=>$className))))), 'html5', 'UTF-8'); ?>>
      <div class="icon-plus"></div>
      <?php echo htmlspecialchars($className,ENT_QUOTES,'UTF-8'); ?>
    </a>
  <?php } ?>
</span>
<table class="table table-condensed">
  <thead>
    <tr>
      <th><?php echo htmlspecialchars('ID',ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars('Type',ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars('Enabled',ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars('Categories',ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars('Levels',ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars('Extra fields',ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars('Actions',ENT_QUOTES,'UTF-8'); ?></th>
    </tr>
  </thead>
  <tbody>
    <?php $configPath = pathCombine(app()->basePath,'config'); ?>
    <?php foreach($routes as $loggerId => $route) { ?>
      <?php $routeConfigFile = pathCombine($configPath,"logger_{$loggerId}.php"); ?>
      <?php $runtimeLogger = is_file($routeConfigFile); ?>
      <?php $props_keys = get_object_readable($route); ?>
      <?php $props_keys = array_remove_values($props_keys, array('enabled','categories','levels','except','filter','logs','init','detachBehaviors','enableBehaviors','disableBehaviors')); ?>
      <tr>
        <td>
          <?php if($runtimeLogger) { ?>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/viewAsText', array('filename'=>$routeConfigFile))))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars("$loggerId",ENT_QUOTES,'UTF-8'); ?></a>
          <?php } else { ?>
            <?php echo htmlspecialchars("$loggerId",ENT_QUOTES,'UTF-8'); ?>
          <?php } ?>
        </td>
        <td><?php echo htmlspecialchars(get_class($route),ENT_QUOTES,'UTF-8'); ?></td>
        <td>
          <?php if($route->enabled) { ?>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('color-green' . ' ' . 'icon-off')), array('href', (url('debug/LoggerSwitch', array('loggerId'=>$loggerId, 'field'=>'enabled', 'value'=>'0'))))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(' Yes',ENT_QUOTES,'UTF-8'); ?></a>
          <?php } else { ?>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('color-red' . ' ' . 'icon-off')), array('href', (url('debug/LoggerSwitch', array('loggerId'=>$loggerId, 'field'=>'enabled', 'value'=>'1'))))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(' No',ENT_QUOTES,'UTF-8'); ?></a>
          <?php } ?>
        </td>
        <td>
          <?php $categories = is_string($route->categories) ? $route->categories : implode(',',$route->categories); ?>
          <?php echo htmlspecialchars(isEmpty($ategories) ? '*' : $categories,ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php $levels = is_string($route->levels) ? $route->levels : implode(',',$route->levels); ?>
          <?php echo htmlspecialchars(isEmpty($levels) ? implode(',',array(CLogger::LEVEL_TRACE,CLogger::LEVEL_WARNING,CLogger::LEVEL_ERROR,CLogger::LEVEL_INFO,CLogger::LEVEL_PROFILE)) : $levels,ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <table class="table table-condensed">
            <thead>
              <tr>
                <th><?php echo htmlspecialchars('Key',ENT_QUOTES,'UTF-8'); ?></th>
                <th><?php echo htmlspecialchars('Value',ENT_QUOTES,'UTF-8'); ?></th>
              </tr>
            </thead>
            <tbody>
              <?php foreach($props_keys as $prop) { ?>
                <tr>
                  <td><?php echo htmlspecialchars($prop,ENT_QUOTES,'UTF-8'); ?></td>
                  <td><?php echo htmlspecialchars(_2str($route->$prop),ENT_QUOTES,'UTF-8'); ?></td>
                </tr>
              <?php } ?>
            </tbody>
          </table>
        </td>
        <td>
          <?php if($runtimeLogger) { ?>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('title', $loggerId), array('href', (url('debug/LoggerDelete',array('loggerId'=>$loggerId)))), array('onclick', 'return confirm(\'CONFIRM?\');')), 'html5', 'UTF-8'); ?>>
              <div class="icon-trash"></div>
            </a>
          <?php } ?>
        </td>
      </tr>
    <?php } ?>
  </tbody>
</table>
<hr />
<h3>
  <?php echo htmlspecialchars('Write log',ENT_QUOTES,'UTF-8'); ?>
</h3>
<form <?php echo MtHaml\Runtime::renderAttributes(array(array('method', 'get'), array('action', (url('debug/LoggersLog')))), 'html5', 'UTF-8'); ?>>
  <label id="message_label" for="message_data"><?php echo htmlspecialchars('Message:',ENT_QUOTES,'UTF-8'); ?></label>
  <input id="message_data" type="text" name="message" value="Fill me" />
  <label id="level_label" for="level_data"><?php echo htmlspecialchars('Message:',ENT_QUOTES,'UTF-8'); ?></label>
  <select id="level_data" name="level">
    <option value="info" selected="selected"><?php echo htmlspecialchars('info',ENT_QUOTES,'UTF-8'); ?></option>
    <option value="trace"><?php echo htmlspecialchars('trace',ENT_QUOTES,'UTF-8'); ?></option>
    <option value="profile"><?php echo htmlspecialchars('profile',ENT_QUOTES,'UTF-8'); ?></option>
    <option value="warning"><?php echo htmlspecialchars('warning',ENT_QUOTES,'UTF-8'); ?></option>
    <option value="error"><?php echo htmlspecialchars('error',ENT_QUOTES,'UTF-8'); ?></option>
  </select>
  <label id="category_label" for="category_data"><?php echo htmlspecialchars('Message:',ENT_QUOTES,'UTF-8'); ?></label>
  <input id="category_data" type="text" name="category" value="custom.log" />
  <br />
  <input type="submit" />
</form>
