<?php $isBlacklist = $plateList->mode == PlateList::MODE_BLACK_LIST; ?>
<?php if($isBlacklist) { ?>
  <?php $imgurl = $plateList->getImageUrl('/images/list_black.png'); ?>
<?php } else { ?>
  <?php $imgurl = $plateList->getImageUrl('/images/list_white.png'); ?>
<?php } ?>
<?php $listType = $isBlacklist ? 'Blacklist' : 'Whitelist';; ?>
<?php $customValidityPeriods = PlateAuthorizationController::getCustomValidityPeriods(); ?>
<?php $gates = array('-1' => t('Every gate')) + PlateAuthorizationController::getGateObjects(); ?>
<?php $times = array('-1' => t('Always')) + TimeSchedule::getTimeScheduleArrayForPlateAuths(); ?>
<?php $types = paramdeep('plateAuthorizations','types'); ?>
<?php $vehicleSources = paramdeep('plateAuthorizations','vehicleSources'); ?>
<?php if($vehicleSources == null || count($vehicleSources) <= 0) { ?>
  <?php $vehicleSources = array(); ?>
<?php } else { ?>
  <?php $vehicleSources = array_merge(array('' => ''), $vehicleSources); ?>
<?php } ?>
<?php if(isEmpty($plateAuthorization->source)) { ?>
  <?php $plateAuthorization->source = paramdeep('plateAuthorizations','default','vehicleSource'); ?>
<?php } ?>
<?php if(count($vehicleSources)>0) { ?>
  <?php if(!array_key_exists(paramdeep('plateAuthorizations','default','vehicleSource'),$vehicleSources)) { ?>
    <?php $vehicleSources[paramdeep('plateAuthorizations','default','vehicleSource')] = paramdeep('plateAuthorizations','default','vehicleSource'); ?>
  <?php } ?>
<?php } ?>
<?php if(!array_key_exists(paramdeep('plateAuthorizations','default','plateAuthType'),$types)) { ?>
  <?php $types[paramdeep('plateAuthorizations','default','plateAuthType')] = paramdeep('plateAuthorizations','default','plateAuthType'); ?>
<?php } ?>
<?php if(!array_key_exists(paramdeep('plateAuthorizations','default','time'),$times)) { ?>
  <?php $times[paramdeep('plateAuthorizations','default','time')] = paramdeep('plateAuthorizations','default','time'); ?>
<?php } ?>
<?php if(!array_key_exists(paramdeep('plateAuthorizations','default','gate'),$gates)) { ?>
  <?php $gates[paramdeep('plateAuthorizations','default','gate')] = paramdeep('plateAuthorizations','default','gate'); ?>
<?php } ?>
<div id="plate-authorization-page">
  <div class="page-header">
    <table width="100%">
      <tr>
        <td>
          <h2>
            <i class="icon-ok-circle"></i>
            <?php if(user()->checkAccess('plate_auth_confirmed') || $isBlacklist) { ?>
              <?php echo htmlspecialchars(Yii::t('app', "Add vehicle").': '.$plateList->getListTitle(),ENT_QUOTES,'UTF-8'); ?>
            <?php } else { ?>
              <?php echo htmlspecialchars(Yii::t('app', "Request to add vehicle").': '.$plateList->getListTitle(),ENT_QUOTES,'UTF-8'); ?>
            <?php } ?>
          </h2>
        </td>
        <td>
          <?php if(!empty($imgurl)) { ?>
            <img <?php echo MtHaml\Runtime::renderAttributes(array(array('src', $imgurl), array('width', '100'), array('align', 'right')), 'html5', 'UTF-8'); ?> />
          <?php } ?>
        </td>
      </tr>
    </table>
  </div>
  <div class="row">
    <div class="sidebar span12">
      <?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm',array('type' => 'horizontal','action' => array("/plateAuthorization/new".$listType."/".$plateList->id),'htmlOptions' => array('id' => 'new-blacklist-form',),)); ?>
      <div id="plate-authorization-data" class="row">
        <fieldset>
          <div class="plate-authorization-container">
            <div class="row">
              <div class="vehicle-data span4">
                <h4>
                  <?php echo htmlspecialchars(t("Vehicle"),ENT_QUOTES,'UTF-8'); ?>
                </h4>
                <?php $plates = $plateAuthorization->getPlates(); ?>
                <?php $platesCount = count($plates); ?>
                <?php $platesCount = $platesCount <= 0 ? 1 : $platesCount; ?>
                <?php echo $form->textAreaRow($plateAuthorization, 'plate', array('class' => 'span2 touppercase', 'rows'=>$platesCount)); ?>
                <?php if(!paramdeep('plateAuthorizations','rapidInsert','hideVehicleModel')) { ?>
                  <?php echo $form->textFieldRow($plateAuthorization, 'vehicleModel', array('class' => 'span2')); ?>
                <?php } ?>
                <?php echo $form->dropDownListRow($plateAuthorization,'vehicleNationality', array_merge(array('' => ''), CountryList::localized()), array('class'=>'span2  chzn-select', 'data-placeholder' => Yii::t('app', 'Country...')));; ?>
                <?php if(!paramdeep('plateAuthorizations','rapidInsert','hideVehicleType')) { ?>
                  <?php echo $form->dropDownListRow($plateAuthorization,'vehicleType',array_merge(array('' => ''), VehicleTypes::localized()), array('class'=>'span2 chzn-select', 'data-placeholder' => Yii::t('app', 'Class...')));; ?>
                <?php } ?>
                <?php if($isBlacklist) { ?>
                  <?php echo $form->dropDownListRow($plateAuthorization,'vehicleCategory',array_merge(array('' => ''), VehicleCategory::getCategoryList()), array('class'=>'span2 chzn-select', 'data-placeholder' => Yii::t('app', 'Category...')));; ?>
                <?php } ?>
                <h4>
                  <?php echo htmlspecialchars(t("Vehicle Owner") ,ENT_QUOTES,'UTF-8'); ?>
                </h4>
                <?php echo $form->textFieldRow($plateAuthorization, 'name', array('class' => 'span2')); ?>
                <?php echo $form->textFieldRow($plateAuthorization, 'surname', array('class' => 'span2')); ?>
                <?php if(!$isBlacklist) { ?>
                  <?php if(user()->checkAccess('vehicle_owner_management_contacts') || user()->checkAccess('vehicle_owner_management_identity') || user()->checkAccess('vehicle_owner_management_full') || user()->checkAccess('vehicle_owner_create')) { ?>
                    <?php if(!paramdeep('plateAuthorizations','rapidInsert','hideEmail') || !paramdeep('plateAuthorizations','rapidInsert','hidePhone') || !paramdeep('plateAuthorizations','rapidInsert','hideAddress') || !paramdeep('plateAuthorizations','rapidInsert','hideCity')) { ?>
                      <?php if(!paramdeep('plateAuthorizations','rapidInsert','hideEmail')) { ?>
                        <?php echo $form->textFieldRow($plateAuthorization, 'email', array('class' => 'span2')); ?>
                      <?php } ?>
                      <?php if(!paramdeep('plateAuthorizations','rapidInsert','hidePhone')) { ?>
                        <?php echo $form->textFieldRow($plateAuthorization, 'phone', array('class' => 'span2')); ?>
                      <?php } ?>
                      <?php if(!paramdeep('plateAuthorizations','rapidInsert','hideAddress')) { ?>
                        <?php echo $form->textFieldRow($plateAuthorization, 'address', array('class' => 'span2')); ?>
                      <?php } ?>
                      <?php if(!paramdeep('plateAuthorizations','rapidInsert','hideCity')) { ?>
                        <?php echo $form->textFieldRow($plateAuthorization, 'city', array('class' => 'span2')); ?>
                      <?php } ?>
                    <?php } ?>
                    <?php echo $form->checkBoxRow($plateAuthorization, 'overwriteVehicleOwner'); ?>
                  <?php } ?>
                  <h4>
                    <?php echo htmlspecialchars(t("Plate authorization"),ENT_QUOTES,'UTF-8'); ?>
                    <?php if(!paramdeep('plateAuthorizations','rapidInsert','hideAuthType')) { ?>
                      <?php echo $form->dropDownListRow($plateAuthorization,'type', $types, array('class'=>'span2 chzn-select', 'data-placeholder' => Yii::t('app', 'Type...')));; ?>
                    <?php } else { ?>
                      <?php echo $form->hiddenField($plateAuthorization,'type'); ?>
                    <?php } ?>
                    <?php echo $form->dropDownListRow($plateAuthorization,'filterGate', $gates, array('class'=>'span2 chzn-select', 'data-placeholder' => Yii::t('app', 'Gate...')));; ?>
                    <?php echo $form->dropDownListRow($plateAuthorization,'filterTime', $times, array('class'=>'span2 chzn-select', 'data-placeholder' => Yii::t('app', 'Time...')));; ?>
                  </h4>
                <?php } ?>
              </div>
              <div class="management-data span8">
                <h4>
                  <?php echo htmlspecialchars(t($isBlacklist ? "Alert duration" : "Validity Period"),ENT_QUOTES,'UTF-8'); ?>
                </h4>
                <div class="control-group">
                  <div class="btn-group" id="when-buttons">
                    <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', ('today')), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('Today'),ENT_QUOTES,'UTF-8'); ?>
                    </button>
                    <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', ('thisweek')), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('This week'),ENT_QUOTES,'UTF-8'); ?>
                    </button>
                    <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', ('thismonth')), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('This month'),ENT_QUOTES,'UTF-8'); ?>
                    </button>
                    <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', ('thisyear')), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('This year'),ENT_QUOTES,'UTF-8'); ?>
                    </button>
                    <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', ('always')), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime')), array('id', 'alwaysButton')), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('Always'),ENT_QUOTES,'UTF-8'); ?>
                    </button>
                  </div>
                </div>
                <?php if(!$isBlacklist) { ?>
                  <div class="control-group">
                    <div class="btn-group" id="when-buttons">
                      <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', ('tomorrow')), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars(t('Tomorrow'),ENT_QUOTES,'UTF-8'); ?>
                      </button>
                      <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', ('nextweek')), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars(t('Next week'),ENT_QUOTES,'UTF-8'); ?>
                      </button>
                      <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', ('nextmonth')), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars(t('Next month'),ENT_QUOTES,'UTF-8'); ?>
                      </button>
                      <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', ('nextyear')), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars(t('Next year'),ENT_QUOTES,'UTF-8'); ?>
                      </button>
                    </div>
                  </div>
                <?php } ?>
                <?php if(is_array_ex($customValidityPeriods,true)) { ?>
                  <div class="control-group">
                    <div class="btn-group" id="when-buttons">
                      <?php $btnCVPindex=0; ?>
                      <?php foreach($customValidityPeriods as $cvpLabel => $cvpDate) { ?>
                        <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', $cvpDate), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
                          <?php echo htmlspecialchars($cvpLabel,ENT_QUOTES,'UTF-8'); ?>
                        </button>
                        <?php $btnCVPindex++; ?>
                        <?php if($btnCVPindex % 4 == 0 && $btnCVPindex > 0) { ?>
                          <br />
                        <?php } ?>
                      <?php } ?>
                    </div>
                  </div>
                <?php } ?>
                <?php echo htmlspecialchars(t('From'),ENT_QUOTES,'UTF-8'); ?>
                <br />
                <div class="control-group">
                  <input <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('date-picker' . ' ' . 'span2')), array('id', ('startDate')), array('type', ('text')), array('name', ('NewBlacklistForm[startDate]')), array('value', ($plateAuthorization->startDate)), array('readonly', ('true'))), 'html5', 'UTF-8'); ?> />
                  <input id="end-timestamp" type="hidden" />
                  <span class="add-on icon-calendar"></span>
                  <div id="datepicker-start-time" class="input-prepend input-append time-picker">
                    <span class="add-on"></span>
                    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'span1'), array('data-format', (Yii::app()->params['timeselect_format'][Yii::app()->language]['view'])), array('type', 'text'), array('id', 'startTime'), array('name', 'NewBlacklistForm[startTime]'), array('value', ($plateAuthorization->startTime))), 'html5', 'UTF-8'); ?> />
                    <span class="add-on">
                      <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
                    </span>
                  </div>
                </div>
                <?php echo htmlspecialchars(t('To'),ENT_QUOTES,'UTF-8'); ?>
                <br />
                <div class="control-group">
                  <?php if($isBlackList) { ?>
                    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('date-picker' . ' ' . 'span2')), array('id', ('endDate')), array('type', ('text')), array('name', ('NewBlacklistForm[endDate]')), array('value', ($plateAuthorization->endDate)), array('readonly', ('true'))), 'html5', 'UTF-8'); ?> />
                  <?php } else { ?>
                    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('date-picker' . ' ' . 'span2')), array('id', ('endDate')), array('type', ('text')), array('name', ('NewBlacklistForm[endDate]')), array('value', ($plateAuthorization->endDate)), array('readonly', ('true'))), 'html5', 'UTF-8'); ?> />
                  <?php } ?>
                  <input id="start-timestamp" type="hidden" />
                  <span class="add-on icon-calendar"></span>
                  <div id="datepicker-end-time" class="input-prepend input-append time-picker">
                    <span class="add-on"></span>
                    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'span1'), array('data-format', (Yii::app()->params['timeselect_format'][Yii::app()->language]['view'])), array('type', 'text'), array('id', 'endTime'), array('name', 'NewBlacklistForm[endTime]'), array('value', ($plateAuthorization->endTime))), 'html5', 'UTF-8'); ?> />
                    <span class="add-on">
                      <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
                    </span>
                  </div>
                </div>
                <?php if(!paramdeep('plateAuthorizations','rapidInsert','hideSource') || !paramdeep('plateAuthorizations','rapidInsert','hideAction') || !paramdeep('plateAuthorizations','rapidInsert','hideNote')) { ?>
                  <h4>
                    <?php echo htmlspecialchars(t("Additional informations"),ENT_QUOTES,'UTF-8'); ?>
                  </h4>
                  <?php if(!$isBlacklist) { ?>
                    <?php if(!paramdeep('plateAuthorizations','rapidInsert','hideSource')) { ?>
                      <?php if(count($vehicleSources)>0) { ?>
                        <?php echo $form->dropDownListRow($plateAuthorization,'source', $vehicleSources, array('class'=>'span2  chzn-select', 'data-placeholder' => Yii::t('app', 'Source...')));; ?>
                      <?php } else { ?>
                        <?php echo $form->textFieldRow($plateAuthorization, 'source', array('class' => 'span2')); ?>
                      <?php } ?>
                    <?php } ?>
                    <?php if(!paramdeep('plateAuthorizations','rapidInsert','hideAction')) { ?>
                      <?php echo $form->textAreaRow($plateAuthorization, 'action', array('class' => 'span2', 'maxlength' => '250')); ?>
                    <?php } ?>
                  <?php } ?>
                  <?php if(!paramdeep('plateAuthorizations','rapidInsert','hideNote')) { ?>
                    <?php $scriptNote = $this->getSuggestionsJSForWLT('note', $plateList->code); ?>
                    <?php if($scriptNote!=null) { ?>
                      <?php echo $scriptNote; ?>
                      <?php echo $form->textAreaRow($plateAuthorization, 'note', array('class' => 'auto_note span2', 'maxlength' => '250')); ?>
                    <?php } else { ?>
                      <?php echo $form->textAreaRow($plateAuthorization, 'note', array('class' => 'span2', 'maxlength' => '250')); ?>
                    <?php } ?>
                  <?php } ?>
                <?php } ?>
              </div>
            </div>
          </div>
        </fieldset>
        <?php echo $form->errorSummary($plateAuthorization); ?>
      </div>
      <?php $this->endWidget(); ?>
      <button <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'save-btn'), array('class', 'btn'), array('type', 'button'), array('data-confirm-text', (Yii::t('app', 'Confirm'))), array('data-form-action', (Yii::app()->createUrl('plateAuthorization/new'.$listType, array('plateListId'=> $plateList->id)))), array('data-target', '#new-blacklist-form')), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Create'),ENT_QUOTES,'UTF-8'); ?></button>
    </div>
  </div>
</div>
<?php if(!empty($plateAuthorization->startDate)) { ?>
  <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('value', ($plateAuthorization->startDate)), array('id', 'tmpSetStartDate')), 'html5', 'UTF-8'); ?> />
  <script type="text/javascript">
  //<![CDATA[
    setTimeout(function(){
      $('#startDate').val($('#tmpSetStartDate').val());
    }, 500);
  //]]>
  </script>
<?php } ?>
<?php if(!empty($plateAuthorization->endDate)) { ?>
  <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('value', ($plateAuthorization->endDate)), array('id', 'tmpSetEndDate')), 'html5', 'UTF-8'); ?> />
  <script type="text/javascript">
  //<![CDATA[
    setTimeout(function(){
      $('#endDate').val($('#tmpSetEndDate').val());
    }, 500);
    
  //]]>
  </script>
<?php } ?>
<?php if($isBlacklist) { ?>
  <script type="text/javascript">
    <?php echo "$('#alwaysButton').addClass('active')"; ?>
  </script>
<?php } ?>
