<?php
/** @var CustomPlateTypeController $this */
/** @var CustomPlateType $model */

$this->menu=array(
	array('label'=>t('Create CustomPlateType'),'url'=>array('create'),'visible'=>user()->checkAccess('custom_plate_type_create')),
);

?>
<h1>Manage Custom Plate Types</h1>

<?php $this->widget('bootstrap.widgets.TbGridView',array(
	'id'=>'custom-plate-type-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'id',
		'type',
		'label',
		'description',
		'is_default',
    array(
          'class'=>'bootstrap.widgets.TbButtonColumn',
          'buttons'=>array
          (
            'view' => array
            (
                'label'=>t('View'),                
                'visible'=>'user()->checkAccess("custom_plate_type_view")',
            ),
            'update' => array
            (
                'label'=>t('Update'),                
                'visible'=>'user()->checkAccess("custom_plate_type_update")',
            ),
            'delete' => array
            (
                'label'=>t('Delete'),                
                'visible'=>'user()->checkAccess("custom_plate_type_delete")',
                'click'=>"return confirm('".t('Do you confirm?')."');",
            ),
          ),
        ),
	),
)); ?>
