#= require ./behavior

class EventExportImages
  basicUrl: settings.baseUrl+'/debug/'

  constructor: (@eventId, @eventExportTime, @nuclearExportEventImages) ->
    @eventExportRow = $("#eventExport-"+@eventId)


  exportImages: (sender)->
    action = 'exportSingleEventImages'
    $(sender).attr('disabled', 'disabled')


    $.ajax
      type: 'POST'
      url: @basicUrl+action+'?eventId='+@eventId+'&eventTime='+@eventExportTime
      success: (html) =>
        @nuclearExportEventImages.nuclearifyAll()
        new FlashMessage('success', 'Exported').show()
      error: (e) ->
        new FlashMessage('error', e.responseText).show()
        $(sender).removeAttribute('disable')

  


class window.nuclearExportEventImages extends window.Behavior
  init: ->
    @nuclearifyAll()

  nuclearifyAll: ->
    @nuclearifyButton('export-images', 'exportImages')


  nuclearifyButton: (buttonClass, action) ->
    self = @
    $(".#{buttonClass}[data-nuclear-botton!=nuclear]").each ->
      button = $(this)
      button.nuclear
        alertText: button.data('confirm-text')
        delay: 0
        useOnce: true
        onClick: ->
          new EventExportImages(button.data('event-id'), button.data('event-export-time'), self)[action]()
