<?php

class ReportArchiveSearchForm extends CFormModel
{
	public $startDateTime;
	public $endDateTime;
	public $gateGroups;
	public $users;
	public $ADIcodeFrom;
	public $ADIcodeTo;
	
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('startDateTime, endDateTime', 'date', 'format'=>'yyyy-M-d H:m:s'),
			array('endDateTime','compare','compareAttribute'=>'startDateTime','operator'=>'>', 'allowEmpty'=>false, 'message'=>'{attribute} must be greater than "{compareValue}".'),
			array('gateGroups', 'array'),
			array('users', 'array'),
			array('ADIcodeFrom, ADIcodeTo', 'integer'),
			array('startDateTime, endDateTime, gateGroups, users, ADIcodeFrom, ADIcodeTo', 'safe')
		);
	}
	
}

?>