<?php

/**
 * 
 * @author p.treu
 * @property integer $id
 * @property string $name
 * @property integer $id_behavior
 * @property string $description
 * @property integer $has_goods
 */
class ViolationCode extends ActiveRecord
{

  /**
   *
   * @param system $className          
   * @return ViolationCode
   */
  public static function model($className = __CLASS__)
  {
    return parent::model ( $className );
  }

  public function tableName()
  {
    return 'violation_codes';
  }

  public function defaultScope()
  {
    $alias = $this->getTableAlias ( false, false );
    
    return array (
        'order' => "$alias.name ASC" 
    );
  }

  public function filterByBehaviorId($id)
  {
    $this->getDbCriteria ()
      ->mergeWith ( array (
        'condition' => 'id_behavior = :id',
        'params' => array (
            ':id' => $id 
        ) 
    ) );
    return $this;
  }

  public function byName($name)
  {
    $this->getDbCriteria ()
      ->mergeWith ( array (
        'condition' => 'name = :the_name',
        'params' => array (
            ':the_name' => $name 
        ) 
    ) );
    return $this;
  }

  public static function hasChoicesForBehavior($idBehavior)
  {
    $res = ViolationCode::model ()->filterByBehaviorId ( $idBehavior )
      ->count ();
    
    return $res;
  }

  public static function getUniqueChoiceForBehavior($idBehavior)
  {
    $res = ViolationCode::model ()->filterByBehaviorId ( $idBehavior )
      ->findAll ();
    if ($res == null)
      return null;
    
    if (count ( $res ) != 1)
      return null;
    
    return $res;
  }

  /**
   *
   * @return array validation rules for model attributes.
   */
  public function rules()
  {
    // NOTE: you should only define rules for those attributes that
    // will receive user inputs.
    return array (
        array (
            'name, id_behavior',
            'required' 
        ),
        array (
            'id_behavior, has_goods',
            'numerical',
            'integerOnly' => true 
        ),
        array (
            'name',
            'length',
            'max' => 255 
        ),
        array (
            'description',
            'safe' 
        ),
        // The following rule is used by search().
        // Please remove those attributes that should not be searched.
        array (
            'id, name, id_behavior, description, has_goods',
            'safe',
            'on' => 'search' 
        ) 
    );
  }

  /**
   *
   * @return array relational rules.
   */
  public function relations()
  {
    // NOTE: you may need to adjust the relation name and the related
    // class name for the relations automatically generated below.
    return array ();
  }

  /**
   *
   * @return array customized attribute labels (name=>label)
   */
  public function myAttributeLabels()
  {
    return array (
        'id' => 'ID',
        'name' => t ( 'Name' ),
        'id_behavior' => t ( 'Behavior' ),
        'description' => t ( 'Description' ),
        'has_goods' => t ( 'Has Goods' ) 
    );
  }

  /**
   * Retrieves a list of models based on the current search/filter conditions.
   * 
   * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
   */
  public function search()
  {
    // Warning: Please modify the following code to remove attributes that
    // should not be searched.
    $criteria = new CDbCriteria ();
    
    $criteria->compare ( 'id', $this->id );
    $criteria->compare ( 'name', $this->name, true );
    $criteria->compare ( 'id_behavior', $this->id_behavior );
    $criteria->compare ( 'description', $this->description, true );
    $criteria->compare ( 'has_goods', $this->has_goods );
    
    return new CActiveDataProvider ( $this, array (
        'criteria' => $criteria 
    ) );
  }
}
